/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.db.mpp.plan.execution.IQueryExecution;
import org.apache.iotdb.db.tools.watermark.WatermarkEncoder;
import org.apache.iotdb.service.rpc.thrift.TSQueryDataSet;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.utils.BytesUtils;

public class QueryDataSetUtils {
    private static final int FLAG = 1;

    private QueryDataSetUtils() {
    }

    public static TSQueryDataSet convertQueryDataSetByFetchSize(QueryDataSet queryDataSet, int fetchSize, WatermarkEncoder watermarkEncoder) throws IOException {
        int columnNum = queryDataSet.getColumnNum();
        TSQueryDataSet tsQueryDataSet = new TSQueryDataSet();
        int columnNumWithTime = columnNum * 2 + 1;
        DataOutputStream[] dataOutputStreams = new DataOutputStream[columnNumWithTime];
        ByteArrayOutputStream[] byteArrayOutputStreams = new ByteArrayOutputStream[columnNumWithTime];
        for (int i = 0; i < columnNumWithTime; ++i) {
            byteArrayOutputStreams[i] = new ByteArrayOutputStream();
            dataOutputStreams[i] = new DataOutputStream(byteArrayOutputStreams[i]);
        }
        int rowCount = 0;
        int[] valueOccupation = new int[columnNum];
        int[] bitmap = new int[columnNum];
        for (int i = 0; i < fetchSize && queryDataSet.hasNext(); ++i) {
            RowRecord rowRecord = queryDataSet.next();
            if (queryDataSet.withoutNullFilter(rowRecord)) {
                queryDataSet.decreaseAlreadyReturnedRowNum();
                --i;
                continue;
            }
            if (watermarkEncoder != null) {
                rowRecord = watermarkEncoder.encodeRecord(rowRecord);
            }
            dataOutputStreams[0].writeLong(rowRecord.getTimestamp());
            List fields = rowRecord.getFields();
            block10: for (int k = 0; k < fields.size(); ++k) {
                Field field = (Field)fields.get(k);
                DataOutputStream dataOutputStream = dataOutputStreams[2 * k + 1];
                if (field == null || field.getDataType() == null) {
                    bitmap[k] = bitmap[k] << 1;
                    continue;
                }
                bitmap[k] = bitmap[k] << 1 | 1;
                TSDataType type = field.getDataType();
                switch (type) {
                    case INT32: {
                        dataOutputStream.writeInt(field.getIntV());
                        int n = k;
                        valueOccupation[n] = valueOccupation[n] + 4;
                        continue block10;
                    }
                    case INT64: {
                        dataOutputStream.writeLong(field.getLongV());
                        int n = k;
                        valueOccupation[n] = valueOccupation[n] + 8;
                        continue block10;
                    }
                    case FLOAT: {
                        dataOutputStream.writeFloat(field.getFloatV());
                        int n = k;
                        valueOccupation[n] = valueOccupation[n] + 4;
                        continue block10;
                    }
                    case DOUBLE: {
                        dataOutputStream.writeDouble(field.getDoubleV());
                        int n = k;
                        valueOccupation[n] = valueOccupation[n] + 8;
                        continue block10;
                    }
                    case BOOLEAN: {
                        dataOutputStream.writeBoolean(field.getBoolV());
                        int n = k;
                        valueOccupation[n] = valueOccupation[n] + 1;
                        continue block10;
                    }
                    case TEXT: {
                        dataOutputStream.writeInt(field.getBinaryV().getLength());
                        dataOutputStream.write(field.getBinaryV().getValues());
                        valueOccupation[k] = valueOccupation[k] + 4 + field.getBinaryV().getLength();
                        continue block10;
                    }
                    default: {
                        throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", type));
                    }
                }
            }
            if (++rowCount % 8 != 0) continue;
            for (int j = 0; j < bitmap.length; ++j) {
                DataOutputStream dataBitmapOutputStream = dataOutputStreams[2 * (j + 1)];
                dataBitmapOutputStream.writeByte(bitmap[j]);
                bitmap[j] = 0;
            }
        }
        int remaining = rowCount % 8;
        if (remaining != 0) {
            for (int j = 0; j < bitmap.length; ++j) {
                DataOutputStream dataBitmapOutputStream = dataOutputStreams[2 * (j + 1)];
                dataBitmapOutputStream.writeByte(bitmap[j] << 8 - remaining);
            }
        }
        int timeOccupation = rowCount * 8;
        ByteBuffer timeBuffer = ByteBuffer.allocate(timeOccupation);
        timeBuffer.put(byteArrayOutputStreams[0].toByteArray());
        timeBuffer.flip();
        tsQueryDataSet.setTime(timeBuffer);
        int bitmapOccupation = rowCount / 8 + (rowCount % 8 == 0 ? 0 : 1);
        LinkedList<ByteBuffer> bitmapList = new LinkedList<ByteBuffer>();
        LinkedList<ByteBuffer> valueList = new LinkedList<ByteBuffer>();
        for (int i = 1; i < byteArrayOutputStreams.length; i += 2) {
            ByteBuffer valueBuffer = ByteBuffer.allocate(valueOccupation[(i - 1) / 2]);
            valueBuffer.put(byteArrayOutputStreams[i].toByteArray());
            valueBuffer.flip();
            valueList.add(valueBuffer);
            ByteBuffer bitmapBuffer = ByteBuffer.allocate(bitmapOccupation);
            bitmapBuffer.put(byteArrayOutputStreams[i + 1].toByteArray());
            bitmapBuffer.flip();
            bitmapList.add(bitmapBuffer);
        }
        tsQueryDataSet.setBitmapList(bitmapList);
        tsQueryDataSet.setValueList(valueList);
        return tsQueryDataSet;
    }

    public static TSQueryDataSet convertTsBlockByFetchSize(IQueryExecution queryExecution, int fetchSize) throws IOException, IoTDBException {
        Optional<TsBlock> optionalTsBlock;
        int columnNum = queryExecution.getOutputValueColumnCount();
        TSQueryDataSet tsQueryDataSet = new TSQueryDataSet();
        int columnNumWithTime = columnNum * 2 + 1;
        DataOutputStream[] dataOutputStreams = new DataOutputStream[columnNumWithTime];
        ByteArrayOutputStream[] byteArrayOutputStreams = new ByteArrayOutputStream[columnNumWithTime];
        for (int i = 0; i < columnNumWithTime; ++i) {
            byteArrayOutputStreams[i] = new ByteArrayOutputStream();
            dataOutputStreams[i] = new DataOutputStream(byteArrayOutputStreams[i]);
        }
        int rowCount = 0;
        int[] valueOccupation = new int[columnNum];
        int[] bitmaps = new int[columnNum];
        while (rowCount < fetchSize && (optionalTsBlock = queryExecution.getBatchResult()).isPresent()) {
            TsBlock tsBlock = optionalTsBlock.get();
            if (tsBlock.isEmpty()) continue;
            int currentCount = tsBlock.getPositionCount();
            for (int i = 0; i < currentCount; ++i) {
                dataOutputStreams[0].writeLong(tsBlock.getTimeByIndex(i));
            }
            for (int k = 0; k < columnNum; ++k) {
                DataOutputStream dataOutputStream = dataOutputStreams[2 * k + 1];
                DataOutputStream dataBitmapOutputStream = dataOutputStreams[2 * (k + 1)];
                Column column = tsBlock.getColumn(k);
                TSDataType type = column.getDataType();
                switch (type) {
                    case INT32: {
                        int i;
                        for (i = 0; i < currentCount; ++i) {
                            ++rowCount;
                            if (column.isNull(i)) {
                                bitmaps[k] = bitmaps[k] << 1;
                            } else {
                                bitmaps[k] = bitmaps[k] << 1 | 1;
                                dataOutputStream.writeInt(column.getInt(i));
                                int n = k;
                                valueOccupation[n] = valueOccupation[n] + 4;
                            }
                            if (rowCount == 0 || rowCount % 8 != 0) continue;
                            dataBitmapOutputStream.writeByte(bitmaps[k]);
                            bitmaps[k] = 0;
                        }
                        break;
                    }
                    case INT64: {
                        int i;
                        for (i = 0; i < currentCount; ++i) {
                            ++rowCount;
                            if (column.isNull(i)) {
                                bitmaps[k] = bitmaps[k] << 1;
                            } else {
                                bitmaps[k] = bitmaps[k] << 1 | 1;
                                dataOutputStream.writeLong(column.getLong(i));
                                int n = k;
                                valueOccupation[n] = valueOccupation[n] + 8;
                            }
                            if (rowCount == 0 || rowCount % 8 != 0) continue;
                            dataBitmapOutputStream.writeByte(bitmaps[k]);
                            bitmaps[k] = 0;
                        }
                        break;
                    }
                    case FLOAT: {
                        int i;
                        for (i = 0; i < currentCount; ++i) {
                            ++rowCount;
                            if (column.isNull(i)) {
                                bitmaps[k] = bitmaps[k] << 1;
                            } else {
                                bitmaps[k] = bitmaps[k] << 1 | 1;
                                dataOutputStream.writeFloat(column.getFloat(i));
                                int n = k;
                                valueOccupation[n] = valueOccupation[n] + 4;
                            }
                            if (rowCount == 0 || rowCount % 8 != 0) continue;
                            dataBitmapOutputStream.writeByte(bitmaps[k]);
                            bitmaps[k] = 0;
                        }
                        break;
                    }
                    case DOUBLE: {
                        int i;
                        for (i = 0; i < currentCount; ++i) {
                            ++rowCount;
                            if (column.isNull(i)) {
                                bitmaps[k] = bitmaps[k] << 1;
                            } else {
                                bitmaps[k] = bitmaps[k] << 1 | 1;
                                dataOutputStream.writeDouble(column.getDouble(i));
                                int n = k;
                                valueOccupation[n] = valueOccupation[n] + 8;
                            }
                            if (rowCount == 0 || rowCount % 8 != 0) continue;
                            dataBitmapOutputStream.writeByte(bitmaps[k]);
                            bitmaps[k] = 0;
                        }
                        break;
                    }
                    case BOOLEAN: {
                        int i;
                        for (i = 0; i < currentCount; ++i) {
                            ++rowCount;
                            if (column.isNull(i)) {
                                bitmaps[k] = bitmaps[k] << 1;
                            } else {
                                bitmaps[k] = bitmaps[k] << 1 | 1;
                                dataOutputStream.writeBoolean(column.getBoolean(i));
                                int n = k;
                                valueOccupation[n] = valueOccupation[n] + 1;
                            }
                            if (rowCount == 0 || rowCount % 8 != 0) continue;
                            dataBitmapOutputStream.writeByte(bitmaps[k]);
                            bitmaps[k] = 0;
                        }
                        break;
                    }
                    case TEXT: {
                        int i;
                        for (i = 0; i < currentCount; ++i) {
                            ++rowCount;
                            if (column.isNull(i)) {
                                bitmaps[k] = bitmaps[k] << 1;
                            } else {
                                bitmaps[k] = bitmaps[k] << 1 | 1;
                                Binary binary = column.getBinary(i);
                                dataOutputStream.writeInt(binary.getLength());
                                dataOutputStream.write(binary.getValues());
                                valueOccupation[k] = valueOccupation[k] + 4 + binary.getLength();
                            }
                            if (rowCount == 0 || rowCount % 8 != 0) continue;
                            dataBitmapOutputStream.writeByte(bitmaps[k]);
                            bitmaps[k] = 0;
                        }
                        break;
                    }
                    default: {
                        throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", type));
                    }
                }
                if (k == columnNum - 1) continue;
                rowCount -= currentCount;
            }
        }
        int remaining = rowCount % 8;
        for (int k = 0; k < columnNum; ++k) {
            if (remaining == 0) continue;
            DataOutputStream dataBitmapOutputStream = dataOutputStreams[2 * (k + 1)];
            dataBitmapOutputStream.writeByte(bitmaps[k] << 8 - remaining);
        }
        int timeOccupation = rowCount * 8;
        ByteBuffer timeBuffer = ByteBuffer.allocate(timeOccupation);
        timeBuffer.put(byteArrayOutputStreams[0].toByteArray());
        timeBuffer.flip();
        tsQueryDataSet.setTime(timeBuffer);
        int bitmapOccupation = (rowCount + 7) / 8;
        LinkedList<ByteBuffer> bitmapList = new LinkedList<ByteBuffer>();
        LinkedList<ByteBuffer> valueList = new LinkedList<ByteBuffer>();
        for (int i = 1; i < byteArrayOutputStreams.length; i += 2) {
            ByteBuffer valueBuffer = ByteBuffer.allocate(valueOccupation[(i - 1) / 2]);
            valueBuffer.put(byteArrayOutputStreams[i].toByteArray());
            valueBuffer.flip();
            valueList.add(valueBuffer);
            ByteBuffer bitmapBuffer = ByteBuffer.allocate(bitmapOccupation);
            bitmapBuffer.put(byteArrayOutputStreams[i + 1].toByteArray());
            bitmapBuffer.flip();
            bitmapList.add(bitmapBuffer);
        }
        tsQueryDataSet.setBitmapList(bitmapList);
        tsQueryDataSet.setValueList(valueList);
        return tsQueryDataSet;
    }

    public static long[] readTimesFromBuffer(ByteBuffer buffer, int size) {
        long[] times = new long[size];
        for (int i = 0; i < size; ++i) {
            times[i] = buffer.getLong();
        }
        return times;
    }

    public static long[] readTimesFromStream(DataInputStream stream, int size) throws IOException {
        long[] times = new long[size];
        for (int i = 0; i < size; ++i) {
            times[i] = stream.readLong();
        }
        return times;
    }

    public static BitMap[] readBitMapsFromBuffer(ByteBuffer buffer, int columns, int size) {
        if (!buffer.hasRemaining()) {
            return null;
        }
        BitMap[] bitMaps = new BitMap[columns];
        for (int i = 0; i < columns; ++i) {
            boolean hasBitMap = BytesUtils.byteToBool((byte)buffer.get());
            if (!hasBitMap) continue;
            byte[] bytes = new byte[size / 8 + 1];
            for (int j = 0; j < bytes.length; ++j) {
                bytes[j] = buffer.get();
            }
            bitMaps[i] = new BitMap(size, bytes);
        }
        return bitMaps;
    }

    public static BitMap[] readBitMapsFromStream(DataInputStream stream, int columns, int size) throws IOException {
        if (stream.available() <= 0) {
            return null;
        }
        BitMap[] bitMaps = new BitMap[columns];
        for (int i = 0; i < columns; ++i) {
            boolean hasBitMap = BytesUtils.byteToBool((byte)stream.readByte());
            if (!hasBitMap) continue;
            byte[] bytes = new byte[size / 8 + 1];
            for (int j = 0; j < bytes.length; ++j) {
                bytes[j] = stream.readByte();
            }
            bitMaps[i] = new BitMap(size, bytes);
        }
        return bitMaps;
    }

    public static Object[] readTabletValuesFromBuffer(ByteBuffer buffer, List<Integer> types, int columns, int size) {
        TSDataType[] dataTypes = new TSDataType[types.size()];
        for (int i = 0; i < dataTypes.length; ++i) {
            dataTypes[i] = TSDataType.values()[types.get(i)];
        }
        return QueryDataSetUtils.readTabletValuesFromBuffer(buffer, dataTypes, columns, size);
    }

    public static Object[] readTabletValuesFromStream(DataInputStream stream, List<Integer> types, int columns, int size) throws IOException {
        TSDataType[] dataTypes = new TSDataType[types.size()];
        for (int i = 0; i < dataTypes.length; ++i) {
            dataTypes[i] = TSDataType.values()[types.get(i)];
        }
        return QueryDataSetUtils.readTabletValuesFromStream(stream, dataTypes, columns, size);
    }

    public static Object[] readTabletValuesFromBuffer(ByteBuffer buffer, TSDataType[] types, int columns, int size) {
        Object[] values = new Object[columns];
        block8: for (int i = 0; i < columns; ++i) {
            switch (types[i]) {
                case BOOLEAN: {
                    boolean[] boolValues = new boolean[size];
                    for (int index = 0; index < size; ++index) {
                        boolValues[index] = BytesUtils.byteToBool((byte)buffer.get());
                    }
                    values[i] = boolValues;
                    continue block8;
                }
                case INT32: {
                    int[] intValues = new int[size];
                    for (int index = 0; index < size; ++index) {
                        intValues[index] = buffer.getInt();
                    }
                    values[i] = intValues;
                    continue block8;
                }
                case INT64: {
                    long[] longValues = new long[size];
                    for (int index = 0; index < size; ++index) {
                        longValues[index] = buffer.getLong();
                    }
                    values[i] = longValues;
                    continue block8;
                }
                case FLOAT: {
                    float[] floatValues = new float[size];
                    for (int index = 0; index < size; ++index) {
                        floatValues[index] = buffer.getFloat();
                    }
                    values[i] = floatValues;
                    continue block8;
                }
                case DOUBLE: {
                    double[] doubleValues = new double[size];
                    for (int index = 0; index < size; ++index) {
                        doubleValues[index] = buffer.getDouble();
                    }
                    values[i] = doubleValues;
                    continue block8;
                }
                case TEXT: {
                    Binary[] binaryValues = new Binary[size];
                    for (int index = 0; index < size; ++index) {
                        int binarySize = buffer.getInt();
                        byte[] binaryValue = new byte[binarySize];
                        buffer.get(binaryValue);
                        binaryValues[index] = new Binary(binaryValue);
                    }
                    values[i] = binaryValues;
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("data type %s is not supported when convert data at client", types[i]));
                }
            }
        }
        return values;
    }

    public static Object[] readTabletValuesFromStream(DataInputStream stream, TSDataType[] types, int columns, int size) throws IOException {
        Object[] values = new Object[columns];
        block8: for (int i = 0; i < columns; ++i) {
            switch (types[i]) {
                case BOOLEAN: {
                    boolean[] boolValues = new boolean[size];
                    for (int index = 0; index < size; ++index) {
                        boolValues[index] = BytesUtils.byteToBool((byte)stream.readByte());
                    }
                    values[i] = boolValues;
                    continue block8;
                }
                case INT32: {
                    int[] intValues = new int[size];
                    for (int index = 0; index < size; ++index) {
                        intValues[index] = stream.readInt();
                    }
                    values[i] = intValues;
                    continue block8;
                }
                case INT64: {
                    long[] longValues = new long[size];
                    for (int index = 0; index < size; ++index) {
                        longValues[index] = stream.readLong();
                    }
                    values[i] = longValues;
                    continue block8;
                }
                case FLOAT: {
                    float[] floatValues = new float[size];
                    for (int index = 0; index < size; ++index) {
                        floatValues[index] = stream.readFloat();
                    }
                    values[i] = floatValues;
                    continue block8;
                }
                case DOUBLE: {
                    double[] doubleValues = new double[size];
                    for (int index = 0; index < size; ++index) {
                        doubleValues[index] = stream.readDouble();
                    }
                    values[i] = doubleValues;
                    continue block8;
                }
                case TEXT: {
                    Binary[] binaryValues = new Binary[size];
                    for (int index = 0; index < size; ++index) {
                        int binarySize = stream.readInt();
                        byte[] binaryValue = new byte[binarySize];
                        stream.read(binaryValue);
                        binaryValues[index] = new Binary(binaryValue);
                    }
                    values[i] = binaryValues;
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("data type %s is not supported when convert data at client", types[i]));
                }
            }
        }
        return values;
    }
}

