/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.influxdb.handler;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.protocol.influxdb.function.InfluxFunction;
import org.apache.iotdb.db.protocol.influxdb.function.InfluxFunctionValue;
import org.apache.iotdb.db.protocol.influxdb.handler.AbstractQueryHandler;
import org.apache.iotdb.db.protocol.influxdb.meta.InfluxDBMetaManager;
import org.apache.iotdb.db.protocol.influxdb.util.FieldUtils;
import org.apache.iotdb.db.protocol.influxdb.util.QueryResultUtils;
import org.apache.iotdb.db.protocol.influxdb.util.StringUtils;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.SessionManager;
import org.apache.iotdb.db.service.basic.ServiceProvider;
import org.apache.iotdb.tsfile.exception.filter.QueryFilterOptimizationException;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.thrift.TException;
import org.influxdb.InfluxDBException;
import org.influxdb.dto.QueryResult;

public class QueryHandler
extends AbstractQueryHandler {
    @Override
    public Map<String, Integer> getFieldOrders(String database, String measurement, ServiceProvider serviceProvider, long sessionID) {
        HashMap<String, Integer> fieldOrders = new HashMap<String, Integer>();
        long queryId = ServiceProvider.SESSION_MANAGER.requestQueryId(true);
        try {
            String showTimeseriesSql = "show timeseries root." + database + '.' + measurement + ".**";
            PhysicalPlan physicalPlan = serviceProvider.getPlanner().parseSQLToPhysicalPlan(showTimeseriesSql);
            QueryContext queryContext = serviceProvider.genQueryContext(queryId, true, System.currentTimeMillis(), showTimeseriesSql, 0L);
            QueryDataSet queryDataSet = serviceProvider.createQueryDataSet(queryContext, physicalPlan, 5000);
            int fieldNums = 0;
            Map<String, Integer> tagOrders = InfluxDBMetaManager.getTagOrders(database, measurement);
            int tagOrderNums = tagOrders.size();
            while (queryDataSet.hasNext()) {
                List fields = queryDataSet.next().getFields();
                String filed = StringUtils.getFieldByPath(((Field)fields.get(0)).getStringValue());
                if (fieldOrders.containsKey(filed)) continue;
                fieldOrders.put(filed, tagOrderNums + fieldNums + 1);
                ++fieldNums;
            }
        }
        catch (IOException | InterruptedException | SQLException | MetadataException | StorageEngineException | QueryProcessException | QueryFilterOptimizationException | TException e) {
            throw new InfluxDBException(((Throwable)e).getMessage());
        }
        finally {
            ServiceProvider.SESSION_MANAGER.releaseQueryResourceNoExceptions(queryId);
        }
        return fieldOrders;
    }

    @Override
    public InfluxFunctionValue updateByIoTDBFunc(InfluxFunction function, ServiceProvider serviceProvider, String path, long sessionid) {
        switch (function.getFunctionName()) {
            case "count": {
                long queryId = ServiceProvider.SESSION_MANAGER.requestQueryId(true);
                String functionSql = StringUtils.generateFunctionSql(function.getFunctionName(), function.getParmaName(), path);
                try {
                    QueryPlan queryPlan = (QueryPlan)serviceProvider.getPlanner().parseSQLToPhysicalPlan(functionSql);
                    QueryContext queryContext = serviceProvider.genQueryContext(queryId, true, System.currentTimeMillis(), functionSql, 0L);
                    QueryDataSet queryDataSet = serviceProvider.createQueryDataSet(queryContext, queryPlan, 5000);
                    while (queryDataSet.hasNext()) {
                        List fields = queryDataSet.next().getFields();
                        for (Field field : fields) {
                            function.updateValueIoTDBFunc(new InfluxFunctionValue(field.getLongV(), null));
                        }
                    }
                    break;
                }
                catch (IOException | InterruptedException | SQLException | MetadataException | StorageEngineException | QueryProcessException | QueryFilterOptimizationException | TException e) {
                    ((Throwable)e).printStackTrace();
                    throw new InfluxDBException(((Throwable)e).getMessage());
                }
                finally {
                    ServiceProvider.SESSION_MANAGER.releaseQueryResourceNoExceptions(queryId);
                }
            }
            case "mean": {
                long queryId = ServiceProvider.SESSION_MANAGER.requestQueryId(true);
                try {
                    String functionSqlCount = StringUtils.generateFunctionSql("count", function.getParmaName(), path);
                    QueryPlan queryPlan = (QueryPlan)serviceProvider.getPlanner().parseSQLToPhysicalPlan(functionSqlCount);
                    QueryContext queryContext = serviceProvider.genQueryContext(queryId, true, System.currentTimeMillis(), functionSqlCount, 0L);
                    QueryDataSet queryDataSet = serviceProvider.createQueryDataSet(queryContext, queryPlan, 5000);
                    while (queryDataSet.hasNext()) {
                        List fields = queryDataSet.next().getFields();
                        for (Field field : fields) {
                            function.updateValueIoTDBFunc(new InfluxFunctionValue(field.getLongV(), null));
                        }
                    }
                }
                catch (IOException | InterruptedException | SQLException | MetadataException | StorageEngineException | QueryProcessException | QueryFilterOptimizationException | TException e) {
                    throw new InfluxDBException(((Throwable)e).getMessage());
                }
                finally {
                    ServiceProvider.SESSION_MANAGER.releaseQueryResourceNoExceptions(queryId);
                }
                long queryId1 = ServiceProvider.SESSION_MANAGER.requestQueryId(true);
                try {
                    String functionSqlSum = StringUtils.generateFunctionSql("sum", function.getParmaName(), path);
                    QueryPlan queryPlan = (QueryPlan)serviceProvider.getPlanner().parseSQLToPhysicalPlan(functionSqlSum);
                    QueryContext queryContext = serviceProvider.genQueryContext(queryId, true, System.currentTimeMillis(), functionSqlSum, 0L);
                    QueryDataSet queryDataSet = serviceProvider.createQueryDataSet(queryContext, queryPlan, 5000);
                    while (queryDataSet.hasNext()) {
                        List fields = queryDataSet.next().getFields();
                        for (Field field : fields) {
                            function.updateValueIoTDBFunc(null, new InfluxFunctionValue(field.getDoubleV(), null));
                        }
                    }
                    break;
                }
                catch (IOException | InterruptedException | SQLException | MetadataException | StorageEngineException | QueryProcessException | QueryFilterOptimizationException | TException e) {
                    ((Throwable)e).printStackTrace();
                    throw new InfluxDBException(((Throwable)e).getMessage());
                }
                finally {
                    ServiceProvider.SESSION_MANAGER.releaseQueryResourceNoExceptions(queryId1);
                }
            }
            case "spread": {
                long queryId = ServiceProvider.SESSION_MANAGER.requestQueryId(true);
                try {
                    String functionSqlMaxValue = StringUtils.generateFunctionSql("max_value", function.getParmaName(), path);
                    QueryPlan queryPlan = (QueryPlan)serviceProvider.getPlanner().parseSQLToPhysicalPlan(functionSqlMaxValue);
                    QueryContext queryContext = serviceProvider.genQueryContext(queryId, true, System.currentTimeMillis(), functionSqlMaxValue, 0L);
                    QueryDataSet queryDataSet = serviceProvider.createQueryDataSet(queryContext, queryPlan, 5000);
                    while (queryDataSet.hasNext()) {
                        List paths = queryDataSet.getPaths();
                        List fields = queryDataSet.next().getFields();
                        for (int i = 0; i < paths.size(); ++i) {
                            Object o = FieldUtils.iotdbFieldConvert((Field)fields.get(i));
                            if (!(o instanceof Number)) continue;
                            function.updateValueIoTDBFunc(new InfluxFunctionValue(((Number)o).doubleValue(), null));
                        }
                    }
                }
                catch (IOException | InterruptedException | SQLException | MetadataException | StorageEngineException | QueryProcessException | QueryFilterOptimizationException | TException e) {
                    throw new InfluxDBException(((Throwable)e).getMessage());
                }
                finally {
                    ServiceProvider.SESSION_MANAGER.releaseQueryResourceNoExceptions(queryId);
                }
                long queryId1 = ServiceProvider.SESSION_MANAGER.requestQueryId(true);
                try {
                    String functionSqlMinValue = StringUtils.generateFunctionSql("min_value", function.getParmaName(), path);
                    QueryPlan queryPlan = (QueryPlan)serviceProvider.getPlanner().parseSQLToPhysicalPlan(functionSqlMinValue);
                    QueryContext queryContext = serviceProvider.genQueryContext(queryId, true, System.currentTimeMillis(), functionSqlMinValue, 0L);
                    QueryDataSet queryDataSet = serviceProvider.createQueryDataSet(queryContext, queryPlan, 5000);
                    while (queryDataSet.hasNext()) {
                        List paths = queryDataSet.getPaths();
                        List fields = queryDataSet.next().getFields();
                        for (int i = 0; i < paths.size(); ++i) {
                            Object o = FieldUtils.iotdbFieldConvert((Field)fields.get(i));
                            if (!(o instanceof Number)) continue;
                            function.updateValueIoTDBFunc(null, new InfluxFunctionValue(((Number)o).doubleValue(), null));
                        }
                    }
                    break;
                }
                catch (IOException | InterruptedException | SQLException | MetadataException | StorageEngineException | QueryProcessException | QueryFilterOptimizationException | TException e) {
                    throw new InfluxDBException(((Throwable)e).getMessage());
                }
                finally {
                    ServiceProvider.SESSION_MANAGER.releaseQueryResourceNoExceptions(queryId1);
                }
            }
            case "sum": {
                long queryId = ServiceProvider.SESSION_MANAGER.requestQueryId(true);
                try {
                    String functionSql = StringUtils.generateFunctionSql("sum", function.getParmaName(), path);
                    QueryPlan queryPlan = (QueryPlan)serviceProvider.getPlanner().parseSQLToPhysicalPlan(functionSql);
                    QueryContext queryContext = serviceProvider.genQueryContext(queryId, true, System.currentTimeMillis(), functionSql, 0L);
                    QueryDataSet queryDataSet = serviceProvider.createQueryDataSet(queryContext, queryPlan, 5000);
                    while (queryDataSet.hasNext()) {
                        List fields = queryDataSet.next().getFields();
                        if (((Field)fields.get(1)).getDataType() == null) continue;
                        function.updateValueIoTDBFunc(new InfluxFunctionValue(((Field)fields.get(1)).getDoubleV(), null));
                    }
                    break;
                }
                catch (IOException | InterruptedException | SQLException | MetadataException | StorageEngineException | QueryProcessException | QueryFilterOptimizationException | TException e) {
                    throw new InfluxDBException(((Throwable)e).getMessage());
                }
                finally {
                    ServiceProvider.SESSION_MANAGER.releaseQueryResourceNoExceptions(queryId);
                }
            }
            case "first": 
            case "last": {
                String functionSql = function.getFunctionName().equals("first") ? StringUtils.generateFunctionSql("first_value", function.getParmaName(), path) : StringUtils.generateFunctionSql("last_value", function.getParmaName(), path);
                ArrayList<Long> queryIds = new ArrayList<Long>();
                queryIds.add(ServiceProvider.SESSION_MANAGER.requestQueryId(true));
                try {
                    QueryPlan queryPlan = (QueryPlan)serviceProvider.getPlanner().parseSQLToPhysicalPlan(functionSql);
                    QueryContext queryContext = serviceProvider.genQueryContext((Long)queryIds.get(0), true, System.currentTimeMillis(), functionSql, 0L);
                    QueryDataSet queryDataSet = serviceProvider.createQueryDataSet(queryContext, queryPlan, 5000);
                    while (queryDataSet.hasNext()) {
                        List paths = queryDataSet.getPaths();
                        List fields = queryDataSet.next().getFields();
                        for (int i = 0; i < paths.size(); ++i) {
                            Object o = FieldUtils.iotdbFieldConvert((Field)fields.get(i));
                            long queryId = ServiceProvider.SESSION_MANAGER.requestQueryId(true);
                            queryIds.add(queryId);
                            if (o == null) continue;
                            String specificSql = String.format("select %s from %s where %s=%s", function.getParmaName(), ((Path)paths.get(i)).getDevice(), ((Path)paths.get(i)).getFullPath(), o);
                            QueryPlan queryPlanNew = (QueryPlan)serviceProvider.getPlanner().parseSQLToPhysicalPlan(specificSql);
                            QueryContext queryContextNew = serviceProvider.genQueryContext(queryId, true, System.currentTimeMillis(), specificSql, 0L);
                            QueryDataSet queryDataSetNew = serviceProvider.createQueryDataSet(queryContextNew, queryPlanNew, 5000);
                            while (queryDataSetNew.hasNext()) {
                                RowRecord recordNew = queryDataSetNew.next();
                                List newFields = recordNew.getFields();
                                long time = recordNew.getTimestamp();
                                function.updateValueIoTDBFunc(new InfluxFunctionValue(FieldUtils.iotdbFieldConvert((Field)newFields.get(0)), time));
                            }
                        }
                    }
                }
                catch (IOException | InterruptedException | SQLException | MetadataException | StorageEngineException | QueryProcessException | QueryFilterOptimizationException | TException e) {
                    throw new InfluxDBException(((Throwable)e).getMessage());
                }
                finally {
                    Iterator iterator = queryIds.iterator();
                    while (iterator.hasNext()) {
                        long queryId = (Long)iterator.next();
                        ServiceProvider.SESSION_MANAGER.releaseQueryResourceNoExceptions(queryId);
                    }
                }
            }
            case "max": 
            case "min": {
                String functionSql = function.getFunctionName().equals("max") ? StringUtils.generateFunctionSql("max_value", function.getParmaName(), path) : StringUtils.generateFunctionSql("min_value", function.getParmaName(), path);
                long queryId = ServiceProvider.SESSION_MANAGER.requestQueryId(true);
                try {
                    QueryPlan queryPlan = (QueryPlan)serviceProvider.getPlanner().parseSQLToPhysicalPlan(functionSql);
                    QueryContext queryContext = serviceProvider.genQueryContext(queryId, true, System.currentTimeMillis(), functionSql, 0L);
                    QueryDataSet queryDataSet = serviceProvider.createQueryDataSet(queryContext, queryPlan, 5000);
                    while (queryDataSet.hasNext()) {
                        List paths = queryDataSet.getPaths();
                        List fields = queryDataSet.next().getFields();
                        for (int i = 0; i < paths.size(); ++i) {
                            Object o = FieldUtils.iotdbFieldConvert((Field)fields.get(i));
                            function.updateValueIoTDBFunc(new InfluxFunctionValue(o, null));
                        }
                    }
                    break;
                }
                catch (IOException | InterruptedException | SQLException | MetadataException | StorageEngineException | QueryProcessException | QueryFilterOptimizationException | TException e) {
                    throw new InfluxDBException(((Throwable)e).getMessage());
                }
                finally {
                    ServiceProvider.SESSION_MANAGER.releaseQueryResourceNoExceptions(queryId);
                }
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + function.getFunctionName());
            }
        }
        return function.calculateByIoTDBFunc();
    }

    @Override
    public QueryResult queryByConditions(String querySql, String database, String measurement, ServiceProvider serviceProvider, Map<String, Integer> fieldOrders, long sessionId) throws AuthException {
        long queryId = ServiceProvider.SESSION_MANAGER.requestQueryId(true);
        try {
            QueryPlan queryPlan = (QueryPlan)serviceProvider.getPlanner().parseSQLToPhysicalPlan(querySql);
            TSStatus tsStatus = SessionManager.getInstance().checkAuthority(queryPlan, sessionId);
            if (tsStatus != null) {
                throw new AuthException(tsStatus.getMessage());
            }
            QueryContext queryContext = serviceProvider.genQueryContext(queryId, true, System.currentTimeMillis(), querySql, 0L);
            QueryDataSet queryDataSet = serviceProvider.createQueryDataSet(queryContext, queryPlan, 5000);
            QueryResult queryResult = QueryResultUtils.iotdbResultConvertInfluxResult(queryDataSet, database, measurement, fieldOrders);
            return queryResult;
        }
        catch (IOException | InterruptedException | SQLException | MetadataException | StorageEngineException | QueryProcessException | QueryFilterOptimizationException | TException e) {
            throw new InfluxDBException(((Throwable)e).getMessage());
        }
        finally {
            ServiceProvider.SESSION_MANAGER.releaseQueryResourceNoExceptions(queryId);
        }
    }
}

