/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.statement.component;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.db.mpp.plan.statement.component.Ordering;
import org.apache.iotdb.db.mpp.plan.statement.component.SortKey;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class SortItem {
    private final SortKey sortKey;
    private final Ordering ordering;

    public SortItem(SortKey sortKey, Ordering ordering) {
        this.sortKey = sortKey;
        this.ordering = ordering;
    }

    public SortKey getSortKey() {
        return this.sortKey;
    }

    public Ordering getOrdering() {
        return this.ordering;
    }

    public SortItem reverse() {
        return new SortItem(this.getSortKey(), this.getOrdering().reverse());
    }

    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((int)this.sortKey.ordinal(), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.ordering.ordinal(), (ByteBuffer)byteBuffer);
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)this.sortKey.ordinal(), (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.ordering.ordinal(), (OutputStream)stream);
    }

    public static SortItem deserialize(ByteBuffer byteBuffer) {
        SortKey sortKey = SortKey.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        Ordering ordering = Ordering.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        return new SortItem(sortKey, ordering);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortItem sortItem = (SortItem)o;
        return this.sortKey == sortItem.sortKey && this.ordering == sortItem.ordering;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sortKey, this.ordering});
    }
}

