/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.rewriter;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.exception.sql.StatementAnalyzeException;
import org.apache.iotdb.db.mpp.common.filter.QueryFilter;
import org.apache.iotdb.db.mpp.plan.constant.FilterConstant;
import org.apache.iotdb.db.mpp.plan.rewriter.IFilterOptimizer;

public class DnfFilterOptimizer
implements IFilterOptimizer {
    @Override
    public QueryFilter optimize(QueryFilter filter) throws StatementAnalyzeException {
        return this.getDnf(filter);
    }

    private void dealWithLeftAndRightAndChildren(List<QueryFilter> leftAndChildren, List<QueryFilter> rightAndChildren, List<QueryFilter> newChildrenList) throws StatementAnalyzeException {
        for (QueryFilter leftAndChild : leftAndChildren) {
            for (QueryFilter rightAndChild : rightAndChildren) {
                QueryFilter r = this.mergeToConjunction(leftAndChild.copy(), rightAndChild.copy());
                newChildrenList.add(r);
            }
        }
    }

    private QueryFilter getDnf(QueryFilter filter) throws StatementAnalyzeException {
        if (filter.isLeaf()) {
            return filter;
        }
        List<QueryFilter> childOperators = filter.getChildren();
        if (childOperators.size() != 2) {
            throw new StatementAnalyzeException("node :" + filter.getFilterName() + " has " + childOperators.size() + " children");
        }
        QueryFilter left = this.getDnf(childOperators.get(0));
        QueryFilter right = this.getDnf(childOperators.get(1));
        ArrayList<QueryFilter> newChildrenList = new ArrayList<QueryFilter>();
        switch (filter.getFilterType()) {
            case KW_OR: {
                this.addChildOpInOr(left, newChildrenList);
                this.addChildOpInOr(right, newChildrenList);
                break;
            }
            case KW_AND: {
                if (left.getFilterType() != FilterConstant.FilterType.KW_OR && right.getFilterType() != FilterConstant.FilterType.KW_OR) {
                    this.addChildOpInAnd(left, newChildrenList);
                    this.addChildOpInAnd(right, newChildrenList);
                    break;
                }
                this.dealWithLeftAndRightAndChildren(this.getAndChild(left), this.getAndChild(right), newChildrenList);
                filter.setFilterType(FilterConstant.FilterType.KW_OR);
                break;
            }
            default: {
                throw new StatementAnalyzeException("get DNF failed, this tokenType is:" + (Object)((Object)filter.getFilterType()));
            }
        }
        filter.setChildren(newChildrenList);
        return filter;
    }

    private QueryFilter mergeToConjunction(QueryFilter operator1, QueryFilter operator2) throws StatementAnalyzeException {
        ArrayList<QueryFilter> retChildrenList = new ArrayList<QueryFilter>();
        this.addChildOpInAnd(operator1, retChildrenList);
        this.addChildOpInAnd(operator2, retChildrenList);
        QueryFilter ret = new QueryFilter(FilterConstant.FilterType.KW_AND, false);
        ret.setChildren(retChildrenList);
        return ret;
    }

    private List<QueryFilter> getAndChild(QueryFilter child) {
        if (child.getFilterType() == FilterConstant.FilterType.KW_OR) {
            return child.getChildren();
        }
        ArrayList<QueryFilter> ret = new ArrayList<QueryFilter>();
        ret.add(child);
        return ret;
    }

    private void addChildOpInAnd(QueryFilter operator, List<QueryFilter> newChildrenList) throws StatementAnalyzeException {
        if (operator.isLeaf()) {
            newChildrenList.add(operator);
        } else if (operator.getFilterType() == FilterConstant.FilterType.KW_AND) {
            newChildrenList.addAll(operator.getChildren());
        } else {
            throw new StatementAnalyzeException("add all children of an OR operator to newChildrenList in AND");
        }
    }

    private void addChildOpInOr(QueryFilter operator, List<QueryFilter> newChildrenList) {
        if (operator.isLeaf() || operator.getFilterType() == FilterConstant.FilterType.KW_AND) {
            newChildrenList.add(operator);
        } else {
            newChildrenList.addAll(operator.getChildren());
        }
    }
}

