/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.cache.DataNodeLastCacheManager;
import org.apache.iotdb.db.metadata.cache.SchemaCacheEntry;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.mpp.common.schematree.ClusterSchemaTree;
import org.apache.iotdb.db.mpp.common.schematree.ISchemaTree;
import org.apache.iotdb.db.service.metrics.MetricService;
import org.apache.iotdb.db.service.metrics.enums.Metric;
import org.apache.iotdb.db.service.metrics.enums.Tag;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataNodeSchemaCache {
    private static final Logger logger = LoggerFactory.getLogger(DataNodeSchemaCache.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final Cache<PartialPath, SchemaCacheEntry> cache = Caffeine.newBuilder().maximumWeight(config.getAllocateMemoryForSchemaCache()).weigher((key, value) -> PartialPath.estimateSize((PartialPath)key) + SchemaCacheEntry.estimateSize(value)).build();

    private DataNodeSchemaCache() {
        MetricService.getInstance().getOrCreateAutoGauge(Metric.CACHE_HIT.toString(), MetricLevel.IMPORTANT, this.cache, l -> (long)(l.stats().hitRate() * 100.0), new String[]{Tag.NAME.toString(), "schemaCache"});
    }

    public static DataNodeSchemaCache getInstance() {
        return DataNodeSchemaCacheHolder.INSTANCE;
    }

    public ClusterSchemaTree get(PartialPath devicePath, String[] measurements) {
        ClusterSchemaTree schemaTree = new ClusterSchemaTree();
        for (String measurement : measurements) {
            PartialPath path = devicePath.concatNode(measurement);
            SchemaCacheEntry schemaCacheEntry = (SchemaCacheEntry)this.cache.getIfPresent((Object)path);
            if (schemaCacheEntry == null) continue;
            schemaTree.appendSingleMeasurement(devicePath.concatNode(schemaCacheEntry.getSchemaEntryId()), schemaCacheEntry.getMeasurementSchema(), null, schemaCacheEntry.isAligned());
        }
        return schemaTree;
    }

    public void put(ISchemaTree schemaTree) {
        for (MeasurementPath measurementPath : schemaTree.getAllMeasurement()) {
            SchemaCacheEntry schemaCacheEntry = new SchemaCacheEntry((MeasurementSchema)measurementPath.getMeasurementSchema(), measurementPath.isUnderAlignedEntity());
            this.cache.put((Object)new PartialPath(measurementPath.getNodes()), (Object)schemaCacheEntry);
        }
    }

    public TimeValuePair getLastCache(PartialPath seriesPath) {
        SchemaCacheEntry entry = (SchemaCacheEntry)this.cache.getIfPresent((Object)seriesPath);
        if (null == entry) {
            return null;
        }
        return DataNodeLastCacheManager.getLastCache(entry);
    }

    public void updateLastCache(PartialPath seriesPath, TimeValuePair timeValuePair, boolean highPriorityUpdate, Long latestFlushedTime) {
        SchemaCacheEntry entry = (SchemaCacheEntry)this.cache.getIfPresent((Object)seriesPath);
        if (null == entry) {
            return;
        }
        DataNodeLastCacheManager.updateLastCache(entry, timeValuePair, highPriorityUpdate, latestFlushedTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLastCache(MeasurementPath measurementPath, TimeValuePair timeValuePair, boolean highPriorityUpdate, Long latestFlushedTime) {
        PartialPath seriesPath = measurementPath.transformToPartialPath();
        SchemaCacheEntry entry = (SchemaCacheEntry)this.cache.getIfPresent((Object)seriesPath);
        if (null == entry) {
            Cache<PartialPath, SchemaCacheEntry> cache = this.cache;
            synchronized (cache) {
                entry = (SchemaCacheEntry)this.cache.getIfPresent((Object)seriesPath);
                if (null == entry) {
                    entry = new SchemaCacheEntry((MeasurementSchema)measurementPath.getMeasurementSchema(), measurementPath.isUnderAlignedEntity());
                    this.cache.put((Object)seriesPath, (Object)entry);
                }
            }
        }
        DataNodeLastCacheManager.updateLastCache(entry, timeValuePair, highPriorityUpdate, latestFlushedTime);
    }

    public void resetLastCache(PartialPath seriesPath) {
        SchemaCacheEntry entry = (SchemaCacheEntry)this.cache.getIfPresent((Object)seriesPath);
        if (null == entry) {
            return;
        }
        DataNodeLastCacheManager.resetLastCache(entry);
    }

    public void invalidate(PartialPath partialPath) {
        this.resetLastCache(partialPath);
        this.cache.invalidate((Object)partialPath);
    }

    public long estimatedSize() {
        return this.cache.estimatedSize();
    }

    public void cleanUp() {
        this.cache.invalidateAll();
        this.cache.cleanUp();
    }

    private static class DataNodeSchemaCacheHolder {
        private static final DataNodeSchemaCache INSTANCE = new DataNodeSchemaCache();

        private DataNodeSchemaCacheHolder() {
        }
    }
}

