/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.trigger.service;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.commons.trigger.service.TriggerClassLoader;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.TriggerManagementException;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerClassLoaderManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TriggerClassLoaderManager.class);
    private static final String LIB_ROOT = IoTDBDescriptor.getInstance().getConfig().getTriggerDir();
    private final Map<String, Pair<TriggerClassLoader, Integer>> classNameToClassLoaderUsagePairMap = new HashMap<String, Pair<TriggerClassLoader, Integer>>();

    private TriggerClassLoaderManager() {
    }

    public TriggerClassLoader register(String className) throws TriggerManagementException {
        Pair classLoaderUsagePair = this.classNameToClassLoaderUsagePairMap.get(className);
        if (classLoaderUsagePair == null) {
            try {
                TriggerClassLoader classLoader = new TriggerClassLoader(LIB_ROOT);
                classLoaderUsagePair = new Pair((Object)classLoader, (Object)0);
                this.classNameToClassLoaderUsagePairMap.put(className, (Pair<TriggerClassLoader, Integer>)classLoaderUsagePair);
                LOGGER.info("A new trigger classloader was constructed for managing trigger class {}.", (Object)className);
            }
            catch (IOException e) {
                throw new TriggerManagementException(String.format("Failed to construct a new trigger classloader for managing trigger class %s.", className), e);
            }
        }
        Pair pair = classLoaderUsagePair;
        Integer n = (Integer)pair.right;
        pair.right = (Integer)pair.right + 1;
        Integer n2 = pair.right;
        return (TriggerClassLoader)classLoaderUsagePair.left;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(String className) {
        Pair<TriggerClassLoader, Integer> classLoaderUsagePair;
        Pair<TriggerClassLoader, Integer> pair = classLoaderUsagePair = this.classNameToClassLoaderUsagePairMap.get(className);
        Integer n = (Integer)pair.right;
        pair.right = (Integer)pair.right - 1;
        Integer n2 = pair.right;
        if ((Integer)classLoaderUsagePair.right == 0) {
            try {
                ((TriggerClassLoader)classLoaderUsagePair.left).close();
            }
            catch (IOException e) {
                LOGGER.warn("Failed to close a trigger classloader ({}).", (Object)className);
            }
            finally {
                this.classNameToClassLoaderUsagePairMap.remove(className);
                LOGGER.info("A trigger classloader ({}) was removed.", (Object)className);
            }
        }
    }

    public static TriggerClassLoaderManager getInstance() {
        return TriggerClassLoaderManagerHelper.INSTANCE;
    }

    private static class TriggerClassLoaderManagerHelper {
        private static final TriggerClassLoaderManager INSTANCE = new TriggerClassLoaderManager();

        private TriggerClassLoaderManagerHelper() {
        }
    }
}

