/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.auth;

import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.db.auth.AuthorizerManager;
import org.apache.iotdb.db.auth.IAuthorCache;
import org.apache.iotdb.db.auth.IAuthorityFetcher;
import org.apache.iotdb.db.localconfignode.LocalConfigNode;
import org.apache.iotdb.db.mpp.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.mpp.plan.statement.sys.AuthorStatement;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneAuthorityFetcher
implements IAuthorityFetcher {
    private static final Logger logger = LoggerFactory.getLogger(StandaloneAuthorityFetcher.class);
    private LocalConfigNode localConfigNode = LocalConfigNode.getInstance();

    @Override
    public TSStatus checkUser(String username, String password) {
        try {
            if (this.localConfigNode.login(username, password)) {
                return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
            }
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.WRONG_LOGIN_PASSWORD_ERROR, (String)"Authentication failed.");
        }
        catch (AuthException e) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.AUTHENTICATION_ERROR, (String)e.getMessage());
        }
    }

    @Override
    public TSStatus checkUserPrivileges(String username, List<String> allPath, int permission) {
        boolean checkStatus = true;
        String checkMessage = null;
        for (String path : allPath) {
            try {
                if (this.checkOnePath(username, path, permission)) continue;
                checkStatus = false;
                break;
            }
            catch (AuthException e) {
                checkStatus = false;
            }
        }
        if (checkStatus) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.NO_PERMISSION_ERROR, checkMessage);
    }

    private boolean checkOnePath(String username, String path, int permission) throws AuthException {
        try {
            String fullPath;
            String string = fullPath = path == null ? "root.**" : path;
            if (this.localConfigNode.checkUserPrivileges(username, fullPath, permission)) {
                return true;
            }
        }
        catch (AuthException e) {
            logger.error("Error occurs when checking the seriesPath {} for user {}", new Object[]{path, username, e});
            throw new AuthException((Throwable)e);
        }
        return false;
    }

    @Override
    public SettableFuture<ConfigTaskResult> operatePermission(AuthorStatement authorStatement) {
        SettableFuture future = SettableFuture.create();
        boolean status = true;
        try {
            LocalConfigNode.getInstance().operatorPermission(authorStatement);
        }
        catch (AuthException e) {
            future.setException((Throwable)e);
            status = false;
        }
        if (status) {
            future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS));
        }
        return future;
    }

    @Override
    public SettableFuture<ConfigTaskResult> queryPermission(AuthorStatement authorStatement) {
        SettableFuture future = SettableFuture.create();
        try {
            Map<String, List<String>> authorizerResp = LocalConfigNode.getInstance().queryPermission(authorStatement);
            AuthorizerManager.getInstance().buildTSBlock(authorizerResp, (SettableFuture<ConfigTaskResult>)future);
        }
        catch (AuthException e) {
            future.setException((Throwable)e);
        }
        return future;
    }

    @Override
    public IAuthorCache getAuthorCache() {
        throw new UnsupportedOperationException("AuthorCache in Standalone is not supported.");
    }
}

