/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.micrometer.reporter;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.metrics.config.MetricConfig;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.utils.IoTDBMetricsUtils;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.pool.SessionPool;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBMeterRegistry
extends StepMeterRegistry {
    private static final Logger logger = LoggerFactory.getLogger(IoTDBMeterRegistry.class);
    private static final MetricConfig.IoTDBReporterConfig ioTDBReporterConfig = MetricConfigDescriptor.getInstance().getMetricConfig().getIoTDBReporterConfig();
    private final SessionPool sessionPool = new SessionPool(ioTDBReporterConfig.getHost(), ioTDBReporterConfig.getPort().intValue(), ioTDBReporterConfig.getUsername(), ioTDBReporterConfig.getPassword(), ioTDBReporterConfig.getMaxConnectionNumber().intValue());

    public IoTDBMeterRegistry(StepRegistryConfig config, Clock clock) {
        super(config, clock);
        IoTDBMetricsUtils.checkOrCreateStorageGroup((SessionPool)this.sessionPool);
    }

    public void stop() {
        super.stop();
        if (this.sessionPool != null) {
            this.sessionPool.close();
        }
    }

    protected void publish() {
        Long time = System.currentTimeMillis();
        this.getMeters().forEach(meter -> {
            if (null != meter) {
                Meter.Id id = meter.getId();
                String name = id.getName();
                List tags = id.getTags();
                Map<String, String> labels = this.tagsConvertToMap(tags);
                meter.use(gauge -> this.updateValue(name, labels, gauge.value(), time), counter -> this.updateValue(name, labels, counter.count(), time), timer -> this.writeSnapshotAndCount(name, labels, timer.takeSnapshot(), time), summary -> this.writeSnapshotAndCount(name, labels, summary.takeSnapshot(), time), longTaskTimer -> this.updateValue(name, labels, Double.valueOf(longTaskTimer.activeTasks()), time), timeGauge -> this.updateValue(name, labels, timeGauge.value(this.getBaseTimeUnit()), time), functionCounter -> this.updateValue(name, labels, functionCounter.count(), time), functionTimer -> this.updateValue(name, labels, functionTimer.count(), time), m -> logger.debug("unknown meter:" + meter));
            }
        });
    }

    private void writeSnapshotAndCount(String name, Map<String, String> labels, HistogramSnapshot snapshot, Long time) {
        this.updateValue(name + "_max", labels, snapshot.max(), time);
        this.updateValue(name + "_mean", labels, snapshot.mean(), time);
        this.updateValue(name + "_total", labels, snapshot.total(), time);
        this.updateValue(name + "_count", labels, Double.valueOf(snapshot.count()), time);
    }

    private Map<String, String> tagsConvertToMap(List<Tag> tags) {
        HashMap<String, String> labels = new HashMap<String, String>();
        for (Tag tag : tags) {
            labels.put(tag.getKey(), tag.getValue());
        }
        return labels;
    }

    private void updateValue(String name, Map<String, String> labels, Double value, Long time) {
        if (value != null) {
            String deviceId = IoTDBMetricsUtils.generatePath((String)name, labels);
            List<String> sensors = Collections.singletonList("value");
            List<TSDataType> dataTypes = Collections.singletonList(TSDataType.DOUBLE);
            List<Double> values = Collections.singletonList(value);
            try {
                this.sessionPool.insertRecord(deviceId, time.longValue(), sensors, dataTypes, values);
            }
            catch (IoTDBConnectionException | StatementExecutionException e) {
                logger.warn("Failed to insert record");
            }
        }
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }
}

