/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.utils;

import org.apache.iotdb.tsfile.utils.ByteArrayList;

public class BitConstructor {
    private static final int BITS_IN_A_BYTE = 8;
    private static final long ALL_MASK = -1L;
    private final ByteArrayList data;
    private byte cache = 0;
    private int cnt = 0;

    public BitConstructor() {
        this.data = new ByteArrayList();
    }

    public BitConstructor(int initialCapacity) {
        this.data = new ByteArrayList(initialCapacity);
    }

    public void add(long x, int len) {
        x &= -1L << len ^ 0xFFFFFFFFFFFFFFFFL;
        while (len > 0) {
            int m = len + this.cnt >= 8 ? 8 - this.cnt : len;
            this.cnt += m;
            byte y = (byte)(x >> (len -= m));
            y = (byte)(y << 8 - this.cnt);
            this.cache = (byte)(this.cache | y);
            x &= -1L << len ^ 0xFFFFFFFFFFFFFFFFL;
            if (this.cnt != 8) continue;
            this.pad();
        }
    }

    public byte[] toByteArray() {
        byte[] ret;
        if (this.cnt > 0) {
            this.data.add(this.cache);
            ret = this.data.toArray();
            this.data.removeAtIndex(this.data.size() - 1);
        } else {
            ret = this.data.toArray();
        }
        return ret;
    }

    public void clear() {
        this.data.clear();
        this.cache = 0;
        this.cnt = 0;
    }

    public void pad() {
        if (this.cnt > 0) {
            this.data.add(this.cache);
            this.cache = 0;
            this.cnt = 0;
        }
    }

    public void add(byte[] bytes) {
        if (this.cnt == 0) {
            this.data.addAll(bytes);
        } else {
            for (byte aByte : bytes) {
                this.add(aByte, 8);
            }
        }
    }

    public int sizeInBytes() {
        return this.data.size() + (this.cnt > 0 ? 1 : 0);
    }
}

