/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.runtime.ThriftSerDeException;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.procedure.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.state.ProcedureLockState;
import org.apache.iotdb.confignode.procedure.state.RegionTransitionState;
import org.apache.iotdb.confignode.procedure.store.ProcedureFactory;
import org.apache.iotdb.confignode.rpc.thrift.TRegionMigrateResultReportReq;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionMigrateProcedure
extends StateMachineProcedure<ConfigNodeProcedureEnv, RegionTransitionState> {
    private static final Logger LOG = LoggerFactory.getLogger(RegionMigrateProcedure.class);
    private static final int retryThreshold = 5;
    private final Object regionMigrateLock = new Object();
    private TConsensusGroupId consensusGroupId;
    private TDataNodeLocation originalDataNode;
    private TDataNodeLocation destDataNode;

    public RegionMigrateProcedure() {
    }

    public RegionMigrateProcedure(TConsensusGroupId consensusGroupId, TDataNodeLocation originalDataNode, TDataNodeLocation destDataNode) {
        this.consensusGroupId = consensusGroupId;
        this.originalDataNode = originalDataNode;
        this.destDataNode = destDataNode;
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, RegionTransitionState state) {
        block16: {
            if (this.consensusGroupId == null) {
                return StateMachineProcedure.Flow.NO_MORE_STATE;
            }
            TSStatus tsStatus = null;
            try {
                switch (state) {
                    case REGION_MIGRATE_PREPARE: {
                        this.setNextState(RegionTransitionState.CREATE_PEER);
                        break;
                    }
                    case CREATE_PEER: {
                        env.getDataNodeRemoveHandler().createPeer(this.consensusGroupId, this.destDataNode);
                        this.setNextState(RegionTransitionState.ADD_REGION_PEER);
                        break;
                    }
                    case ADD_REGION_PEER: {
                        tsStatus = env.getDataNodeRemoveHandler().addRegionPeer(this.originalDataNode, this.destDataNode, this.consensusGroupId);
                        if (tsStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                            throw new ProcedureException("Failed to add region peer");
                        }
                        this.waitForOneMigrationStepFinished(this.consensusGroupId);
                        LOG.info("Wait for region {}  add peer finished", (Object)this.consensusGroupId);
                        this.setNextState(RegionTransitionState.CHANGE_REGION_LEADER);
                        break;
                    }
                    case CHANGE_REGION_LEADER: {
                        env.getDataNodeRemoveHandler().changeRegionLeader(this.consensusGroupId, this.originalDataNode);
                        this.setNextState(RegionTransitionState.REMOVE_REGION_PEER);
                        break;
                    }
                    case REMOVE_REGION_PEER: {
                        tsStatus = env.getDataNodeRemoveHandler().removeRegionPeer(this.originalDataNode, this.destDataNode, this.consensusGroupId);
                        if (tsStatus.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                            throw new ProcedureException("Failed to remove region peer");
                        }
                        this.waitForOneMigrationStepFinished(this.consensusGroupId);
                        LOG.info("Wait for region {} remove peer finished", (Object)this.consensusGroupId);
                        this.setNextState(RegionTransitionState.DELETE_PEER);
                        break;
                    }
                    case DELETE_PEER: {
                        tsStatus = env.getDataNodeRemoveHandler().deletePeer(this.originalDataNode, this.destDataNode, this.consensusGroupId);
                        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                            this.waitForOneMigrationStepFinished(this.consensusGroupId);
                            LOG.info("Wait for region {}  remove consensus group finished", (Object)this.consensusGroupId);
                        }
                        this.setNextState(RegionTransitionState.UPDATE_REGION_LOCATION_CACHE);
                        break;
                    }
                    case UPDATE_REGION_LOCATION_CACHE: {
                        env.getDataNodeRemoveHandler().updateRegionLocationCache(this.consensusGroupId, this.originalDataNode, this.destDataNode);
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                }
            }
            catch (Exception e) {
                if (this.isRollbackSupported(state)) {
                    this.setFailure(new ProcedureException("Region migrate failed " + (Object)((Object)state)));
                }
                LOG.error("Retrievable error trying to region migrate {}, state {}", new Object[]{this.originalDataNode, state, e});
                if (this.getCycles() <= 5) break block16;
                this.setFailure(new ProcedureException("State stuck at " + (Object)((Object)state)));
            }
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, RegionTransitionState state) throws IOException, InterruptedException, ProcedureException {
    }

    @Override
    protected boolean isRollbackSupported(RegionTransitionState state) {
        return false;
    }

    @Override
    protected ProcedureLockState acquireLock(ConfigNodeProcedureEnv configNodeProcedureEnv) {
        configNodeProcedureEnv.getSchedulerLock().lock();
        try {
            if (configNodeProcedureEnv.getRegionMigrateLock().tryLock(this)) {
                LOG.info("{} acquire lock.", (Object)this.getProcId());
                ProcedureLockState procedureLockState = ProcedureLockState.LOCK_ACQUIRED;
                return procedureLockState;
            }
            configNodeProcedureEnv.getRegionMigrateLock().waitProcedure(this);
            LOG.info("{} wait for lock.", (Object)this.getProcId());
            ProcedureLockState procedureLockState = ProcedureLockState.LOCK_EVENT_WAIT;
            return procedureLockState;
        }
        finally {
            configNodeProcedureEnv.getSchedulerLock().unlock();
        }
    }

    @Override
    protected void releaseLock(ConfigNodeProcedureEnv configNodeProcedureEnv) {
        configNodeProcedureEnv.getSchedulerLock().lock();
        try {
            LOG.info("{} release lock.", (Object)this.getProcId());
            if (configNodeProcedureEnv.getRegionMigrateLock().releaseLock(this)) {
                configNodeProcedureEnv.getRegionMigrateLock().wakeWaitingProcedures(configNodeProcedureEnv.getScheduler());
            }
        }
        finally {
            configNodeProcedureEnv.getSchedulerLock().unlock();
        }
    }

    @Override
    protected RegionTransitionState getState(int stateId) {
        return RegionTransitionState.values()[stateId];
    }

    @Override
    protected int getStateId(RegionTransitionState regionTransitionState) {
        return regionTransitionState.ordinal();
    }

    @Override
    protected RegionTransitionState getInitialState() {
        return RegionTransitionState.REGION_MIGRATE_PREPARE;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeInt(ProcedureFactory.ProcedureType.REGION_MIGRATE_PROCEDURE.ordinal());
        super.serialize(stream);
        ThriftCommonsSerDeUtils.serializeTDataNodeLocation((TDataNodeLocation)this.originalDataNode, (DataOutputStream)stream);
        ThriftCommonsSerDeUtils.serializeTDataNodeLocation((TDataNodeLocation)this.destDataNode, (DataOutputStream)stream);
        ThriftCommonsSerDeUtils.serializeTConsensusGroupId((TConsensusGroupId)this.consensusGroupId, (DataOutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        try {
            this.originalDataNode = ThriftCommonsSerDeUtils.deserializeTDataNodeLocation((ByteBuffer)byteBuffer);
            this.destDataNode = ThriftCommonsSerDeUtils.deserializeTDataNodeLocation((ByteBuffer)byteBuffer);
            this.consensusGroupId = ThriftCommonsSerDeUtils.deserializeTConsensusGroupId((ByteBuffer)byteBuffer);
        }
        catch (ThriftSerDeException e) {
            LOG.error("Error in deserialize RemoveConfigNodeProcedure", (Throwable)e);
        }
    }

    public boolean equals(Object that) {
        if (that instanceof RegionMigrateProcedure) {
            RegionMigrateProcedure thatProc = (RegionMigrateProcedure)that;
            return thatProc.getProcId() == this.getProcId() && thatProc.getState() == this.getState() && thatProc.originalDataNode.equals(this.originalDataNode) && thatProc.destDataNode.equals(this.destDataNode) && thatProc.consensusGroupId.equals(this.consensusGroupId);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus waitForOneMigrationStepFinished(TConsensusGroupId consensusGroupId) {
        TSStatus status = new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        Object object = this.regionMigrateLock;
        synchronized (object) {
            try {
                this.regionMigrateLock.wait();
            }
            catch (InterruptedException e) {
                LOG.error("region migrate {} interrupt", (Object)consensusGroupId, (Object)e);
                Thread.currentThread().interrupt();
                status.setCode(TSStatusCode.MIGRATE_REGION_ERROR.getStatusCode());
                status.setMessage("wait region migrate interrupt," + e.getMessage());
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTheRegionMigrateFinished(TRegionMigrateResultReportReq req) {
        Object object = this.regionMigrateLock;
        synchronized (object) {
            this.regionMigrateLock.notify();
        }
        LOG.info("notified after DataNode reported region {} migrate result:{} ", (Object)req.getRegionId(), (Object)req);
    }

    public TConsensusGroupId getConsensusGroupId() {
        return this.consensusGroupId;
    }
}

