/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.confignode.consensus.request.write.CreateRegionGroupsPlan;
import org.apache.iotdb.confignode.consensus.request.write.DeleteRegionGroupsPlan;
import org.apache.iotdb.confignode.procedure.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.state.CreateRegionGroupsState;
import org.apache.iotdb.confignode.procedure.store.ProcedureFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateRegionGroupsProcedure
extends StateMachineProcedure<ConfigNodeProcedureEnv, CreateRegionGroupsState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateRegionGroupsProcedure.class);
    private CreateRegionGroupsPlan createRegionGroupsPlan = new CreateRegionGroupsPlan();
    private Map<TConsensusGroupId, TRegionReplicaSet> failedRegions = new HashMap<TConsensusGroupId, TRegionReplicaSet>();

    public CreateRegionGroupsProcedure() {
    }

    public CreateRegionGroupsProcedure(CreateRegionGroupsPlan createRegionGroupsPlan) {
        this.createRegionGroupsPlan = createRegionGroupsPlan;
    }

    public CreateRegionGroupsProcedure(CreateRegionGroupsPlan createRegionGroupsPlan, Map<TConsensusGroupId, TRegionReplicaSet> failedRegions) {
        this.createRegionGroupsPlan = createRegionGroupsPlan;
        this.failedRegions = failedRegions;
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, CreateRegionGroupsState state) {
        switch (state) {
            case CREATE_REGION_GROUPS_PREPARE: {
                this.setNextState(CreateRegionGroupsState.CREATE_REGION_GROUPS);
                break;
            }
            case CREATE_REGION_GROUPS: {
                this.failedRegions = env.doRegionCreation(this.createRegionGroupsPlan);
                this.setNextState(CreateRegionGroupsState.PERSIST_AND_BROADCAST);
                break;
            }
            case PERSIST_AND_BROADCAST: {
                CreateRegionGroupsPlan persistPlan = new CreateRegionGroupsPlan();
                this.createRegionGroupsPlan.getRegionGroupMap().forEach((storageGroup, regionReplicaSets) -> regionReplicaSets.forEach(regionReplicaSet -> {
                    if (!this.failedRegions.containsKey(regionReplicaSet.getRegionId())) {
                        persistPlan.addRegionGroup((String)storageGroup, (TRegionReplicaSet)regionReplicaSet);
                    }
                }));
                env.persistAndBroadcastRegionGroup(persistPlan);
                this.setNextState(this.failedRegions.size() > 0 ? CreateRegionGroupsState.DELETE_FAILED_REGION_GROUPS : CreateRegionGroupsState.CREATE_REGION_GROUPS_FINISH);
                break;
            }
            case DELETE_FAILED_REGION_GROUPS: {
                DeleteRegionGroupsPlan deletePlan = new DeleteRegionGroupsPlan();
                deletePlan.setNeedsDeleteInPartitionTable(false);
                this.createRegionGroupsPlan.getRegionGroupMap().forEach((storageGroup, regionReplicaSets) -> regionReplicaSets.forEach(regionReplicaSet -> {
                    if (this.failedRegions.containsKey(regionReplicaSet.getRegionId())) {
                        TRegionReplicaSet failedReplicaSet = this.failedRegions.get(regionReplicaSet.getRegionId());
                        TRegionReplicaSet redundantReplicaSet = new TRegionReplicaSet().setRegionId(regionReplicaSet.getRegionId());
                        regionReplicaSet.getDataNodeLocations().forEach(dataNodeLocation -> {
                            if (!failedReplicaSet.getDataNodeLocations().contains(dataNodeLocation)) {
                                redundantReplicaSet.addToDataNodeLocations(dataNodeLocation);
                            }
                        });
                        deletePlan.addRegionGroup((String)storageGroup, redundantReplicaSet);
                    }
                }));
                env.submitFailedRegionReplicas(deletePlan);
                this.setFailure(new ProcedureException("There are some RegionGroups failed to create, please check former logs in ConfigNode-leader."));
                return StateMachineProcedure.Flow.NO_MORE_STATE;
            }
            case CREATE_REGION_GROUPS_FINISH: {
                return StateMachineProcedure.Flow.NO_MORE_STATE;
            }
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv configNodeProcedureEnv, CreateRegionGroupsState createRegionGroupsState) {
    }

    @Override
    protected CreateRegionGroupsState getState(int stateId) {
        return CreateRegionGroupsState.values()[stateId];
    }

    @Override
    protected int getStateId(CreateRegionGroupsState createRegionGroupsState) {
        return createRegionGroupsState.ordinal();
    }

    @Override
    protected CreateRegionGroupsState getInitialState() {
        return CreateRegionGroupsState.CREATE_REGION_GROUPS_PREPARE;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeInt(ProcedureFactory.ProcedureType.CREATE_REGION_GROUPS.ordinal());
        super.serialize(stream);
        this.createRegionGroupsPlan.serializeForProcedure(stream);
        stream.writeInt(this.failedRegions.size());
        this.failedRegions.forEach((groupId, replica) -> {
            ThriftCommonsSerDeUtils.serializeTConsensusGroupId((TConsensusGroupId)groupId, (DataOutputStream)stream);
            ThriftCommonsSerDeUtils.serializeTRegionReplicaSet((TRegionReplicaSet)replica, (DataOutputStream)stream);
        });
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        try {
            this.createRegionGroupsPlan.deserializeForProcedure(byteBuffer);
            this.failedRegions.clear();
            int failedRegionsSize = byteBuffer.getInt();
            while (failedRegionsSize-- > 0) {
                TConsensusGroupId groupId = ThriftCommonsSerDeUtils.deserializeTConsensusGroupId((ByteBuffer)byteBuffer);
                TRegionReplicaSet replica = ThriftCommonsSerDeUtils.deserializeTRegionReplicaSet((ByteBuffer)byteBuffer);
                this.failedRegions.put(groupId, replica);
            }
        }
        catch (Exception e) {
            LOGGER.error("Deserialize meets error in CreateRegionGroupsProcedure", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object that) {
        if (that instanceof CreateRegionGroupsProcedure) {
            CreateRegionGroupsProcedure thatProc = (CreateRegionGroupsProcedure)that;
            return thatProc.getProcId() == this.getProcId() && thatProc.getState() == this.getState() && thatProc.createRegionGroupsPlan.equals(this.createRegionGroupsPlan) && thatProc.failedRegions.equals(this.failedRegions);
        }
        return false;
    }

    public int hashCode() {
        int result = this.createRegionGroupsPlan.hashCode();
        result = 31 * result + Objects.hash(this.failedRegions);
        return result;
    }
}

