/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.partition;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.cluster.RegionStatus;
import org.apache.iotdb.commons.partition.DataPartitionTable;
import org.apache.iotdb.commons.partition.SchemaPartitionTable;
import org.apache.iotdb.confignode.consensus.request.read.GetRegionInfoListPlan;
import org.apache.iotdb.confignode.persistence.partition.RegionGroup;
import org.apache.iotdb.confignode.rpc.thrift.TRegionInfo;
import org.apache.iotdb.confignode.rpc.thrift.TShowRegionReq;
import org.apache.iotdb.db.service.metrics.MetricService;
import org.apache.iotdb.db.service.metrics.enums.Metric;
import org.apache.iotdb.db.service.metrics.enums.Tag;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageGroupPartitionTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageGroupPartitionTable.class);
    private volatile boolean isPredeleted = false;
    private String storageGroupName;
    private final AtomicInteger seriesPartitionSlotsCount;
    private final Map<TConsensusGroupId, RegionGroup> regionGroupMap;
    private final SchemaPartitionTable schemaPartitionTable;
    private final DataPartitionTable dataPartitionTable;

    public StorageGroupPartitionTable(String storageGroupName) {
        this.storageGroupName = storageGroupName;
        this.seriesPartitionSlotsCount = new AtomicInteger(0);
        this.regionGroupMap = new ConcurrentHashMap<TConsensusGroupId, RegionGroup>();
        this.schemaPartitionTable = new SchemaPartitionTable();
        this.dataPartitionTable = new DataPartitionTable();
        this.addMetrics();
    }

    private void addMetrics() {
        MetricService.getInstance().getOrCreateAutoGauge(Metric.REGION.toString(), MetricLevel.NORMAL, (Object)this, o -> o.getRegionGroupCount(TConsensusGroupType.SchemaRegion), new String[]{Tag.NAME.toString(), this.storageGroupName, Tag.TYPE.toString(), TConsensusGroupType.SchemaRegion.toString()});
        MetricService.getInstance().getOrCreateAutoGauge(Metric.REGION.toString(), MetricLevel.NORMAL, (Object)this, o -> o.getRegionGroupCount(TConsensusGroupType.DataRegion), new String[]{Tag.NAME.toString(), this.storageGroupName, Tag.TYPE.toString(), TConsensusGroupType.DataRegion.toString()});
        MetricService.getInstance().getOrCreateAutoGauge(Metric.SLOT.toString(), MetricLevel.NORMAL, (Object)this.schemaPartitionTable, o -> o.getSchemaPartitionMap().size(), new String[]{Tag.NAME.toString(), this.storageGroupName, Tag.TYPE.toString(), "schemaSlotNumber"});
        MetricService.getInstance().getOrCreateAutoGauge(Metric.SLOT.toString(), MetricLevel.NORMAL, (Object)this.dataPartitionTable, o -> o.getDataPartitionMap().size(), new String[]{Tag.NAME.toString(), this.storageGroupName, Tag.TYPE.toString(), "dataSlotNumber"});
    }

    public boolean isPredeleted() {
        return this.isPredeleted;
    }

    public void setPredeleted(boolean predeleted) {
        this.isPredeleted = predeleted;
    }

    public void createRegionGroups(List<TRegionReplicaSet> replicaSets) {
        replicaSets.forEach(replicaSet -> this.regionGroupMap.put(replicaSet.getRegionId(), new RegionGroup((TRegionReplicaSet)replicaSet)));
    }

    public void deleteRegionGroups(List<TRegionReplicaSet> replicaSets) {
        replicaSets.forEach(replicaSet -> this.regionGroupMap.remove(replicaSet.getRegionId()));
    }

    public List<TRegionReplicaSet> getAllReplicaSets() {
        ArrayList<TRegionReplicaSet> result = new ArrayList<TRegionReplicaSet>();
        for (RegionGroup regionGroup : this.regionGroupMap.values()) {
            result.add(regionGroup.getReplicaSet());
        }
        return result;
    }

    public Set<RegionGroup> getRegionGroups(TConsensusGroupType type) {
        HashSet<RegionGroup> regionGroups = new HashSet<RegionGroup>();
        this.regionGroupMap.values().forEach(regionGroup -> {
            if (regionGroup.getId().getType().equals((Object)type)) {
                regionGroups.add((RegionGroup)regionGroup);
            }
        });
        return regionGroups;
    }

    public int getRegionGroupCount(TConsensusGroupType type) {
        AtomicInteger result = new AtomicInteger(0);
        this.regionGroupMap.values().forEach(regionGroup -> {
            if (regionGroup.getId().getType().equals((Object)type)) {
                result.getAndIncrement();
            }
        });
        return result.getAndIncrement();
    }

    public int getSlotsCount() {
        return this.seriesPartitionSlotsCount.get();
    }

    public boolean getSchemaPartition(List<TSeriesPartitionSlot> partitionSlots, SchemaPartitionTable schemaPartition) {
        return this.schemaPartitionTable.getSchemaPartition(partitionSlots, schemaPartition);
    }

    public boolean getDataPartition(Map<TSeriesPartitionSlot, List<TTimePartitionSlot>> partitionSlots, DataPartitionTable dataPartition) {
        return this.dataPartitionTable.getDataPartition(partitionSlots, dataPartition);
    }

    public TConsensusGroupId getPrecededDataPartition(TSeriesPartitionSlot seriesPartitionSlot, TTimePartitionSlot timePartitionSlot, long timePartitionInterval) {
        return this.dataPartitionTable.getPrecededDataPartition(seriesPartitionSlot, timePartitionSlot, timePartitionInterval);
    }

    public void createSchemaPartition(SchemaPartitionTable assignedSchemaPartition) {
        Map deltaMap = this.schemaPartitionTable.createSchemaPartition(assignedSchemaPartition);
        AtomicInteger total = new AtomicInteger(0);
        deltaMap.forEach((consensusGroupId, delta) -> {
            total.getAndAdd(delta.get());
            this.regionGroupMap.get(consensusGroupId).addCounter(delta.get());
        });
        this.seriesPartitionSlotsCount.getAndAdd(total.get());
    }

    public void createDataPartition(DataPartitionTable assignedDataPartition) {
        Map deltaMap = this.dataPartitionTable.createDataPartition(assignedDataPartition);
        AtomicInteger total = new AtomicInteger(0);
        deltaMap.forEach((consensusGroupId, delta) -> {
            total.getAndAdd(delta.get());
            this.regionGroupMap.get(consensusGroupId).addCounter(delta.get());
        });
    }

    public List<TSeriesPartitionSlot> filterUnassignedSchemaPartitionSlots(List<TSeriesPartitionSlot> partitionSlots) {
        return this.schemaPartitionTable.filterUnassignedSchemaPartitionSlots(partitionSlots);
    }

    public Set<TDataNodeLocation> getStorageGroupRelatedDataNodes(TConsensusGroupType type) {
        HashSet<TDataNodeLocation> result = new HashSet<TDataNodeLocation>();
        this.regionGroupMap.forEach((consensusGroupId, regionGroup) -> {
            if (consensusGroupId.getType().equals((Object)type)) {
                result.addAll(regionGroup.getReplicaSet().getDataNodeLocations());
            }
        });
        return result;
    }

    public Map<TSeriesPartitionSlot, List<TTimePartitionSlot>> filterUnassignedDataPartitionSlots(Map<TSeriesPartitionSlot, List<TTimePartitionSlot>> partitionSlots) {
        return this.dataPartitionTable.filterUnassignedDataPartitionSlots(partitionSlots);
    }

    public List<Pair<Long, TConsensusGroupId>> getSortedRegionGroupSlotsCounter(TConsensusGroupType type) {
        Vector<Pair<Long, TConsensusGroupId>> result = new Vector<Pair<Long, TConsensusGroupId>>();
        this.regionGroupMap.forEach((consensusGroupId, regionGroup) -> {
            if (consensusGroupId.getType().equals((Object)type)) {
                result.add(new Pair((Object)regionGroup.getCounter(), consensusGroupId));
            }
        });
        result.sort(Comparator.comparingLong(Pair::getLeft));
        return result;
    }

    public void getRegionInfoList(GetRegionInfoListPlan regionsInfoPlan, List<TRegionInfo> regionInfoList) {
        TShowRegionReq showRegionReq = regionsInfoPlan.getShowRegionReq();
        this.regionGroupMap.forEach((consensusGroupId, regionGroup) -> {
            TRegionReplicaSet replicaSet = regionGroup.getReplicaSet();
            if (showRegionReq == null || showRegionReq.getConsensusGroupType() == null) {
                this.buildTRegionsInfo(regionInfoList, replicaSet, (RegionGroup)regionGroup);
            } else if (regionsInfoPlan.getShowRegionReq().getConsensusGroupType().ordinal() == replicaSet.getRegionId().getType().ordinal()) {
                this.buildTRegionsInfo(regionInfoList, replicaSet, (RegionGroup)regionGroup);
            }
        });
    }

    private void buildTRegionsInfo(List<TRegionInfo> regionInfoList, TRegionReplicaSet replicaSet, RegionGroup regionGroup) {
        replicaSet.getDataNodeLocations().forEach(dataNodeLocation -> {
            TRegionInfo regionInfo = new TRegionInfo();
            regionInfo.setConsensusGroupId(replicaSet.getRegionId());
            regionInfo.setStorageGroup(this.storageGroupName);
            if (replicaSet.getRegionId().getType() == TConsensusGroupType.DataRegion) {
                regionInfo.setSeriesSlots((long)this.dataPartitionTable.getDataPartitionMap().size());
                regionInfo.setTimeSlots(regionGroup.getCounter());
            } else if (replicaSet.getRegionId().getType() == TConsensusGroupType.SchemaRegion) {
                regionInfo.setSeriesSlots(regionGroup.getCounter());
                regionInfo.setTimeSlots(0L);
            }
            regionInfo.setDataNodeId(dataNodeLocation.getDataNodeId());
            regionInfo.setClientRpcIp(dataNodeLocation.getClientRpcEndPoint().getIp());
            regionInfo.setClientRpcPort(dataNodeLocation.getClientRpcEndPoint().getPort());
            regionInfo.setStatus(RegionStatus.Up.getStatus());
            regionInfoList.add(regionInfo);
        });
    }

    public void serialize(OutputStream outputStream, TProtocol protocol) throws IOException, TException {
        ReadWriteIOUtils.write((Boolean)this.isPredeleted, (OutputStream)outputStream);
        ReadWriteIOUtils.write((String)this.storageGroupName, (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)this.seriesPartitionSlotsCount.get(), (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)this.regionGroupMap.size(), (OutputStream)outputStream);
        for (Map.Entry<TConsensusGroupId, RegionGroup> regionInfoEntry : this.regionGroupMap.entrySet()) {
            regionInfoEntry.getKey().write(protocol);
            regionInfoEntry.getValue().serialize(outputStream, protocol);
        }
        this.schemaPartitionTable.serialize(outputStream, protocol);
        this.dataPartitionTable.serialize(outputStream, protocol);
    }

    public void deserialize(InputStream inputStream, TProtocol protocol) throws IOException, TException {
        this.isPredeleted = ReadWriteIOUtils.readBool((InputStream)inputStream);
        this.storageGroupName = ReadWriteIOUtils.readString((InputStream)inputStream);
        this.seriesPartitionSlotsCount.set(ReadWriteIOUtils.readInt((InputStream)inputStream));
        int length = ReadWriteIOUtils.readInt((InputStream)inputStream);
        for (int i = 0; i < length; ++i) {
            TConsensusGroupId consensusGroupId = new TConsensusGroupId();
            consensusGroupId.read(protocol);
            RegionGroup regionGroup = new RegionGroup();
            regionGroup.deserialize(inputStream, protocol);
            this.regionGroupMap.put(consensusGroupId, regionGroup);
        }
        this.schemaPartitionTable.deserialize(inputStream, protocol);
        this.dataPartitionTable.deserialize(inputStream, protocol);
    }

    public void updateRegionLocation(TConsensusGroupId regionId, TDataNodeLocation oldNode, TDataNodeLocation newNode) {
        this.addRegionNewLocation(regionId, newNode);
        this.removeRegionOldLocation(regionId, oldNode);
    }

    private boolean addRegionNewLocation(TConsensusGroupId regionId, TDataNodeLocation node) {
        RegionGroup regionGroup = this.regionGroupMap.get(regionId);
        if (regionGroup == null) {
            LOGGER.warn("not find Region Group for region {}", (Object)regionId);
            return false;
        }
        if (regionGroup.getReplicaSet().getDataNodeLocations().contains(node)) {
            LOGGER.info("Node is already in region locations, node: {}, region: {}", (Object)node, (Object)regionId);
            return true;
        }
        return regionGroup.getReplicaSet().getDataNodeLocations().add(node);
    }

    private boolean removeRegionOldLocation(TConsensusGroupId regionId, TDataNodeLocation node) {
        RegionGroup regionGroup = this.regionGroupMap.get(regionId);
        if (regionGroup == null) {
            LOGGER.warn("not find Region Group for region {}", (Object)regionId);
            return false;
        }
        if (!regionGroup.getReplicaSet().getDataNodeLocations().contains(node)) {
            LOGGER.info("Node is Not in region locations, no need to remove it, node: {}, region: {}", (Object)node, (Object)regionId);
            return true;
        }
        return regionGroup.getReplicaSet().getDataNodeLocations().remove(node);
    }

    public boolean containRegion(TConsensusGroupId regionId) {
        return this.regionGroupMap.containsKey(regionId);
    }

    public String getStorageGroupName() {
        return this.storageGroupName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StorageGroupPartitionTable that = (StorageGroupPartitionTable)o;
        return this.isPredeleted == that.isPredeleted && this.regionGroupMap.equals(that.regionGroupMap) && this.schemaPartitionTable.equals((Object)that.schemaPartitionTable) && this.dataPartitionTable.equals((Object)that.dataPartitionTable);
    }

    public int hashCode() {
        return Objects.hash(this.isPredeleted, this.regionGroupMap, this.schemaPartitionTable, this.dataPartitionTable);
    }
}

