/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.executable.ExecutableResource;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.commons.udf.service.UDFClassLoader;
import org.apache.iotdb.commons.udf.service.UDFExecutableManager;
import org.apache.iotdb.commons.udf.service.UDFRegistrationService;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.write.CreateFunctionPlan;
import org.apache.iotdb.confignode.consensus.request.write.DropFunctionPlan;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDFInfo
implements SnapshotProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(UDFInfo.class);
    private static final ConfigNodeConfig CONFIG_NODE_CONF = ConfigNodeDescriptor.getInstance().getConf();
    private final UDFExecutableManager udfExecutableManager = UDFExecutableManager.setupAndGetInstance((String)CONFIG_NODE_CONF.getTemporaryLibDir(), (String)CONFIG_NODE_CONF.getUdfLibDir());
    private final UDFRegistrationService udfRegistrationService = UDFRegistrationService.setupAndGetInstance((String)CONFIG_NODE_CONF.getSystemUdfDir());

    public synchronized void validateBeforeRegistration(String functionName, String className, List<String> uris) throws Exception {
        this.udfRegistrationService.validate(functionName, className);
        if (uris.isEmpty()) {
            this.fetchExecutablesAndCheckInstantiation(className);
        } else {
            this.fetchExecutablesAndCheckInstantiation(className, uris);
        }
    }

    private void fetchExecutablesAndCheckInstantiation(String className) throws Exception {
        try (UDFClassLoader temporaryUdfClassLoader = new UDFClassLoader(CONFIG_NODE_CONF.getUdfLibDir());){
            Class.forName(className, true, (ClassLoader)temporaryUdfClassLoader).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchExecutablesAndCheckInstantiation(String className, List<String> uris) throws Exception {
        ExecutableResource resource = this.udfExecutableManager.request(uris);
        try (UDFClassLoader temporaryUdfClassLoader = new UDFClassLoader(resource.getResourceDir());){
            Class.forName(className, true, (ClassLoader)temporaryUdfClassLoader).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        finally {
            this.udfExecutableManager.removeFromTemporaryLibRoot(resource);
        }
    }

    public synchronized TSStatus createFunction(CreateFunctionPlan req) {
        String functionName = req.getFunctionName();
        String className = req.getClassName();
        List<String> uris = req.getUris();
        try {
            this.udfRegistrationService.register(functionName, className, uris, this.udfExecutableManager, true);
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (Exception e) {
            String errorMessage = String.format("[ConfigNode] Failed to register UDF %s(class name: %s, uris: %s), because of exception: %s", functionName, className, uris, e);
            LOGGER.warn(errorMessage, (Throwable)e);
            return new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage(errorMessage);
        }
    }

    public synchronized TSStatus dropFunction(DropFunctionPlan req) {
        try {
            this.udfRegistrationService.deregister(req.getFunctionName());
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (Exception e) {
            String errorMessage = String.format("[ConfigNode] Failed to deregister UDF %s, because of exception: %s", req.getFunctionName(), e);
            LOGGER.warn(errorMessage, (Throwable)e);
            return new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage(errorMessage);
        }
    }

    public synchronized boolean processTakeSnapshot(File snapshotDir) throws IOException {
        return this.udfExecutableManager.processTakeSnapshot(snapshotDir) && this.udfRegistrationService.processTakeSnapshot(snapshotDir);
    }

    public synchronized void processLoadSnapshot(File snapshotDir) throws IOException {
        this.udfExecutableManager.processLoadSnapshot(snapshotDir);
        this.udfRegistrationService.processLoadSnapshot(snapshotDir);
    }
}

