/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.auth.authorizer.BasicAuthorizer;
import org.apache.iotdb.commons.auth.authorizer.IAuthorizer;
import org.apache.iotdb.commons.auth.entity.PathPrivilege;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.auth.entity.Role;
import org.apache.iotdb.commons.auth.entity.User;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.commons.utils.AuthUtils;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.consensus.request.auth.AuthorPlan;
import org.apache.iotdb.confignode.consensus.response.PermissionInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TPermissionInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TRoleResp;
import org.apache.iotdb.confignode.rpc.thrift.TUserResp;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorInfo
implements SnapshotProcessor {
    private static final Logger logger = LoggerFactory.getLogger(AuthorInfo.class);
    private static final CommonConfig commonConfig = CommonDescriptor.getInstance().getConfig();
    private IAuthorizer authorizer;

    public AuthorInfo() {
        try {
            this.authorizer = BasicAuthorizer.getInstance();
        }
        catch (AuthException e) {
            logger.error("get user or role permissionInfo failed because ", (Throwable)e);
        }
    }

    public TPermissionInfoResp login(String username, String password) {
        boolean status;
        String loginMessage = null;
        TSStatus tsStatus = new TSStatus();
        TPermissionInfoResp result = new TPermissionInfoResp();
        try {
            status = this.authorizer.login(username, password);
            if (status) {
                result = this.getUserPermissionInfo(username);
                result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Login successfully"));
            } else {
                result = AuthUtils.generateEmptyPermissionInfoResp();
            }
        }
        catch (AuthException e) {
            logger.error("meet error while logging in.", (Throwable)e);
            status = false;
            loginMessage = e.getMessage();
        }
        if (!status) {
            tsStatus.setMessage(loginMessage != null ? loginMessage : "Authentication failed.");
            tsStatus.setCode(TSStatusCode.WRONG_LOGIN_PASSWORD_ERROR.getStatusCode());
            result.setStatus(tsStatus);
        }
        return result;
    }

    public TPermissionInfoResp checkUserPrivileges(String username, List<String> paths, int permission) {
        boolean status = true;
        TPermissionInfoResp result = new TPermissionInfoResp();
        try {
            for (String path : paths) {
                if (this.checkOnePath(username, path, permission)) continue;
                status = false;
                break;
            }
        }
        catch (AuthException e) {
            status = false;
        }
        if (status) {
            try {
                result = this.getUserPermissionInfo(username);
                result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
            }
            catch (AuthException e) {
                result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_PERMISSION_EXCEPTION_ERROR, (String)e.getMessage()));
            }
        } else {
            result = AuthUtils.generateEmptyPermissionInfoResp();
            result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.NO_PERMISSION_ERROR));
        }
        return result;
    }

    private boolean checkOnePath(String username, String path, int permission) throws AuthException {
        try {
            if (this.authorizer.checkUserPrivileges(username, path, permission)) {
                return true;
            }
        }
        catch (AuthException e) {
            logger.error("Error occurs when checking the seriesPath {} for user {}", new Object[]{path, username, e});
            throw new AuthException((Throwable)e);
        }
        return false;
    }

    public TSStatus authorNonQuery(AuthorPlan authorPlan) {
        ConfigPhysicalPlanType authorType = authorPlan.getAuthorType();
        String userName = authorPlan.getUserName();
        String roleName = authorPlan.getRoleName();
        String password = authorPlan.getPassword();
        String newPassword = authorPlan.getNewPassword();
        Set<Integer> permissions = authorPlan.getPermissions();
        List<String> nodeNameList = authorPlan.getNodeNameList();
        try {
            switch (authorType) {
                case UpdateUser: {
                    this.authorizer.updateUserPassword(userName, newPassword);
                    break;
                }
                case CreateUser: {
                    this.authorizer.createUser(userName, password);
                    break;
                }
                case CreateRole: {
                    this.authorizer.createRole(roleName);
                    break;
                }
                case DropUser: {
                    this.authorizer.deleteUser(userName);
                    break;
                }
                case DropRole: {
                    this.authorizer.deleteRole(roleName);
                    break;
                }
                case GrantRole: {
                    for (int i : permissions) {
                        for (String path : nodeNameList) {
                            this.authorizer.grantPrivilegeToRole(roleName, path, i);
                        }
                    }
                    break;
                }
                case GrantUser: {
                    for (int i : permissions) {
                        for (String path : nodeNameList) {
                            this.authorizer.grantPrivilegeToUser(userName, path, i);
                        }
                    }
                    break;
                }
                case GrantRoleToUser: {
                    this.authorizer.grantRoleToUser(roleName, userName);
                    break;
                }
                case RevokeUser: {
                    for (int i : permissions) {
                        for (String path : nodeNameList) {
                            this.authorizer.revokePrivilegeFromUser(userName, path, i);
                        }
                    }
                    break;
                }
                case RevokeRole: {
                    for (int i : permissions) {
                        for (String path : nodeNameList) {
                            this.authorizer.revokePrivilegeFromRole(roleName, path, i);
                        }
                    }
                    break;
                }
                case RevokeRoleFromUser: {
                    this.authorizer.revokeRoleFromUser(roleName, userName);
                    break;
                }
                default: {
                    throw new AuthException("unknown type: " + (Object)((Object)authorPlan.getAuthorType()));
                }
            }
        }
        catch (AuthException e) {
            return RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_PERMISSION_EXCEPTION_ERROR, (String)e.getMessage());
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public PermissionInfoResp executeListUsers(AuthorPlan plan) throws AuthException {
        PermissionInfoResp result = new PermissionInfoResp();
        HashMap<String, List<String>> permissionInfo = new HashMap<String, List<String>>();
        List userList = this.authorizer.listAllUsers();
        if (!plan.getRoleName().isEmpty()) {
            try {
                Role role = this.authorizer.getRole(plan.getRoleName());
                if (role == null) {
                    result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.ROLE_NOT_EXIST_ERROR, (String)("No such role : " + plan.getRoleName())));
                    result.setPermissionInfo(permissionInfo);
                    return result;
                }
            }
            catch (AuthException e) {
                throw new AuthException((Throwable)e);
            }
            Iterator itr = userList.iterator();
            while (itr.hasNext()) {
                User userObj = this.authorizer.getUser((String)itr.next());
                if (userObj != null && userObj.hasRole(plan.getRoleName())) continue;
                itr.remove();
            }
        }
        permissionInfo.put("user", userList);
        result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
        result.setPermissionInfo(permissionInfo);
        return result;
    }

    public PermissionInfoResp executeListRoles(AuthorPlan plan) throws AuthException {
        PermissionInfoResp result = new PermissionInfoResp();
        HashMap<String, List<String>> permissionInfo = new HashMap<String, List<String>>();
        ArrayList<String> roleList = new ArrayList<String>();
        if (plan.getUserName().isEmpty()) {
            roleList.addAll(this.authorizer.listAllRoles());
        } else {
            User user;
            try {
                user = this.authorizer.getUser(plan.getUserName());
                if (user == null) {
                    result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.USER_NOT_EXIST_ERROR, (String)("No such user : " + plan.getUserName())));
                    result.setPermissionInfo(permissionInfo);
                    return result;
                }
            }
            catch (AuthException e) {
                throw new AuthException((Throwable)e);
            }
            for (String roleN : user.getRoleList()) {
                roleList.add(roleN);
            }
        }
        permissionInfo.put("role", roleList);
        result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
        result.setPermissionInfo(permissionInfo);
        return result;
    }

    public PermissionInfoResp executeListRolePrivileges(AuthorPlan plan) throws AuthException {
        Role role;
        PermissionInfoResp result = new PermissionInfoResp();
        HashMap<String, List<String>> permissionInfo = new HashMap<String, List<String>>();
        try {
            role = this.authorizer.getRole(plan.getRoleName());
            if (role == null) {
                result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.ROLE_NOT_EXIST_ERROR, (String)("No such role : " + plan.getRoleName())));
                result.setPermissionInfo(permissionInfo);
                return result;
            }
        }
        catch (AuthException e) {
            throw new AuthException((Throwable)e);
        }
        HashSet<String> rolePrivilegesSet = new HashSet<String>();
        for (PathPrivilege pathPrivilege : role.getPrivilegeList()) {
            if (plan.getNodeNameList().isEmpty()) {
                rolePrivilegesSet.add(pathPrivilege.toString());
                continue;
            }
            for (String path : plan.getNodeNameList()) {
                if (!AuthUtils.pathOrBelongsTo((String)path, (String)pathPrivilege.getPath())) continue;
                rolePrivilegesSet.add(pathPrivilege.toString());
            }
        }
        permissionInfo.put("privilege", new ArrayList(rolePrivilegesSet));
        result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
        result.setPermissionInfo(permissionInfo);
        return result;
    }

    public PermissionInfoResp executeListUserPrivileges(AuthorPlan plan) throws AuthException {
        User user;
        PermissionInfoResp result = new PermissionInfoResp();
        HashMap<String, List<String>> permissionInfo = new HashMap<String, List<String>>();
        try {
            user = this.authorizer.getUser(plan.getUserName());
            if (user == null) {
                result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.USER_NOT_EXIST_ERROR, (String)("No such user : " + plan.getUserName())));
                result.setPermissionInfo(permissionInfo);
                return result;
            }
        }
        catch (AuthException e) {
            throw new AuthException((Throwable)e);
        }
        ArrayList<String> userPrivilegesList = new ArrayList<String>();
        if ("root".equals(plan.getUserName())) {
            for (PrivilegeType privilegeType : PrivilegeType.values()) {
                userPrivilegesList.add(privilegeType.toString());
            }
        } else {
            ArrayList<String> rolePrivileges = new ArrayList<String>();
            HashSet<String> userPrivilegeSet = new HashSet<String>();
            for (PathPrivilege pathPrivilege : user.getPrivilegeList()) {
                if (plan.getNodeNameList().isEmpty() && !userPrivilegeSet.contains(pathPrivilege.toString())) {
                    rolePrivileges.add("");
                    userPrivilegeSet.add(pathPrivilege.toString());
                    continue;
                }
                for (String path : plan.getNodeNameList()) {
                    if (!AuthUtils.pathOrBelongsTo((String)path, (String)pathPrivilege.getPath()) || userPrivilegeSet.contains(pathPrivilege.toString())) continue;
                    rolePrivileges.add("");
                    userPrivilegeSet.add(pathPrivilege.toString());
                }
            }
            userPrivilegesList.addAll(userPrivilegeSet);
            for (String roleN : user.getRoleList()) {
                Role role = this.authorizer.getRole(roleN);
                if (roleN == null) continue;
                HashSet<String> rolePrivilegeSet = new HashSet<String>();
                for (PathPrivilege pathPrivilege : role.getPrivilegeList()) {
                    if (plan.getNodeNameList().isEmpty() && !rolePrivilegeSet.contains(pathPrivilege.toString())) {
                        rolePrivileges.add(roleN);
                        rolePrivilegeSet.add(pathPrivilege.toString());
                        continue;
                    }
                    for (String path : plan.getNodeNameList()) {
                        if (!AuthUtils.pathOrBelongsTo((String)path, (String)pathPrivilege.getPath()) || rolePrivilegeSet.contains(pathPrivilege.toString())) continue;
                        rolePrivileges.add(roleN);
                        rolePrivilegeSet.add(pathPrivilege.toString());
                    }
                }
                userPrivilegesList.addAll(rolePrivilegeSet);
            }
            permissionInfo.put("role", rolePrivileges);
        }
        permissionInfo.put("privilege", userPrivilegesList);
        result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
        result.setPermissionInfo(permissionInfo);
        return result;
    }

    public boolean processTakeSnapshot(File snapshotDir) throws TException, IOException {
        return this.authorizer.processTakeSnapshot(snapshotDir);
    }

    public void processLoadSnapshot(File snapshotDir) throws TException, IOException {
        this.authorizer.processLoadSnapshot(snapshotDir);
    }

    public void clear() throws AuthException {
        File roleFolder;
        File userFolder = new File(commonConfig.getUserFolder());
        if (userFolder.exists()) {
            FileUtils.deleteDirectory((File)userFolder);
        }
        if ((roleFolder = new File(commonConfig.getRoleFolder())).exists()) {
            FileUtils.deleteDirectory((File)roleFolder);
        }
        this.authorizer.reset();
    }

    public TPermissionInfoResp getUserPermissionInfo(String username) throws AuthException {
        TPermissionInfoResp result = new TPermissionInfoResp();
        TUserResp tUserResp = new TUserResp();
        HashMap<String, TRoleResp> tRoleRespMap = new HashMap<String, TRoleResp>();
        ArrayList<String> userPrivilegeList = new ArrayList<String>();
        User user = this.authorizer.getUser(username);
        if (user.getPrivilegeList() != null) {
            for (PathPrivilege pathPrivilege : user.getPrivilegeList()) {
                userPrivilegeList.add(pathPrivilege.getPath());
                String privilegeIdList = pathPrivilege.getPrivileges().toString();
                userPrivilegeList.add(privilegeIdList.substring(1, privilegeIdList.length() - 1));
            }
            tUserResp.setUsername(user.getName());
            tUserResp.setPassword(user.getPassword());
            tUserResp.setPrivilegeList(userPrivilegeList);
            tUserResp.setRoleList(user.getRoleList());
        }
        if (user.getRoleList() != null) {
            for (String roleName : user.getRoleList()) {
                Role role = this.authorizer.getRole(roleName);
                ArrayList<String> rolePrivilegeList = new ArrayList<String>();
                for (PathPrivilege pathPrivilege : role.getPrivilegeList()) {
                    rolePrivilegeList.add(pathPrivilege.getPath());
                    String privilegeIdList = pathPrivilege.getPrivileges().toString();
                    rolePrivilegeList.add(privilegeIdList.substring(1, privilegeIdList.length() - 1));
                }
                tRoleRespMap.put(roleName, new TRoleResp(roleName, rolePrivilegeList));
            }
        }
        result.setUserInfo(tUserResp);
        result.setRoleInfo(tRoleRespMap);
        return result;
    }
}

