/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.commons.partition.DataPartitionTable;
import org.apache.iotdb.commons.partition.SchemaPartitionTable;
import org.apache.iotdb.commons.partition.executor.SeriesPartitionExecutor;
import org.apache.iotdb.confignode.client.sync.datanode.SyncDataNodeClientPool;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.read.GetDataPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetNodePathsPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetOrCreateDataPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetOrCreateSchemaPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetRegionInfoListPlan;
import org.apache.iotdb.confignode.consensus.request.read.GetSchemaPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.write.CreateDataPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.write.CreateRegionGroupsPlan;
import org.apache.iotdb.confignode.consensus.request.write.CreateSchemaPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.write.PreDeleteStorageGroupPlan;
import org.apache.iotdb.confignode.consensus.request.write.UpdateRegionLocationPlan;
import org.apache.iotdb.confignode.consensus.response.DataPartitionResp;
import org.apache.iotdb.confignode.consensus.response.SchemaNodeManagementResp;
import org.apache.iotdb.confignode.consensus.response.SchemaPartitionResp;
import org.apache.iotdb.confignode.exception.NotEnoughDataNodeException;
import org.apache.iotdb.confignode.exception.StorageGroupNotExistsException;
import org.apache.iotdb.confignode.manager.ClusterSchemaManager;
import org.apache.iotdb.confignode.manager.ConsensusManager;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.ProcedureManager;
import org.apache.iotdb.confignode.manager.load.LoadManager;
import org.apache.iotdb.confignode.manager.load.heartbeat.IRegionGroupCache;
import org.apache.iotdb.confignode.persistence.partition.PartitionInfo;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.consensus.common.response.ConsensusReadResponse;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionManager.class);
    private final IManager configManager;
    private final PartitionInfo partitionInfo;
    private SeriesPartitionExecutor executor;
    private final Object scheduleMonitor = new Object();
    private static final int REGION_CLEANER_WORK_INTERVAL = 10;
    private final ScheduledExecutorService regionCleaner;
    private Future<?> currentRegionCleanerFuture;
    private final Map<TConsensusGroupId, IRegionGroupCache> regionGroupCacheMap;

    public PartitionManager(IManager configManager, PartitionInfo partitionInfo) {
        this.configManager = configManager;
        this.partitionInfo = partitionInfo;
        this.regionCleaner = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)"IoTDB-Region-Cleaner");
        this.regionGroupCacheMap = new ConcurrentHashMap<TConsensusGroupId, IRegionGroupCache>();
        this.setSeriesPartitionExecutor();
    }

    private void setSeriesPartitionExecutor() {
        ConfigNodeConfig conf = ConfigNodeDescriptor.getInstance().getConf();
        this.executor = SeriesPartitionExecutor.getSeriesPartitionExecutor((String)conf.getSeriesPartitionExecutorClass(), (int)conf.getSeriesPartitionSlotNum());
    }

    public DataSet getSchemaPartition(GetSchemaPartitionPlan req) {
        return this.getConsensusManager().read(req).getDataset();
    }

    public DataSet getDataPartition(GetDataPartitionPlan req) {
        return this.getConsensusManager().read(req).getDataset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet getOrCreateSchemaPartition(GetOrCreateSchemaPartitionPlan req) {
        SchemaPartitionResp resp = (SchemaPartitionResp)this.getSchemaPartition(req);
        if (resp.isAllPartitionsExist()) {
            return resp;
        }
        PartitionManager partitionManager = this;
        synchronized (partitionManager) {
            Map<String, List<TSeriesPartitionSlot>> unassignedSchemaPartitionSlotsMap = this.partitionInfo.filterUnassignedSchemaPartitionSlots(req.getPartitionSlotsMap());
            ConcurrentHashMap<String, Integer> unassignedSchemaPartitionSlotsCountMap = new ConcurrentHashMap<String, Integer>();
            unassignedSchemaPartitionSlotsMap.forEach((storageGroup, unassignedSchemaPartitionSlots) -> unassignedSchemaPartitionSlotsCountMap.put((String)storageGroup, unassignedSchemaPartitionSlots.size()));
            TSStatus status = this.extendRegionsIfNecessary(unassignedSchemaPartitionSlotsCountMap, TConsensusGroupType.SchemaRegion);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                resp.setStatus(status);
                return resp;
            }
            status = this.getConsensusManager().confirmLeader();
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                resp.setStatus(status);
                return resp;
            }
            Map<String, SchemaPartitionTable> assignedSchemaPartition = this.getLoadManager().allocateSchemaPartition(unassignedSchemaPartitionSlotsMap);
            CreateSchemaPartitionPlan createPlan = new CreateSchemaPartitionPlan();
            createPlan.setAssignedSchemaPartition(assignedSchemaPartition);
            this.getConsensusManager().write(createPlan);
        }
        return this.getSchemaPartition(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet getOrCreateDataPartition(GetOrCreateDataPartitionPlan req) {
        DataPartitionResp resp = (DataPartitionResp)this.getDataPartition(req);
        if (resp.isAllPartitionsExist()) {
            return resp;
        }
        PartitionManager partitionManager = this;
        synchronized (partitionManager) {
            Map<String, Map<TSeriesPartitionSlot, List<TTimePartitionSlot>>> unassignedDataPartitionSlotsMap = this.partitionInfo.filterUnassignedDataPartitionSlots(req.getPartitionSlotsMap());
            ConcurrentHashMap<String, Integer> unassignedDataPartitionSlotsCountMap = new ConcurrentHashMap<String, Integer>();
            unassignedDataPartitionSlotsMap.forEach((storageGroup, unassignedDataPartitionSlots) -> {
                AtomicInteger unassignedDataPartitionSlotsCount = new AtomicInteger(0);
                unassignedDataPartitionSlots.values().forEach(timePartitionSlots -> unassignedDataPartitionSlotsCount.getAndAdd(timePartitionSlots.size()));
                unassignedDataPartitionSlotsCountMap.put((String)storageGroup, unassignedDataPartitionSlotsCount.get());
            });
            TSStatus status = this.extendRegionsIfNecessary(unassignedDataPartitionSlotsCountMap, TConsensusGroupType.DataRegion);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                resp.setStatus(status);
                return resp;
            }
            status = this.getConsensusManager().confirmLeader();
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                resp.setStatus(status);
                return resp;
            }
            Map<String, DataPartitionTable> assignedDataPartition = this.getLoadManager().allocateDataPartition(unassignedDataPartitionSlotsMap);
            CreateDataPartitionPlan createPlan = new CreateDataPartitionPlan();
            createPlan.setAssignedDataPartition(assignedDataPartition);
            this.getConsensusManager().write(createPlan);
        }
        return this.getDataPartition(req);
    }

    private TSStatus extendRegionsIfNecessary(Map<String, Integer> unassignedPartitionSlotsCountMap, TConsensusGroupType consensusGroupType) {
        TSStatus result = new TSStatus();
        try {
            ConcurrentHashMap<String, Integer> allotmentMap = new ConcurrentHashMap<String, Integer>();
            for (Map.Entry<String, Integer> entry : unassignedPartitionSlotsCountMap.entrySet()) {
                int delta;
                float allocatedRegionCount = this.partitionInfo.getRegionCount(entry.getKey(), consensusGroupType);
                float slotCount = this.partitionInfo.getSlotCount(entry.getKey()) + entry.getValue();
                float maxRegionCount = this.getClusterSchemaManager().getMaxRegionGroupCount(entry.getKey(), consensusGroupType);
                float maxSlotCount = ConfigNodeDescriptor.getInstance().getConf().getSeriesPartitionSlotNum();
                if (allocatedRegionCount == 0.0f) {
                    delta = Math.min((int)maxRegionCount, Math.max(1, (int)Math.ceil(slotCount * maxRegionCount / maxSlotCount)));
                    allotmentMap.put(entry.getKey(), delta);
                    continue;
                }
                if (!(allocatedRegionCount < maxRegionCount) || !(slotCount / allocatedRegionCount > maxSlotCount / maxRegionCount)) continue;
                delta = Math.min((int)(maxRegionCount - allocatedRegionCount), Math.max(1, (int)Math.ceil(slotCount * maxRegionCount / maxSlotCount - allocatedRegionCount)));
                allotmentMap.put(entry.getKey(), delta);
            }
            if (!allotmentMap.isEmpty()) {
                CreateRegionGroupsPlan createRegionGroupsPlan = this.getLoadManager().allocateRegionGroups(allotmentMap, consensusGroupType);
                result = this.getProcedureManager().createRegionGroups(createRegionGroupsPlan);
            } else {
                result = RpcUtils.SUCCESS_STATUS;
            }
        }
        catch (NotEnoughDataNodeException e) {
            LOGGER.error("ConfigNode failed to extend Region because there are not enough DataNodes");
            result.setCode(TSStatusCode.NOT_ENOUGH_DATA_NODE.getStatusCode());
        }
        catch (StorageGroupNotExistsException e) {
            LOGGER.error("ConfigNode failed to extend Region because some StorageGroup doesn't exist.");
            result.setCode(TSStatusCode.STORAGE_GROUP_NOT_EXIST.getStatusCode());
        }
        return result;
    }

    public TConsensusGroupId getPrecededDataPartition(String storageGroup, TSeriesPartitionSlot seriesPartitionSlot, TTimePartitionSlot timePartitionSlot, long timePartitionInterval) {
        return this.partitionInfo.getPrecededDataPartition(storageGroup, seriesPartitionSlot, timePartitionSlot, timePartitionInterval);
    }

    public Set<TDataNodeLocation> getStorageGroupRelatedDataNodes(String storageGroup, TConsensusGroupType type) {
        return this.partitionInfo.getStorageGroupRelatedDataNodes(storageGroup, type);
    }

    public List<TRegionReplicaSet> getAllReplicaSets() {
        return this.partitionInfo.getAllReplicaSets();
    }

    public int getRegionCount(String storageGroup, TConsensusGroupType type) throws StorageGroupNotExistsException {
        return this.partitionInfo.getRegionCount(storageGroup, type);
    }

    public List<Pair<Long, TConsensusGroupId>> getSortedRegionSlotsCounter(String storageGroup, TConsensusGroupType type) {
        return this.partitionInfo.getSortedRegionSlotsCounter(storageGroup, type);
    }

    public int generateNextRegionGroupId() {
        return this.partitionInfo.generateNextRegionGroupId();
    }

    public DataSet getNodePathsPartition(GetNodePathsPartitionPlan physicalPlan) {
        ConsensusReadResponse consensusReadResponse = this.getConsensusManager().read(physicalPlan);
        SchemaNodeManagementResp schemaNodeManagementResp = (SchemaNodeManagementResp)consensusReadResponse.getDataset();
        return schemaNodeManagementResp;
    }

    public void preDeleteStorageGroup(String storageGroup, PreDeleteStorageGroupPlan.PreDeleteType preDeleteType) {
        PreDeleteStorageGroupPlan preDeleteStorageGroupPlan = new PreDeleteStorageGroupPlan(storageGroup, preDeleteType);
        this.getConsensusManager().write(preDeleteStorageGroupPlan);
    }

    public void addMetrics() {
        this.partitionInfo.addMetrics();
    }

    public TSeriesPartitionSlot getSeriesPartitionSlot(String devicePath) {
        return this.executor.getSeriesPartitionSlot(devicePath);
    }

    public DataSet getRegionInfoList(GetRegionInfoListPlan req) {
        return this.getConsensusManager().read(req).getDataset();
    }

    public TSStatus updateRegionLocation(UpdateRegionLocationPlan req) {
        if (this.regionGroupCacheMap.containsKey(req.getRegionId())) {
            this.regionGroupCacheMap.get(req.getRegionId()).removeCacheIfExists(req.getOldNode().getDataNodeId());
        }
        return this.getConsensusManager().write(req).getStatus();
    }

    public String getRegionStorageGroup(TConsensusGroupId regionId) {
        return this.partitionInfo.getRegionStorageGroup(regionId);
    }

    public void clearDeletedRegions() {
        Optional.ofNullable(this.getConsensusManager()).ifPresent(consensusManager -> {
            Set<TRegionReplicaSet> deletedRegionSet;
            if (this.getConsensusManager().isLeader() && !(deletedRegionSet = this.partitionInfo.getDeletedRegionSet()).isEmpty()) {
                LOGGER.info("DELETE REGIONS {} START", deletedRegionSet.stream().map(TRegionReplicaSet::getRegionId).collect(Collectors.toList()));
                deletedRegionSet.forEach(regionReplicaSet -> this.removeRegionGroupCache(regionReplicaSet.regionId));
                SyncDataNodeClientPool.getInstance().deleteRegions(deletedRegionSet);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRegionCleaner() {
        Object object = this.scheduleMonitor;
        synchronized (object) {
            if (this.currentRegionCleanerFuture == null) {
                this.currentRegionCleanerFuture = ScheduledExecutorUtil.safelyScheduleAtFixedRate((ScheduledExecutorService)this.regionCleaner, this::clearDeletedRegions, (long)0L, (long)10L, (TimeUnit)TimeUnit.SECONDS);
                LOGGER.info("RegionCleaner is started successfully.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRegionCleaner() {
        Object object = this.scheduleMonitor;
        synchronized (object) {
            if (this.currentRegionCleanerFuture != null) {
                this.currentRegionCleanerFuture.cancel(false);
                this.currentRegionCleanerFuture = null;
                this.regionGroupCacheMap.clear();
                LOGGER.info("RegionCleaner is stopped successfully.");
            }
        }
    }

    public Map<TConsensusGroupId, IRegionGroupCache> getRegionGroupCacheMap() {
        return this.regionGroupCacheMap;
    }

    public void removeRegionGroupCache(TConsensusGroupId consensusGroupId) {
        this.regionGroupCacheMap.remove(consensusGroupId);
    }

    public Map<TConsensusGroupId, Integer> getAllLeadership() {
        ConcurrentHashMap<TConsensusGroupId, Integer> result = new ConcurrentHashMap<TConsensusGroupId, Integer>();
        if (ConfigNodeDescriptor.getInstance().getConf().getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.multileader.MultiLeaderConsensus")) {
            this.regionGroupCacheMap.forEach((consensusGroupId, regionGroupCache) -> {
                if (consensusGroupId.getType().equals((Object)TConsensusGroupType.SchemaRegion)) {
                    int leaderDataNodeId = regionGroupCache.getLeaderDataNodeId();
                    if (this.configManager.getNodeManager().isNodeRemoving(leaderDataNodeId)) {
                        result.put((TConsensusGroupId)consensusGroupId, -1);
                    } else {
                        result.put((TConsensusGroupId)consensusGroupId, leaderDataNodeId);
                    }
                }
            });
            this.getLoadManager().getRouteBalancer().getRouteMap().forEach((consensusGroupId, regionReplicaSet) -> result.put((TConsensusGroupId)consensusGroupId, ((TDataNodeLocation)regionReplicaSet.getDataNodeLocations().get(0)).getDataNodeId()));
        } else {
            this.regionGroupCacheMap.forEach((consensusGroupId, regionGroupCache) -> {
                int leaderDataNodeId = regionGroupCache.getLeaderDataNodeId();
                if (this.configManager.getNodeManager().isNodeRemoving(leaderDataNodeId)) {
                    result.put((TConsensusGroupId)consensusGroupId, -1);
                } else {
                    result.put((TConsensusGroupId)consensusGroupId, leaderDataNodeId);
                }
            });
        }
        return result;
    }

    public ScheduledExecutorService getRegionCleaner() {
        return this.regionCleaner;
    }

    private ConsensusManager getConsensusManager() {
        return this.configManager.getConsensusManager();
    }

    private ClusterSchemaManager getClusterSchemaManager() {
        return this.configManager.getClusterSchemaManager();
    }

    private LoadManager getLoadManager() {
        return this.configManager.getLoadManager();
    }

    private ProcedureManager getProcedureManager() {
        return this.configManager.getProcedureManager();
    }
}

