/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.conf;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.BadNodeUrlException;
import org.apache.iotdb.confignode.client.ConfigNodeRequestType;
import org.apache.iotdb.confignode.client.sync.confignode.SyncConfigNodeClientPool;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.conf.ConfigNodeStartupCheck;
import org.apache.iotdb.confignode.conf.SystemPropertiesUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigNodeRemoveCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigNodeStartupCheck.class);
    private static final ConfigNodeConfig CONF = ConfigNodeDescriptor.getInstance().getConf();
    private final File systemPropertiesFile = new File(CONF.getSystemDir() + File.separator + "confignode-system.properties");
    private final Properties systemProperties = new Properties();

    public TConfigNodeLocation removeCheck(TEndPoint endPoint) {
        TConfigNodeLocation nodeLocation = new TConfigNodeLocation();
        if (!this.systemPropertiesFile.exists()) {
            LOGGER.error("The system properties file is not exists. IoTDB-ConfigNode is shutdown.");
            return nodeLocation;
        }
        try (FileInputStream inputStream = new FileInputStream(this.systemPropertiesFile);){
            this.systemProperties.load(inputStream);
            nodeLocation = this.getConfigNodeList().stream().filter(e -> e.getInternalEndPoint().equals(endPoint)).findFirst().orElse(null);
        }
        catch (IOException | BadNodeUrlException e2) {
            LOGGER.error("Load system properties file failed.", e2);
        }
        return nodeLocation;
    }

    public void removeConfigNode(TConfigNodeLocation removedNode) throws BadNodeUrlException, IOException {
        TSStatus status = new TSStatus();
        for (TConfigNodeLocation configNodeLocation : this.getConfigNodeList()) {
            status = (TSStatus)SyncConfigNodeClientPool.getInstance().sendSyncRequestToConfigNodeWithRetry(configNodeLocation.getInternalEndPoint(), removedNode, ConfigNodeRequestType.REMOVE_CONFIG_NODE);
            if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
            break;
        }
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            LOGGER.error(status.getMessage());
            throw new IOException("Remove ConfigNode failed:");
        }
    }

    public List<TConfigNodeLocation> getConfigNodeList() throws BadNodeUrlException, IOException {
        return SystemPropertiesUtils.loadConfigNodeList();
    }

    public int getConsensusPort() {
        return Integer.parseInt(this.systemProperties.getProperty("consensus_port"));
    }

    public static ConfigNodeRemoveCheck getInstance() {
        return ConfigNodeConfRemoveCheckHolder.INSTANCE;
    }

    private static class ConfigNodeConfRemoveCheckHolder {
        private static final ConfigNodeRemoveCheck INSTANCE = new ConfigNodeRemoveCheck();

        private ConfigNodeConfRemoveCheckHolder() {
        }
    }
}

