/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client.async.handlers;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.async.handlers.AbstractRetryHandler;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadConfigurationHandler
extends AbstractRetryHandler
implements AsyncMethodCallback<TSStatus> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadConfigurationHandler.class);
    private final List<TSStatus> dataNodeResponseStatus;

    public LoadConfigurationHandler(CountDownLatch countDownLatch, DataNodeRequestType requestType, TDataNodeLocation targetDataNode, Map<Integer, TDataNodeLocation> dataNodeLocationMap, List<TSStatus> dataNodeResponseStatus) {
        super(countDownLatch, requestType, targetDataNode, dataNodeLocationMap);
        this.dataNodeResponseStatus = dataNodeResponseStatus;
    }

    public void onComplete(TSStatus response) {
        if (response.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.dataNodeResponseStatus.add(response);
            this.dataNodeLocationMap.remove(this.targetDataNode.getDataNodeId());
            LOGGER.info("Successfully Load Configuration on DataNode: {}", (Object)this.targetDataNode);
        } else {
            this.dataNodeResponseStatus.add(response);
            LOGGER.error("Failed to Load Configuration on DataNode {}, {}", this.dataNodeLocationMap.get(this.targetDataNode.getDataNodeId()), (Object)response);
        }
        this.countDownLatch.countDown();
    }

    public void onError(Exception exception) {
        this.countDownLatch.countDown();
        this.dataNodeResponseStatus.add(new TSStatus(RpcUtils.getStatus((int)TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode(), (String)("Load Configuration error on DataNode: {id=" + this.targetDataNode.getDataNodeId() + ", internalEndPoint=" + this.targetDataNode.getInternalEndPoint() + "}" + exception.getMessage()))));
    }
}

