/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.trigger.service;

import java.io.IOException;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.commons.trigger.service.TriggerClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerClassLoaderManager
implements IService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TriggerClassLoaderManager.class);
    private final String libRoot;
    private volatile TriggerClassLoader activeClassLoader;
    private static TriggerClassLoaderManager INSTANCE = null;

    private TriggerClassLoaderManager(String libRoot) {
        this.libRoot = libRoot;
        LOGGER.info("Trigger lib root: {}", (Object)libRoot);
        this.activeClassLoader = null;
    }

    public TriggerClassLoader updateAndGetActiveClassLoader() throws IOException {
        TriggerClassLoader deprecatedClassLoader = this.activeClassLoader;
        this.activeClassLoader = new TriggerClassLoader(this.libRoot);
        deprecatedClassLoader.close();
        return this.activeClassLoader;
    }

    public TriggerClassLoader getActiveClassLoader() {
        return this.activeClassLoader;
    }

    @Override
    public void start() throws StartupException {
        try {
            SystemFileFactory.INSTANCE.makeDirIfNecessary(this.libRoot);
            this.activeClassLoader = new TriggerClassLoader(this.libRoot);
        }
        catch (IOException e) {
            throw new StartupException(this.getID().getName(), e.getMessage());
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public ServiceType getID() {
        return ServiceType.TRIGGER_CLASSLOADER_MANAGER_SERVICE;
    }

    public static synchronized TriggerClassLoaderManager setupAndGetInstance(String libRoot) {
        if (INSTANCE == null) {
            INSTANCE = new TriggerClassLoaderManager(libRoot);
        }
        return INSTANCE;
    }

    public static TriggerClassLoaderManager getInstance() {
        return INSTANCE;
    }
}

