/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.exception.runtime.RPCServiceException;
import org.apache.iotdb.commons.service.AbstractThriftServiceThread;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.commons.service.ThriftService;
import org.apache.iotdb.commons.service.ThriftServiceThread;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.service.DataNodeInternalRPCServiceMBean;
import org.apache.iotdb.db.service.metrics.MetricService;
import org.apache.iotdb.db.service.metrics.enums.Metric;
import org.apache.iotdb.db.service.metrics.enums.Tag;
import org.apache.iotdb.db.service.thrift.handler.InternalServiceThriftHandler;
import org.apache.iotdb.db.service.thrift.impl.DataNodeInternalRPCServiceImpl;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.mpp.rpc.thrift.IDataNodeRPCService;
import org.apache.thrift.server.TServerEventHandler;

public class DataNodeInternalRPCService
extends ThriftService
implements DataNodeInternalRPCServiceMBean {
    private DataNodeInternalRPCServiceImpl impl;

    private DataNodeInternalRPCService() {
    }

    public ServiceType getID() {
        return ServiceType.INTERNAL_SERVICE;
    }

    public void initTProcessor() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.impl = new DataNodeInternalRPCServiceImpl();
        this.initSyncedServiceImpl(null);
        this.processor = new IDataNodeRPCService.Processor((IDataNodeRPCService.Iface)this.impl);
    }

    public void initThriftServiceThread() throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        try {
            IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
            this.thriftServiceThread = new ThriftServiceThread(this.processor, this.getID().getName(), ThreadName.DATANODE_INTERNAL_RPC_PROCESSOR.getName(), this.getBindIP(), this.getBindPort(), config.getRpcMaxConcurrentClientNum(), config.getThriftServerAwaitTimeForStopService(), (TServerEventHandler)new InternalServiceThriftHandler(), false);
        }
        catch (RPCServiceException e) {
            throw new IllegalAccessException(e.getMessage());
        }
        this.thriftServiceThread.setName(ThreadName.DATANODE_INTERNAL_RPC_SERVICE.getName());
        MetricService.getInstance().getOrCreateAutoGauge(Metric.THRIFT_ACTIVE_THREADS.toString(), MetricLevel.CORE, this.thriftServiceThread, AbstractThriftServiceThread::getActiveThreadCount, new String[]{Tag.NAME.toString(), ThreadName.DATANODE_INTERNAL_RPC_SERVICE.getName()});
    }

    public String getBindIP() {
        return IoTDBDescriptor.getInstance().getConfig().getRpcAddress();
    }

    public int getBindPort() {
        return IoTDBDescriptor.getInstance().getConfig().getInternalPort();
    }

    public static DataNodeInternalRPCService getInstance() {
        return DataNodeInternalRPCServiceHolder.INSTANCE;
    }

    private static class DataNodeInternalRPCServiceHolder {
        private static final DataNodeInternalRPCService INSTANCE = new DataNodeInternalRPCService();

        private DataNodeInternalRPCServiceHolder() {
        }
    }
}

