/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.transformation.dag.transformer;

import java.io.IOException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.mpp.transformation.api.LayerPointReader;
import org.apache.iotdb.db.mpp.transformation.api.YieldableState;
import org.apache.iotdb.tsfile.utils.Binary;

public abstract class Transformer
implements LayerPointReader {
    protected boolean hasCachedValue = false;
    protected long cachedTime;
    protected int cachedInt;
    protected long cachedLong;
    protected float cachedFloat;
    protected double cachedDouble;
    protected boolean cachedBoolean;
    protected Binary cachedBinary;
    protected boolean currentNull;

    protected Transformer() {
    }

    @Override
    public final boolean next() throws QueryProcessException, IOException {
        if (!this.hasCachedValue) {
            this.hasCachedValue = this.cacheValue();
        }
        return this.hasCachedValue;
    }

    protected abstract boolean cacheValue() throws QueryProcessException, IOException;

    @Override
    public final YieldableState yield() throws IOException, QueryProcessException {
        if (this.hasCachedValue) {
            return YieldableState.YIELDABLE;
        }
        YieldableState yieldableState = this.yieldValue();
        if (YieldableState.YIELDABLE == yieldableState) {
            this.hasCachedValue = true;
        }
        return yieldableState;
    }

    protected abstract YieldableState yieldValue() throws QueryProcessException, IOException;

    @Override
    public final void readyForNext() {
        this.hasCachedValue = false;
        this.currentNull = false;
    }

    @Override
    public final long currentTime() {
        return this.cachedTime;
    }

    @Override
    public final int currentInt() {
        return this.cachedInt;
    }

    @Override
    public final long currentLong() {
        return this.cachedLong;
    }

    @Override
    public final float currentFloat() {
        return this.cachedFloat;
    }

    @Override
    public final double currentDouble() {
        return this.cachedDouble;
    }

    @Override
    public final boolean currentBoolean() {
        return this.cachedBoolean;
    }

    @Override
    public final Binary currentBinary() {
        return this.cachedBinary;
    }

    @Override
    public final boolean isCurrentNull() {
        return this.currentNull;
    }
}

