/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.process;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.ProcessNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.FillDescriptor;
import org.apache.iotdb.db.mpp.plan.statement.component.Ordering;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class FillNode
extends ProcessNode {
    private FillDescriptor fillDescriptor;
    private Ordering scanOrder;
    private PlanNode child;

    public FillNode(PlanNodeId id) {
        super(id);
    }

    public FillNode(PlanNodeId id, FillDescriptor fillDescriptor, Ordering scanOrder) {
        this(id);
        this.fillDescriptor = fillDescriptor;
        this.scanOrder = scanOrder;
    }

    public FillNode(PlanNodeId id, PlanNode child, FillDescriptor fillDescriptor, Ordering scanOrder) {
        this(id, fillDescriptor, scanOrder);
        this.child = child;
    }

    @Override
    public List<PlanNode> getChildren() {
        return ImmutableList.of((Object)this.child);
    }

    public PlanNode getChild() {
        return this.child;
    }

    @Override
    public void addChild(PlanNode child) {
        this.child = child;
    }

    @Override
    public int allowedChildCount() {
        return 1;
    }

    @Override
    public PlanNode clone() {
        return new FillNode(this.getPlanNodeId(), this.fillDescriptor, this.scanOrder);
    }

    @Override
    public List<String> getOutputColumnNames() {
        return this.child.getOutputColumnNames();
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitFill(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.FILL.serialize(byteBuffer);
        this.fillDescriptor.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.scanOrder.ordinal(), (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.FILL.serialize(stream);
        this.fillDescriptor.serialize(stream);
        ReadWriteIOUtils.write((int)this.scanOrder.ordinal(), (OutputStream)stream);
    }

    public static FillNode deserialize(ByteBuffer byteBuffer) {
        FillDescriptor fillDescriptor = FillDescriptor.deserialize(byteBuffer);
        Ordering scanOrder = Ordering.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new FillNode(planNodeId, fillDescriptor, scanOrder);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FillNode that = (FillNode)o;
        return Objects.equals(this.fillDescriptor, that.fillDescriptor) && Objects.equals(this.child, that.child) && this.scanOrder == that.scanOrder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.fillDescriptor, this.child, this.scanOrder});
    }

    public FillDescriptor getFillDescriptor() {
        return this.fillDescriptor;
    }

    public Ordering getScanOrder() {
        return this.scanOrder;
    }
}

