/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.expression.visitor;

import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.binary.BinaryExpression;
import org.apache.iotdb.db.mpp.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimestampOperand;
import org.apache.iotdb.db.mpp.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.mpp.plan.expression.ternary.TernaryExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.UnaryExpression;

public abstract class ExpressionVisitor<R, C> {
    public R process(Expression expression, C context) {
        return expression.accept(this, context);
    }

    public abstract R visitExpression(Expression var1, C var2);

    public R visitUnaryExpression(UnaryExpression unaryExpression, C context) {
        return this.visitExpression(unaryExpression, context);
    }

    public R visitBinaryExpression(BinaryExpression binaryExpression, C context) {
        return this.visitExpression(binaryExpression, context);
    }

    public R visitTernaryExpression(TernaryExpression ternaryExpression, C context) {
        return this.visitExpression(ternaryExpression, context);
    }

    public R visitFunctionExpression(FunctionExpression functionExpression, C context) {
        return this.visitExpression(functionExpression, context);
    }

    public R visitTimeStampOperand(TimestampOperand timestampOperand, C context) {
        return this.visitExpression(timestampOperand, context);
    }

    public R visitTimeSeriesOperand(TimeSeriesOperand timeSeriesOperand, C context) {
        return this.visitExpression(timeSeriesOperand, context);
    }

    public R visitConstantOperand(ConstantOperand constantOperand, C context) {
        return this.visitExpression(constantOperand, context);
    }
}

