/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.analyze;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.exception.sql.StatementAnalyzeException;
import org.apache.iotdb.db.mpp.common.schematree.PathPatternTree;
import org.apache.iotdb.db.mpp.plan.analyze.ExpressionAnalyzer;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.mpp.plan.statement.component.ResultColumn;
import org.apache.iotdb.db.mpp.plan.statement.component.SelectComponent;
import org.apache.iotdb.db.mpp.plan.statement.crud.QueryStatement;

public class ConcatPathRewriter {
    private PathPatternTree patternTree;

    public Statement rewrite(Statement statement, PathPatternTree patternTree) throws StatementAnalyzeException {
        QueryStatement queryStatement = (QueryStatement)statement;
        this.patternTree = patternTree;
        List<PartialPath> prefixPaths = queryStatement.getFromComponent().getPrefixPaths();
        if (queryStatement.isAlignByDevice()) {
            queryStatement.getSelectComponent().getResultColumns().stream().map(ResultColumn::getExpression).forEach(expression -> ExpressionAnalyzer.constructPatternTreeFromExpression(expression, prefixPaths, patternTree));
        } else {
            List<ResultColumn> resultColumns = this.concatSelectWithFrom(queryStatement.getSelectComponent(), prefixPaths, queryStatement.isGroupByLevel());
            queryStatement.getSelectComponent().setResultColumns(resultColumns);
        }
        if (queryStatement.getWhereCondition() != null) {
            ExpressionAnalyzer.constructPatternTreeFromExpression(queryStatement.getWhereCondition().getPredicate(), prefixPaths, patternTree);
        }
        if (queryStatement.getHavingCondition() != null) {
            ExpressionAnalyzer.constructPatternTreeFromExpression(queryStatement.getHavingCondition().getPredicate(), prefixPaths, patternTree);
        }
        return queryStatement;
    }

    private List<ResultColumn> concatSelectWithFrom(SelectComponent selectComponent, List<PartialPath> prefixPaths, boolean isGroupByLevel) throws StatementAnalyzeException {
        ArrayList<ResultColumn> resultColumns = new ArrayList<ResultColumn>();
        for (ResultColumn resultColumn : selectComponent.getResultColumns()) {
            boolean needAliasCheck = resultColumn.hasAlias() && !isGroupByLevel;
            List<Expression> resultExpressions = ExpressionAnalyzer.concatExpressionWithSuffixPaths(resultColumn.getExpression(), prefixPaths, this.patternTree);
            if (needAliasCheck && resultExpressions.size() > 1) {
                throw new SemanticException(String.format("alias '%s' can only be matched with one time series", resultColumn.getAlias()));
            }
            resultColumns.addAll(resultExpressions.stream().map(expression -> new ResultColumn((Expression)expression, resultColumn.getAlias(), resultColumn.getColumnType())).collect(Collectors.toList()));
        }
        return resultColumns;
    }
}

