/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.schemaregion;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.iotdb.common.rpc.thrift.TSchemaNode;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.metadata.LocalSchemaProcessor;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.mpp.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.sys.ActivateTemplateInClusterPlan;
import org.apache.iotdb.db.qp.physical.sys.ActivateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.AutoCreateDeviceMNodePlan;
import org.apache.iotdb.db.qp.physical.sys.CreateAlignedTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.SetTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.ShowDevicesPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.UnsetTemplatePlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.ShowDevicesResult;
import org.apache.iotdb.db.query.dataset.ShowTimeSeriesResult;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Pair;

public interface ISchemaRegion {
    public void init() throws MetadataException;

    public void clear();

    public void forceMlog();

    public SchemaRegionId getSchemaRegionId();

    public String getStorageGroupFullPath();

    public void deleteSchemaRegion() throws MetadataException;

    public boolean createSnapshot(File var1);

    public void loadSnapshot(File var1);

    public void createTimeseries(CreateTimeSeriesPlan var1, long var2) throws MetadataException;

    public void createAlignedTimeSeries(CreateAlignedTimeSeriesPlan var1) throws MetadataException;

    public Pair<Integer, Set<String>> deleteTimeseries(PartialPath var1, boolean var2) throws MetadataException;

    public void autoCreateDeviceMNode(AutoCreateDeviceMNodePlan var1) throws MetadataException;

    public boolean isPathExist(PartialPath var1) throws MetadataException;

    public int getAllTimeseriesCount(PartialPath var1, boolean var2) throws MetadataException;

    public int getAllTimeseriesCount(PartialPath var1, Map<Integer, Template> var2, boolean var3) throws MetadataException;

    public int getAllTimeseriesCount(PartialPath var1, boolean var2, String var3, String var4, boolean var5) throws MetadataException;

    public Map<PartialPath, Integer> getMeasurementCountGroupByLevel(PartialPath var1, int var2, boolean var3) throws MetadataException;

    public Map<PartialPath, Integer> getMeasurementCountGroupByLevel(PartialPath var1, int var2, boolean var3, String var4, String var5, boolean var6) throws MetadataException;

    public int getDevicesNum(PartialPath var1, boolean var2) throws MetadataException;

    public int getNodesCountInGivenLevel(PartialPath var1, int var2, boolean var3) throws MetadataException;

    public List<PartialPath> getNodesListInGivenLevel(PartialPath var1, int var2, boolean var3, LocalSchemaProcessor.StorageGroupFilter var4) throws MetadataException;

    public Set<TSchemaNode> getChildNodePathInNextLevel(PartialPath var1) throws MetadataException;

    public Set<String> getChildNodeNameInNextLevel(PartialPath var1) throws MetadataException;

    public Set<PartialPath> getBelongedDevices(PartialPath var1) throws MetadataException;

    public Set<PartialPath> getMatchedDevices(PartialPath var1, boolean var2) throws MetadataException;

    public Pair<List<ShowDevicesResult>, Integer> getMatchedDevices(ShowDevicesPlan var1) throws MetadataException;

    public List<MeasurementPath> getMeasurementPaths(PartialPath var1, boolean var2) throws MetadataException;

    public Pair<List<MeasurementPath>, Integer> getMeasurementPathsWithAlias(PartialPath var1, int var2, int var3, boolean var4) throws MetadataException;

    public List<MeasurementPath> fetchSchema(PartialPath var1, Map<Integer, Template> var2) throws MetadataException;

    public Pair<List<ShowTimeSeriesResult>, Integer> showTimeseries(ShowTimeSeriesPlan var1, QueryContext var2) throws MetadataException;

    public List<MeasurementPath> getAllMeasurementByDevicePath(PartialPath var1) throws PathNotExistException;

    public IMNode getDeviceNode(PartialPath var1) throws MetadataException;

    public IMeasurementMNode getMeasurementMNode(PartialPath var1) throws MetadataException;

    public void changeAlias(PartialPath var1, String var2) throws MetadataException, IOException;

    public void upsertTagsAndAttributes(String var1, Map<String, String> var2, Map<String, String> var3, PartialPath var4) throws MetadataException, IOException;

    public void addAttributes(Map<String, String> var1, PartialPath var2) throws MetadataException, IOException;

    public void addTags(Map<String, String> var1, PartialPath var2) throws MetadataException, IOException;

    public void dropTagsOrAttributes(Set<String> var1, PartialPath var2) throws MetadataException, IOException;

    public void setTagsOrAttributesValue(Map<String, String> var1, PartialPath var2) throws MetadataException, IOException;

    public void renameTagOrAttributeKey(String var1, String var2, PartialPath var3) throws MetadataException, IOException;

    public IMNode getSeriesSchemasAndReadLockDevice(InsertPlan var1) throws MetadataException, IOException;

    public DeviceSchemaInfo getDeviceSchemaInfoWithAutoCreate(PartialPath var1, String[] var2, Function<Integer, TSDataType> var3, boolean var4) throws MetadataException;

    public Set<String> getPathsSetTemplate(String var1) throws MetadataException;

    public Set<String> getPathsUsingTemplate(String var1) throws MetadataException;

    public boolean isTemplateAppendable(Template var1, List<String> var2) throws MetadataException;

    public void setSchemaTemplate(SetTemplatePlan var1) throws MetadataException;

    public void unsetSchemaTemplate(UnsetTemplatePlan var1) throws MetadataException;

    public void setUsingSchemaTemplate(ActivateTemplatePlan var1) throws MetadataException;

    public void activateSchemaTemplate(ActivateTemplateInClusterPlan var1, Template var2) throws MetadataException;

    public List<String> getPathsUsingTemplate(int var1) throws MetadataException;

    public IMNode getMNodeForTrigger(PartialPath var1) throws MetadataException;

    public void releaseMNodeAfterDropTrigger(IMNode var1) throws MetadataException;
}

