/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.path;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathType;
import org.apache.iotdb.db.metadata.path.AlignedPath;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.VectorMeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeasurementPath
extends PartialPath {
    private static final Logger logger = LoggerFactory.getLogger(MeasurementPath.class);
    private IMeasurementSchema measurementSchema;
    private boolean isUnderAlignedEntity = false;
    private String measurementAlias = "";

    public MeasurementPath() {
    }

    public MeasurementPath(String measurementPath) throws IllegalPathException {
        super(measurementPath);
    }

    public MeasurementPath(String measurementPath, TSDataType type) throws IllegalPathException {
        super(measurementPath);
        this.measurementSchema = new MeasurementSchema(this.getMeasurement(), type);
    }

    public MeasurementPath(PartialPath measurementPath, IMeasurementSchema measurementSchema) {
        this(measurementPath, measurementSchema, false);
    }

    public MeasurementPath(PartialPath measurementPath, IMeasurementSchema measurementSchema, boolean isUnderAlignedEntity) {
        super(measurementPath.getNodes());
        this.measurementSchema = measurementSchema;
        this.isUnderAlignedEntity = isUnderAlignedEntity;
    }

    public MeasurementPath(String device, String measurement, IMeasurementSchema measurementSchema) throws IllegalPathException {
        super(device, measurement);
        this.measurementSchema = measurementSchema;
    }

    public MeasurementPath(String[] nodes, MeasurementSchema schema) {
        super(nodes);
        this.measurementSchema = schema;
    }

    public IMeasurementSchema getMeasurementSchema() {
        return this.measurementSchema;
    }

    public TSDataType getSeriesType() {
        return this.getMeasurementSchema().getType();
    }

    public byte getSeriesTypeInByte() {
        return this.getMeasurementSchema().getTypeInByte();
    }

    public void setMeasurementSchema(IMeasurementSchema measurementSchema) {
        this.measurementSchema = measurementSchema;
    }

    public String getMeasurementAlias() {
        return this.measurementAlias;
    }

    public void setMeasurementAlias(String measurementAlias) {
        if (measurementAlias != null) {
            this.measurementAlias = measurementAlias;
        }
    }

    public void removeMeasurementAlias() {
        this.measurementAlias = null;
    }

    public boolean isMeasurementAliasExists() {
        return this.measurementAlias != null && !this.measurementAlias.isEmpty();
    }

    public String getFullPathWithAlias() {
        return this.getDevice() + '.' + this.measurementAlias;
    }

    public boolean isUnderAlignedEntity() {
        return this.isUnderAlignedEntity;
    }

    public void setUnderAlignedEntity(boolean underAlignedEntity) {
        this.isUnderAlignedEntity = underAlignedEntity;
    }

    public PartialPath copy() {
        MeasurementPath result = new MeasurementPath();
        result.nodes = this.nodes;
        result.fullPath = this.fullPath;
        result.device = this.device;
        result.measurementAlias = this.measurementAlias;
        result.measurementSchema = this.measurementSchema;
        result.isUnderAlignedEntity = this.isUnderAlignedEntity;
        return result;
    }

    public PartialPath transformToExactPath() {
        return this.isUnderAlignedEntity ? new AlignedPath(this) : this;
    }

    public MeasurementPath clone() {
        MeasurementPath newMeasurementPath = null;
        try {
            newMeasurementPath = new MeasurementPath(this.getDevice(), this.getMeasurement(), this.getMeasurementSchema());
            newMeasurementPath.setUnderAlignedEntity(this.isUnderAlignedEntity);
        }
        catch (IllegalPathException e) {
            logger.warn("path is illegal: {}", (Object)this.getFullPath(), (Object)e);
        }
        return newMeasurementPath;
    }

    public void serialize(ByteBuffer byteBuffer) {
        PathType.Measurement.serialize(byteBuffer);
        super.serializeWithoutType(byteBuffer);
        if (this.measurementSchema == null) {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
            if (this.measurementSchema instanceof MeasurementSchema) {
                ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
            } else if (this.measurementSchema instanceof VectorMeasurementSchema) {
                ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
            }
            this.measurementSchema.serializeTo(byteBuffer);
        }
        ReadWriteIOUtils.write((Boolean)this.isUnderAlignedEntity, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((String)this.measurementAlias, (ByteBuffer)byteBuffer);
    }

    public void serialize(DataOutputStream stream) throws IOException {
        PathType.Measurement.serialize(stream);
        super.serializeWithoutType(stream);
        if (this.measurementSchema == null) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            if (this.measurementSchema instanceof MeasurementSchema) {
                ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
            } else if (this.measurementSchema instanceof VectorMeasurementSchema) {
                ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            }
            this.measurementSchema.serializeTo((OutputStream)stream);
        }
        ReadWriteIOUtils.write((Boolean)this.isUnderAlignedEntity, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.measurementAlias, (OutputStream)stream);
    }

    public static MeasurementPath deserialize(ByteBuffer byteBuffer) {
        PartialPath partialPath = PartialPath.deserialize((ByteBuffer)byteBuffer);
        MeasurementPath measurementPath = new MeasurementPath();
        byte isNull = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
        if (isNull == 1) {
            byte type = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
            if (type == 0) {
                measurementPath.measurementSchema = MeasurementSchema.deserializeFrom((ByteBuffer)byteBuffer);
            } else if (type == 1) {
                measurementPath.measurementSchema = VectorMeasurementSchema.deserializeFrom((ByteBuffer)byteBuffer);
            }
        }
        measurementPath.isUnderAlignedEntity = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        measurementPath.measurementAlias = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        measurementPath.nodes = partialPath.getNodes();
        measurementPath.device = partialPath.getDevice();
        measurementPath.fullPath = partialPath.getFullPath();
        return measurementPath;
    }

    public PartialPath transformToPartialPath() {
        return this.getDevicePath().concatNode(this.getTailNode());
    }
}

