/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf;

import java.util.List;
import org.apache.iotdb.commons.exception.BadNodeUrlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBStopCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBStopCheck.class);

    public static IoTDBStopCheck getInstance() {
        return IoTDBStopCheckHolder.INSTANCE;
    }

    public void checkDuplicateIp(List<String> dataNodeIps) throws BadNodeUrlException {
        if (dataNodeIps == null || dataNodeIps.isEmpty()) {
            throw new BadNodeUrlException("Data Node ips is empty");
        }
        long realIpNumber = dataNodeIps.stream().distinct().count();
        if (realIpNumber != (long)dataNodeIps.size()) {
            throw new BadNodeUrlException("has replicate ips");
        }
    }

    public void checkIpInCluster(List<String> removedDataNodeIps, List<String> onlineDataNodeIps) throws BadNodeUrlException {
        if (removedDataNodeIps == null || removedDataNodeIps.isEmpty()) {
            throw new BadNodeUrlException("checked Data Node ips is empty");
        }
        if (onlineDataNodeIps == null || onlineDataNodeIps.isEmpty()) {
            throw new BadNodeUrlException("online Data Node ips is empty");
        }
        if (removedDataNodeIps.stream().anyMatch(ip -> !onlineDataNodeIps.contains(ip))) {
            throw new BadNodeUrlException("exist Data Node not in cluster");
        }
    }

    private static class IoTDBStopCheckHolder {
        private static final IoTDBStopCheck INSTANCE = new IoTDBStopCheck();

        private IoTDBStopCheckHolder() {
        }
    }
}

