/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.server;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.ratis.grpc.GrpcUtil;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.proto.grpc.RaftServerProtocolServiceGrpc;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.protocol.RaftServerProtocol;
import org.apache.ratis.server.util.ServerStringUtils;
import org.apache.ratis.thirdparty.io.grpc.Status;
import org.apache.ratis.thirdparty.io.grpc.StatusRuntimeException;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.apache.ratis.util.ProtoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GrpcServerProtocolService
extends RaftServerProtocolServiceGrpc.RaftServerProtocolServiceImplBase {
    public static final Logger LOG = LoggerFactory.getLogger(GrpcServerProtocolService.class);
    private final Supplier<RaftPeerId> idSupplier;
    private final RaftServer server;

    GrpcServerProtocolService(Supplier<RaftPeerId> idSupplier, RaftServer server) {
        this.idSupplier = idSupplier;
        this.server = server;
    }

    RaftPeerId getId() {
        return this.idSupplier.get();
    }

    public void requestVote(RaftProtos.RequestVoteRequestProto request, StreamObserver<RaftProtos.RequestVoteReplyProto> responseObserver) {
        try {
            RaftProtos.RequestVoteReplyProto reply = this.server.requestVote(request);
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            GrpcUtil.warn(LOG, () -> this.getId() + ": Failed requestVote " + ProtoUtils.toString((RaftProtos.RaftRpcRequestProto)request.getServerRequest()), e);
            responseObserver.onError((Throwable)GrpcUtil.wrapException(e));
        }
    }

    public void startLeaderElection(RaftProtos.StartLeaderElectionRequestProto request, StreamObserver<RaftProtos.StartLeaderElectionReplyProto> responseObserver) {
        try {
            RaftProtos.StartLeaderElectionReplyProto reply = this.server.startLeaderElection(request);
            responseObserver.onNext((Object)reply);
            responseObserver.onCompleted();
        }
        catch (Throwable e) {
            GrpcUtil.warn(LOG, () -> this.getId() + ": Failed startLeaderElection " + ProtoUtils.toString((RaftProtos.RaftRpcRequestProto)request.getServerRequest()), e);
            responseObserver.onError((Throwable)GrpcUtil.wrapException(e));
        }
    }

    public StreamObserver<RaftProtos.AppendEntriesRequestProto> appendEntries(StreamObserver<RaftProtos.AppendEntriesReplyProto> responseObserver) {
        return new ServerRequestStreamObserver<RaftProtos.AppendEntriesRequestProto, RaftProtos.AppendEntriesReplyProto>(RaftServerProtocol.Op.APPEND_ENTRIES, responseObserver){

            @Override
            CompletableFuture<RaftProtos.AppendEntriesReplyProto> process(RaftProtos.AppendEntriesRequestProto request) throws IOException {
                return GrpcServerProtocolService.this.server.appendEntriesAsync(request);
            }

            @Override
            long getCallId(RaftProtos.AppendEntriesRequestProto request) {
                return request.getServerRequest().getCallId();
            }

            @Override
            String requestToString(RaftProtos.AppendEntriesRequestProto request) {
                return ServerStringUtils.toAppendEntriesRequestString((RaftProtos.AppendEntriesRequestProto)request);
            }

            @Override
            String replyToString(RaftProtos.AppendEntriesReplyProto reply) {
                return ServerStringUtils.toAppendEntriesReplyString((RaftProtos.AppendEntriesReplyProto)reply);
            }

            @Override
            boolean replyInOrder(RaftProtos.AppendEntriesRequestProto request) {
                return request.getEntriesCount() != 0;
            }

            @Override
            StatusRuntimeException wrapException(Throwable e, RaftProtos.AppendEntriesRequestProto request) {
                return GrpcUtil.wrapException(e, this.getCallId(request), request.getEntriesCount() == 0);
            }
        };
    }

    public StreamObserver<RaftProtos.InstallSnapshotRequestProto> installSnapshot(StreamObserver<RaftProtos.InstallSnapshotReplyProto> responseObserver) {
        return new ServerRequestStreamObserver<RaftProtos.InstallSnapshotRequestProto, RaftProtos.InstallSnapshotReplyProto>(RaftServerProtocol.Op.INSTALL_SNAPSHOT, responseObserver){

            @Override
            CompletableFuture<RaftProtos.InstallSnapshotReplyProto> process(RaftProtos.InstallSnapshotRequestProto request) throws IOException {
                return CompletableFuture.completedFuture(GrpcServerProtocolService.this.server.installSnapshot(request));
            }

            @Override
            long getCallId(RaftProtos.InstallSnapshotRequestProto request) {
                return request.getServerRequest().getCallId();
            }

            @Override
            String requestToString(RaftProtos.InstallSnapshotRequestProto request) {
                return ServerStringUtils.toInstallSnapshotRequestString((RaftProtos.InstallSnapshotRequestProto)request);
            }

            @Override
            String replyToString(RaftProtos.InstallSnapshotReplyProto reply) {
                return ServerStringUtils.toInstallSnapshotReplyString((RaftProtos.InstallSnapshotReplyProto)reply);
            }

            @Override
            boolean replyInOrder(RaftProtos.InstallSnapshotRequestProto installSnapshotRequestProto) {
                return true;
            }
        };
    }

    abstract class ServerRequestStreamObserver<REQUEST, REPLY>
    implements StreamObserver<REQUEST> {
        private final RaftServerProtocol.Op op;
        private final StreamObserver<REPLY> responseObserver;
        private final AtomicReference<PendingServerRequest<REQUEST>> previousOnNext = new AtomicReference();
        private final AtomicBoolean isClosed = new AtomicBoolean(false);

        ServerRequestStreamObserver(RaftServerProtocol.Op op, StreamObserver<REPLY> responseObserver) {
            this.op = op;
            this.responseObserver = responseObserver;
        }

        private String getPreviousRequestString() {
            return Optional.ofNullable(this.previousOnNext.get()).map(PendingServerRequest::getRequest).map(this::requestToString).orElse(null);
        }

        abstract CompletableFuture<REPLY> process(REQUEST var1) throws IOException;

        abstract long getCallId(REQUEST var1);

        abstract String requestToString(REQUEST var1);

        abstract String replyToString(REPLY var1);

        abstract boolean replyInOrder(REQUEST var1);

        StatusRuntimeException wrapException(Throwable e, REQUEST request) {
            return GrpcUtil.wrapException(e, this.getCallId(request));
        }

        private void handleError(Throwable e, REQUEST request) {
            GrpcUtil.warn(LOG, () -> GrpcServerProtocolService.this.getId() + ": Failed " + this.op + " request " + this.requestToString(request), e);
            this.responseObserver.onError((Throwable)this.wrapException(e, request));
        }

        private synchronized void handleReply(REPLY reply) {
            if (!this.isClosed.get()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{}: reply {}", (Object)GrpcServerProtocolService.this.getId(), (Object)this.replyToString(reply));
                }
                this.responseObserver.onNext(reply);
            }
        }

        @SuppressFBWarnings(value={"NP_NULL_PARAM_DEREF"})
        public void onNext(REQUEST request) {
            if (!this.replyInOrder(request)) {
                try {
                    this.process(request).thenAccept(this::handleReply);
                }
                catch (Exception e) {
                    this.handleError(e, request);
                }
                return;
            }
            PendingServerRequest<REQUEST> current = new PendingServerRequest<REQUEST>(request);
            PendingServerRequest<REQUEST> previous = this.previousOnNext.getAndSet(current);
            CompletableFuture<Object> previousFuture = Optional.ofNullable(previous).map(PendingServerRequest::getFuture).orElse(CompletableFuture.completedFuture(null));
            try {
                this.process(request).thenCombine(previousFuture, (reply, v) -> {
                    this.handleReply(reply);
                    current.getFuture().complete(null);
                    return null;
                });
            }
            catch (Exception e) {
                this.handleError(e, request);
                current.getFuture().completeExceptionally(e);
            }
        }

        public void onCompleted() {
            if (this.isClosed.compareAndSet(false, true)) {
                LOG.info("{}: Completed {}, lastRequest: {}", new Object[]{GrpcServerProtocolService.this.getId(), this.op, this.getPreviousRequestString()});
                this.responseObserver.onCompleted();
            }
        }

        public void onError(Throwable t) {
            Status status;
            GrpcUtil.warn(LOG, () -> GrpcServerProtocolService.this.getId() + ": installSnapshot onError, lastRequest: " + this.getPreviousRequestString(), t);
            if (this.isClosed.compareAndSet(false, true) && (status = Status.fromThrowable((Throwable)t)) != null && status.getCode() != Status.Code.CANCELLED) {
                this.responseObserver.onCompleted();
            }
        }
    }

    static class PendingServerRequest<REQUEST> {
        private final REQUEST request;
        private final CompletableFuture<Void> future = new CompletableFuture();

        PendingServerRequest(REQUEST request) {
            this.request = request;
        }

        REQUEST getRequest() {
            return this.request;
        }

        CompletableFuture<Void> getFuture() {
            return this.future;
        }
    }
}

