/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.partition;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TRegionInfo;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.cluster.RegionStatus;
import org.apache.iotdb.commons.partition.DataPartitionTable;
import org.apache.iotdb.commons.partition.SchemaPartitionTable;
import org.apache.iotdb.confignode.consensus.request.read.GetRegionInfoListReq;
import org.apache.iotdb.confignode.persistence.partition.RegionGroup;
import org.apache.iotdb.db.service.metrics.MetricsService;
import org.apache.iotdb.db.service.metrics.enums.Metric;
import org.apache.iotdb.db.service.metrics.enums.Tag;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;

public class StorageGroupPartitionTable {
    private volatile boolean isPredeleted = false;
    private String storageGroupName;
    private final AtomicInteger seriesPartitionSlotsCount;
    private final AtomicBoolean schemaRegionParticle;
    private final AtomicBoolean dataRegionParticle;
    private final Map<TConsensusGroupId, RegionGroup> regionInfoMap;
    private final SchemaPartitionTable schemaPartitionTable;
    private final DataPartitionTable dataPartitionTable;

    public StorageGroupPartitionTable(String storageGroupName) {
        this.storageGroupName = storageGroupName;
        this.seriesPartitionSlotsCount = new AtomicInteger(0);
        this.schemaRegionParticle = new AtomicBoolean(true);
        this.dataRegionParticle = new AtomicBoolean(true);
        this.regionInfoMap = new ConcurrentHashMap<TConsensusGroupId, RegionGroup>();
        this.schemaPartitionTable = new SchemaPartitionTable();
        this.dataPartitionTable = new DataPartitionTable();
        this.addMetrics();
    }

    private void addMetrics() {
        if (MetricConfigDescriptor.getInstance().getMetricConfig().getEnableMetric().booleanValue()) {
            MetricsService.getInstance().getMetricManager().getOrCreateAutoGauge(Metric.REGION.toString(), MetricLevel.NORMAL, (Object)this, o -> o.getRegionCount(TConsensusGroupType.SchemaRegion), new String[]{Tag.NAME.toString(), this.storageGroupName, Tag.TYPE.toString(), TConsensusGroupType.SchemaRegion.toString()});
            MetricsService.getInstance().getMetricManager().getOrCreateAutoGauge(Metric.REGION.toString(), MetricLevel.NORMAL, (Object)this, o -> o.getRegionCount(TConsensusGroupType.DataRegion), new String[]{Tag.NAME.toString(), this.storageGroupName, Tag.TYPE.toString(), TConsensusGroupType.DataRegion.toString()});
            MetricsService.getInstance().getMetricManager().getOrCreateAutoGauge(Metric.SLOT.toString(), MetricLevel.NORMAL, (Object)this.schemaPartitionTable, o -> o.getSchemaPartitionMap().size(), new String[]{Tag.NAME.toString(), this.storageGroupName, Tag.TYPE.toString(), "schemaSlotNumber"});
            MetricsService.getInstance().getMetricManager().getOrCreateAutoGauge(Metric.SLOT.toString(), MetricLevel.NORMAL, (Object)this.dataPartitionTable, o -> o.getDataPartitionMap().size(), new String[]{Tag.NAME.toString(), this.storageGroupName, Tag.TYPE.toString(), "dataSlotNumber"});
        }
    }

    public boolean isPredeleted() {
        return this.isPredeleted;
    }

    public void setPredeleted(boolean predeleted) {
        this.isPredeleted = predeleted;
    }

    public void createRegionGroups(List<TRegionReplicaSet> replicaSets) {
        replicaSets.forEach(replicaSet -> this.regionInfoMap.put(replicaSet.getRegionId(), new RegionGroup((TRegionReplicaSet)replicaSet)));
    }

    public List<TRegionReplicaSet> getAllReplicaSets() {
        ArrayList<TRegionReplicaSet> result = new ArrayList<TRegionReplicaSet>();
        for (RegionGroup regionGroup : this.regionInfoMap.values()) {
            result.add(regionGroup.getReplicaSet());
        }
        return result;
    }

    public Set<RegionGroup> getRegion(TConsensusGroupType type) {
        HashSet<RegionGroup> regionGroups = new HashSet<RegionGroup>();
        this.regionInfoMap.values().forEach(regionGroup -> {
            if (regionGroup.getId().getType().equals((Object)type)) {
                regionGroups.add((RegionGroup)regionGroup);
            }
        });
        return regionGroups;
    }

    public int getRegionCount(TConsensusGroupType type) {
        AtomicInteger result = new AtomicInteger(0);
        this.regionInfoMap.values().forEach(regionGroup -> {
            if (regionGroup.getId().getType().equals((Object)type)) {
                result.getAndIncrement();
            }
        });
        return result.getAndIncrement();
    }

    public boolean contendRegionAllocationParticle(TConsensusGroupType type) {
        switch (type) {
            case SchemaRegion: {
                return this.schemaRegionParticle.getAndSet(false);
            }
            case DataRegion: {
                return this.dataRegionParticle.getAndSet(false);
            }
        }
        return false;
    }

    public void putBackRegionAllocationParticle(TConsensusGroupType type) {
        switch (type) {
            case SchemaRegion: {
                this.schemaRegionParticle.set(true);
            }
            case DataRegion: {
                this.dataRegionParticle.set(true);
            }
        }
    }

    public boolean getRegionAllocationParticle(TConsensusGroupType type) {
        switch (type) {
            case SchemaRegion: {
                return this.schemaRegionParticle.get();
            }
            case DataRegion: {
                return this.dataRegionParticle.get();
            }
        }
        return false;
    }

    public int getSlotsCount() {
        return this.seriesPartitionSlotsCount.get();
    }

    public boolean getSchemaPartition(List<TSeriesPartitionSlot> partitionSlots, SchemaPartitionTable schemaPartition) {
        return this.schemaPartitionTable.getSchemaPartition(partitionSlots, schemaPartition);
    }

    public boolean getDataPartition(Map<TSeriesPartitionSlot, List<TTimePartitionSlot>> partitionSlots, DataPartitionTable dataPartition) {
        return this.dataPartitionTable.getDataPartition(partitionSlots, dataPartition);
    }

    public void createSchemaPartition(SchemaPartitionTable assignedSchemaPartition) {
        Map deltaMap = this.schemaPartitionTable.createSchemaPartition(assignedSchemaPartition);
        AtomicInteger total = new AtomicInteger(0);
        deltaMap.forEach((consensusGroupId, delta) -> {
            total.getAndAdd(delta.get());
            this.regionInfoMap.get(consensusGroupId).addCounter(delta.get());
        });
        this.seriesPartitionSlotsCount.getAndAdd(total.get());
    }

    public void createDataPartition(DataPartitionTable assignedDataPartition) {
        Map deltaMap = this.dataPartitionTable.createDataPartition(assignedDataPartition);
        AtomicInteger total = new AtomicInteger(0);
        deltaMap.forEach((consensusGroupId, delta) -> {
            total.getAndAdd(delta.get());
            this.regionInfoMap.get(consensusGroupId).addCounter(delta.get());
        });
    }

    public List<TSeriesPartitionSlot> filterUnassignedSchemaPartitionSlots(List<TSeriesPartitionSlot> partitionSlots) {
        return this.schemaPartitionTable.filterUnassignedSchemaPartitionSlots(partitionSlots);
    }

    public Map<TSeriesPartitionSlot, List<TTimePartitionSlot>> filterUnassignedDataPartitionSlots(Map<TSeriesPartitionSlot, List<TTimePartitionSlot>> partitionSlots) {
        return this.dataPartitionTable.filterUnassignedDataPartitionSlots(partitionSlots);
    }

    public List<Pair<Long, TConsensusGroupId>> getSortedRegionSlotsCounter(TConsensusGroupType type) {
        Vector<Pair<Long, TConsensusGroupId>> result = new Vector<Pair<Long, TConsensusGroupId>>();
        this.regionInfoMap.forEach((consensusGroupId, regionGroup) -> {
            if (consensusGroupId.getType().equals((Object)type)) {
                result.add(new Pair((Object)regionGroup.getCounter(), consensusGroupId));
            }
        });
        result.sort(Comparator.comparingLong(Pair::getLeft));
        return result;
    }

    public void getRegionInfoList(GetRegionInfoListReq regionsInfoReq, List<TRegionInfo> regionInfoList) {
        this.regionInfoMap.forEach((consensusGroupId, regionGroup) -> {
            TRegionReplicaSet replicaSet = regionGroup.getReplicaSet();
            if (regionsInfoReq.getRegionType() == null) {
                this.buildTRegionsInfo(regionInfoList, replicaSet, (RegionGroup)regionGroup);
            } else if (regionsInfoReq.getRegionType().ordinal() == replicaSet.getRegionId().getType().ordinal()) {
                this.buildTRegionsInfo(regionInfoList, replicaSet, (RegionGroup)regionGroup);
            }
        });
    }

    private void buildTRegionsInfo(List<TRegionInfo> regionInfoList, TRegionReplicaSet replicaSet, RegionGroup regionGroup) {
        replicaSet.getDataNodeLocations().forEach(dataNodeLocation -> {
            TRegionInfo tRegionInfoList = new TRegionInfo();
            tRegionInfoList.setConsensusGroupId(replicaSet.getRegionId());
            tRegionInfoList.setStorageGroup(this.storageGroupName);
            long slots = regionGroup.getCounter();
            tRegionInfoList.setSlots((long)((int)slots));
            tRegionInfoList.setDataNodeId(dataNodeLocation.getDataNodeId());
            tRegionInfoList.setClientRpcIp(dataNodeLocation.getClientRpcEndPoint().getIp());
            tRegionInfoList.setClientRpcPort(dataNodeLocation.getClientRpcEndPoint().getPort());
            tRegionInfoList.setStatus(RegionStatus.Up.getStatus());
            regionInfoList.add(tRegionInfoList);
        });
    }

    public void serialize(OutputStream outputStream, TProtocol protocol) throws IOException, TException {
        ReadWriteIOUtils.write((Boolean)this.isPredeleted, (OutputStream)outputStream);
        ReadWriteIOUtils.write((String)this.storageGroupName, (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)this.seriesPartitionSlotsCount.get(), (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)this.regionInfoMap.size(), (OutputStream)outputStream);
        for (Map.Entry<TConsensusGroupId, RegionGroup> regionInfoEntry : this.regionInfoMap.entrySet()) {
            regionInfoEntry.getKey().write(protocol);
            regionInfoEntry.getValue().serialize(outputStream, protocol);
        }
        this.schemaPartitionTable.serialize(outputStream, protocol);
        this.dataPartitionTable.serialize(outputStream, protocol);
    }

    public void deserialize(InputStream inputStream, TProtocol protocol) throws IOException, TException {
        this.isPredeleted = ReadWriteIOUtils.readBool((InputStream)inputStream);
        this.storageGroupName = ReadWriteIOUtils.readString((InputStream)inputStream);
        this.seriesPartitionSlotsCount.set(ReadWriteIOUtils.readInt((InputStream)inputStream));
        int length = ReadWriteIOUtils.readInt((InputStream)inputStream);
        for (int i = 0; i < length; ++i) {
            TConsensusGroupId consensusGroupId = new TConsensusGroupId();
            consensusGroupId.read(protocol);
            RegionGroup regionGroup = new RegionGroup();
            regionGroup.deserialize(inputStream, protocol);
            this.regionInfoMap.put(consensusGroupId, regionGroup);
        }
        this.schemaPartitionTable.deserialize(inputStream, protocol);
        this.dataPartitionTable.deserialize(inputStream, protocol);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StorageGroupPartitionTable that = (StorageGroupPartitionTable)o;
        return this.isPredeleted == that.isPredeleted && this.regionInfoMap.equals(that.regionInfoMap) && this.schemaPartitionTable.equals((Object)that.schemaPartitionTable) && this.dataPartitionTable.equals((Object)that.dataPartitionTable);
    }

    public int hashCode() {
        return Objects.hash(this.isPredeleted, this.regionInfoMap, this.schemaPartitionTable, this.dataPartitionTable);
    }
}

