/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.confignode.consensus.request.read.CountStorageGroupReq;
import org.apache.iotdb.confignode.consensus.request.read.GetStorageGroupReq;
import org.apache.iotdb.confignode.consensus.request.write.AdjustMaxRegionGroupCountReq;
import org.apache.iotdb.confignode.consensus.request.write.DeleteStorageGroupReq;
import org.apache.iotdb.confignode.consensus.request.write.SetDataReplicationFactorReq;
import org.apache.iotdb.confignode.consensus.request.write.SetSchemaReplicationFactorReq;
import org.apache.iotdb.confignode.consensus.request.write.SetStorageGroupReq;
import org.apache.iotdb.confignode.consensus.request.write.SetTTLReq;
import org.apache.iotdb.confignode.consensus.request.write.SetTimePartitionIntervalReq;
import org.apache.iotdb.confignode.consensus.response.CountStorageGroupResp;
import org.apache.iotdb.confignode.consensus.response.StorageGroupSchemaResp;
import org.apache.iotdb.confignode.exception.StorageGroupNotExistsException;
import org.apache.iotdb.confignode.rpc.thrift.TStorageGroupSchema;
import org.apache.iotdb.db.metadata.mtree.MTreeAboveSG;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterSchemaInfo
implements SnapshotProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterSchemaInfo.class);
    private final ReentrantReadWriteLock storageGroupReadWriteLock = new ReentrantReadWriteLock();
    private final MTreeAboveSG mTree;
    private final String snapshotFileName = "cluster_schema.bin";

    public ClusterSchemaInfo() throws IOException {
        try {
            this.mTree = new MTreeAboveSG();
        }
        catch (MetadataException e) {
            LOGGER.error("Can't construct StorageGroupInfo", (Throwable)e);
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus setStorageGroup(SetStorageGroupReq req) {
        TSStatus result = new TSStatus();
        this.storageGroupReadWriteLock.writeLock().lock();
        try {
            TStorageGroupSchema storageGroupSchema = req.getSchema();
            PartialPath partialPathName = new PartialPath(storageGroupSchema.getName());
            this.mTree.setStorageGroup(partialPathName);
            this.mTree.getStorageGroupNodeByStorageGroupPath(partialPathName).setStorageGroupSchema(storageGroupSchema);
            result.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (MetadataException e) {
            LOGGER.error("Error StorageGroup name", (Throwable)e);
            result.setCode(e.getErrorCode()).setMessage(e.getMessage());
        }
        finally {
            this.storageGroupReadWriteLock.writeLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus deleteStorageGroup(DeleteStorageGroupReq req) {
        TSStatus result = new TSStatus();
        this.storageGroupReadWriteLock.writeLock().lock();
        try {
            String storageGroup = req.getName();
            PartialPath partialPathName = new PartialPath(storageGroup);
            this.mTree.deleteStorageGroup(partialPathName);
            result.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (MetadataException e) {
            LOGGER.warn("Storage group not exist", (Throwable)e);
            result.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode()).setMessage("Storage group not exist");
        }
        finally {
            this.storageGroupReadWriteLock.writeLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CountStorageGroupResp countMatchedStorageGroups(CountStorageGroupReq req) {
        CountStorageGroupResp result = new CountStorageGroupResp();
        this.storageGroupReadWriteLock.readLock().lock();
        try {
            PartialPath patternPath = new PartialPath(req.getStorageGroupPattern());
            result.setCount(this.mTree.getBelongedStorageGroups(patternPath).size());
            result.setStatus(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()));
        }
        catch (MetadataException e) {
            LOGGER.error("Error StorageGroup name", (Throwable)e);
            result.setStatus(new TSStatus(TSStatusCode.STORAGE_GROUP_NOT_EXIST.getStatusCode()).setMessage("Error StorageGroup name"));
        }
        finally {
            this.storageGroupReadWriteLock.readLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StorageGroupSchemaResp getMatchedStorageGroupSchemas(GetStorageGroupReq req) {
        StorageGroupSchemaResp result = new StorageGroupSchemaResp();
        this.storageGroupReadWriteLock.readLock().lock();
        try {
            HashMap<String, TStorageGroupSchema> schemaMap = new HashMap<String, TStorageGroupSchema>();
            PartialPath patternPath = new PartialPath(req.getStorageGroupPattern());
            List matchedPaths = this.mTree.getBelongedStorageGroups(patternPath);
            for (PartialPath path : matchedPaths) {
                schemaMap.put(path.getFullPath(), this.mTree.getStorageGroupNodeByStorageGroupPath(path).getStorageGroupSchema());
            }
            result.setSchemaMap(schemaMap);
            result.setStatus(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()));
        }
        catch (MetadataException e) {
            LOGGER.error("Error StorageGroup name", (Throwable)e);
            result.setStatus(new TSStatus(TSStatusCode.STORAGE_GROUP_NOT_EXIST.getStatusCode()).setMessage("Error StorageGroup name"));
        }
        finally {
            this.storageGroupReadWriteLock.readLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus setTTL(SetTTLReq req) {
        TSStatus result = new TSStatus();
        this.storageGroupReadWriteLock.writeLock().lock();
        try {
            PartialPath path = new PartialPath(req.getStorageGroup());
            if (this.mTree.isStorageGroupAlreadySet(path)) {
                this.mTree.getStorageGroupNodeByStorageGroupPath(path).getStorageGroupSchema().setTTL(req.getTTL());
                result.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            } else {
                result.setCode(TSStatusCode.STORAGE_GROUP_NOT_EXIST.getStatusCode());
                result.setMessage("StorageGroup does not exist");
            }
        }
        catch (MetadataException e) {
            LOGGER.error("Error StorageGroup name", (Throwable)e);
            result.setCode(TSStatusCode.STORAGE_GROUP_NOT_EXIST.getStatusCode()).setMessage("Error StorageGroupName");
        }
        finally {
            this.storageGroupReadWriteLock.writeLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus setSchemaReplicationFactor(SetSchemaReplicationFactorReq req) {
        TSStatus result = new TSStatus();
        this.storageGroupReadWriteLock.writeLock().lock();
        try {
            PartialPath path = new PartialPath(req.getStorageGroup());
            if (this.mTree.isStorageGroupAlreadySet(path)) {
                this.mTree.getStorageGroupNodeByStorageGroupPath(path).getStorageGroupSchema().setSchemaReplicationFactor(req.getSchemaReplicationFactor());
                result.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            } else {
                result.setCode(TSStatusCode.STORAGE_GROUP_NOT_EXIST.getStatusCode());
            }
        }
        catch (MetadataException e) {
            LOGGER.error("Error StorageGroup name", (Throwable)e);
            result.setCode(TSStatusCode.STORAGE_GROUP_NOT_EXIST.getStatusCode()).setMessage("Error StorageGroupName");
        }
        finally {
            this.storageGroupReadWriteLock.writeLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus setDataReplicationFactor(SetDataReplicationFactorReq req) {
        TSStatus result = new TSStatus();
        this.storageGroupReadWriteLock.writeLock().lock();
        try {
            PartialPath path = new PartialPath(req.getStorageGroup());
            if (this.mTree.isStorageGroupAlreadySet(path)) {
                this.mTree.getStorageGroupNodeByStorageGroupPath(path).getStorageGroupSchema().setDataReplicationFactor(req.getDataReplicationFactor());
                result.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            } else {
                result.setCode(TSStatusCode.STORAGE_GROUP_NOT_EXIST.getStatusCode());
            }
        }
        catch (MetadataException e) {
            LOGGER.error("Error StorageGroup name", (Throwable)e);
            result.setCode(TSStatusCode.STORAGE_GROUP_NOT_EXIST.getStatusCode()).setMessage("Error StorageGroupName");
        }
        finally {
            this.storageGroupReadWriteLock.writeLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus setTimePartitionInterval(SetTimePartitionIntervalReq req) {
        TSStatus result = new TSStatus();
        this.storageGroupReadWriteLock.writeLock().lock();
        try {
            PartialPath path = new PartialPath(req.getStorageGroup());
            if (this.mTree.isStorageGroupAlreadySet(path)) {
                this.mTree.getStorageGroupNodeByStorageGroupPath(path).getStorageGroupSchema().setTimePartitionInterval(req.getTimePartitionInterval());
                result.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
            } else {
                result.setCode(TSStatusCode.STORAGE_GROUP_NOT_EXIST.getStatusCode());
            }
        }
        catch (MetadataException e) {
            LOGGER.error("Error StorageGroup name", (Throwable)e);
            result.setCode(TSStatusCode.STORAGE_GROUP_NOT_EXIST.getStatusCode()).setMessage("Error StorageGroupName");
        }
        finally {
            this.storageGroupReadWriteLock.writeLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus adjustMaxRegionGroupCount(AdjustMaxRegionGroupCountReq req) {
        TSStatus result = new TSStatus();
        this.storageGroupReadWriteLock.writeLock().lock();
        try {
            for (Map.Entry<String, Pair<Integer, Integer>> entry : req.getMaxRegionGroupCountMap().entrySet()) {
                PartialPath path = new PartialPath(entry.getKey());
                TStorageGroupSchema storageGroupSchema = this.mTree.getStorageGroupNodeByStorageGroupPath(path).getStorageGroupSchema();
                storageGroupSchema.setMaxSchemaRegionGroupCount(((Integer)entry.getValue().getLeft()).intValue());
                storageGroupSchema.setMaxDataRegionGroupCount(((Integer)entry.getValue().getRight()).intValue());
            }
            result.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (MetadataException e) {
            LOGGER.error("Error StorageGroup name", (Throwable)e);
            result.setCode(TSStatusCode.STORAGE_GROUP_NOT_EXIST.getStatusCode());
        }
        finally {
            this.storageGroupReadWriteLock.writeLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getStorageGroupNames() {
        ArrayList<String> storageGroups = new ArrayList<String>();
        this.storageGroupReadWriteLock.readLock().lock();
        try {
            List namePaths = this.mTree.getAllStorageGroupPaths();
            for (PartialPath path : namePaths) {
                storageGroups.add(path.getFullPath());
            }
        }
        finally {
            this.storageGroupReadWriteLock.readLock().unlock();
        }
        return storageGroups;
    }

    public void checkContainsStorageGroup(String storageName) throws MetadataException {
        this.storageGroupReadWriteLock.readLock().lock();
        try {
            this.mTree.checkStorageGroupAlreadySet(new PartialPath(storageName));
        }
        finally {
            this.storageGroupReadWriteLock.readLock().unlock();
        }
    }

    public TStorageGroupSchema getMatchedStorageGroupSchemaByName(String storageGroup) throws StorageGroupNotExistsException {
        this.storageGroupReadWriteLock.readLock().lock();
        try {
            TStorageGroupSchema tStorageGroupSchema = this.mTree.getStorageGroupNodeByStorageGroupPath(new PartialPath(storageGroup)).getStorageGroupSchema();
            return tStorageGroupSchema;
        }
        catch (MetadataException e) {
            throw new StorageGroupNotExistsException(storageGroup);
        }
        finally {
            this.storageGroupReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, TStorageGroupSchema> getMatchedStorageGroupSchemasByName(List<String> rawPathList) {
        HashMap<String, TStorageGroupSchema> schemaMap = new HashMap<String, TStorageGroupSchema>();
        this.storageGroupReadWriteLock.readLock().lock();
        try {
            for (String rawPath : rawPathList) {
                PartialPath patternPath = new PartialPath(rawPath);
                List matchedPaths = this.mTree.getBelongedStorageGroups(patternPath);
                for (PartialPath path : matchedPaths) {
                    schemaMap.put(path.getFullPath(), this.mTree.getStorageGroupNodeByPath(path).getStorageGroupSchema());
                }
            }
        }
        catch (MetadataException e) {
            LOGGER.warn("Error StorageGroup name", (Throwable)e);
        }
        finally {
            this.storageGroupReadWriteLock.readLock().unlock();
        }
        return schemaMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxRegionGroupCount(String storageGroup, TConsensusGroupType consensusGroupType) {
        this.storageGroupReadWriteLock.readLock().lock();
        try {
            PartialPath path = new PartialPath(storageGroup);
            TStorageGroupSchema storageGroupSchema = this.mTree.getStorageGroupNodeByStorageGroupPath(path).getStorageGroupSchema();
            switch (consensusGroupType) {
                case SchemaRegion: {
                    int n = storageGroupSchema.getMaxSchemaRegionGroupCount();
                    return n;
                }
            }
            int n = storageGroupSchema.getMaxDataRegionGroupCount();
            return n;
        }
        catch (MetadataException e) {
            LOGGER.warn("Error StorageGroup name", (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            this.storageGroupReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processTakeSnapshot(File snapshotDir) throws IOException {
        File snapshotFile = new File(snapshotDir, "cluster_schema.bin");
        if (snapshotFile.exists() && snapshotFile.isFile()) {
            LOGGER.error("Failed to take snapshot, because snapshot file [{}] is already exist.", (Object)snapshotFile.getAbsolutePath());
            return false;
        }
        File tmpFile = new File(snapshotFile.getAbsolutePath() + "-" + UUID.randomUUID());
        this.storageGroupReadWriteLock.readLock().lock();
        try {
            try (FileOutputStream fileOutputStream = new FileOutputStream(tmpFile);
                 BufferedOutputStream outputStream = new BufferedOutputStream(fileOutputStream);){
                this.mTree.serialize((OutputStream)outputStream);
                outputStream.flush();
            }
            boolean bl = tmpFile.renameTo(snapshotFile);
            return bl;
        }
        finally {
            for (int retry = 0; retry < 5 && tmpFile.exists() && !tmpFile.delete(); ++retry) {
                LOGGER.warn("Can't delete temporary snapshot file: {}, retrying...", (Object)tmpFile.getAbsolutePath());
            }
            this.storageGroupReadWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processLoadSnapshot(File snapshotDir) throws IOException {
        File snapshotFile = new File(snapshotDir, "cluster_schema.bin");
        if (!snapshotFile.exists() || !snapshotFile.isFile()) {
            LOGGER.error("Failed to load snapshot,snapshot file [{}] is not exist.", (Object)snapshotFile.getAbsolutePath());
            return;
        }
        this.storageGroupReadWriteLock.writeLock().lock();
        try (FileInputStream fileInputStream = new FileInputStream(snapshotFile);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
            this.mTree.clear();
            this.mTree.deserialize((InputStream)bufferedInputStream);
        }
        finally {
            this.storageGroupReadWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<List<PartialPath>, Set<PartialPath>> getNodesListInGivenLevel(PartialPath partialPath, int level) {
        Pair matchedPathsInNextLevel = new Pair(new HashSet(), new HashSet());
        this.storageGroupReadWriteLock.readLock().lock();
        try {
            matchedPathsInNextLevel = this.mTree.getNodesListInGivenLevel(partialPath, level, true, null);
        }
        catch (MetadataException e) {
            LOGGER.error("Error get matched paths in given level.", (Throwable)e);
        }
        finally {
            this.storageGroupReadWriteLock.readLock().unlock();
        }
        return matchedPathsInNextLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Set<String>, Set<PartialPath>> getChildNodePathInNextLevel(PartialPath partialPath) {
        Pair matchedPathsInNextLevel = new Pair(new HashSet(), new HashSet());
        this.storageGroupReadWriteLock.readLock().lock();
        try {
            matchedPathsInNextLevel = this.mTree.getChildNodePathInNextLevel(partialPath);
        }
        catch (MetadataException e) {
            LOGGER.error("Error get matched paths in next level.", (Throwable)e);
        }
        finally {
            this.storageGroupReadWriteLock.readLock().unlock();
        }
        return matchedPathsInNextLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Set<String>, Set<PartialPath>> getChildNodeNameInNextLevel(PartialPath partialPath) {
        Pair matchedNamesInNextLevel = new Pair(new HashSet(), new HashSet());
        this.storageGroupReadWriteLock.readLock().lock();
        try {
            matchedNamesInNextLevel = this.mTree.getChildNodeNameInNextLevel(partialPath);
        }
        catch (MetadataException e) {
            LOGGER.error("Error get matched names in next level.", (Throwable)e);
        }
        finally {
            this.storageGroupReadWriteLock.readLock().unlock();
        }
        return matchedNamesInNextLevel;
    }

    public void clear() {
        this.mTree.clear();
    }
}

