/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.commons.partition.DataPartitionTable;
import org.apache.iotdb.commons.partition.SchemaPartitionTable;
import org.apache.iotdb.commons.partition.executor.SeriesPartitionExecutor;
import org.apache.iotdb.confignode.client.SyncDataNodeClientPool;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.read.GetDataPartitionReq;
import org.apache.iotdb.confignode.consensus.request.read.GetNodePathsPartitionReq;
import org.apache.iotdb.confignode.consensus.request.read.GetOrCreateDataPartitionReq;
import org.apache.iotdb.confignode.consensus.request.read.GetOrCreateSchemaPartitionReq;
import org.apache.iotdb.confignode.consensus.request.read.GetRegionInfoListReq;
import org.apache.iotdb.confignode.consensus.request.read.GetSchemaPartitionReq;
import org.apache.iotdb.confignode.consensus.request.write.CreateDataPartitionReq;
import org.apache.iotdb.confignode.consensus.request.write.CreateSchemaPartitionReq;
import org.apache.iotdb.confignode.consensus.request.write.PreDeleteStorageGroupReq;
import org.apache.iotdb.confignode.consensus.response.DataPartitionResp;
import org.apache.iotdb.confignode.consensus.response.SchemaNodeManagementResp;
import org.apache.iotdb.confignode.consensus.response.SchemaPartitionResp;
import org.apache.iotdb.confignode.exception.NotEnoughDataNodeException;
import org.apache.iotdb.confignode.exception.StorageGroupNotExistsException;
import org.apache.iotdb.confignode.exception.TimeoutException;
import org.apache.iotdb.confignode.manager.ClusterSchemaManager;
import org.apache.iotdb.confignode.manager.ConsensusManager;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.NodeManager;
import org.apache.iotdb.confignode.manager.load.LoadManager;
import org.apache.iotdb.confignode.persistence.partition.PartitionInfo;
import org.apache.iotdb.confignode.rpc.thrift.TStorageGroupSchema;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.consensus.common.response.ConsensusReadResponse;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionManager.class);
    private final IManager configManager;
    private final PartitionInfo partitionInfo;
    private static final int REGION_CLEANER_WORK_INTERVAL = 300;
    private static final int REGION_CLEANER_WORK_INITIAL_DELAY = 10;
    private SeriesPartitionExecutor executor;
    private final ScheduledExecutorService regionCleaner;

    public PartitionManager(IManager configManager, PartitionInfo partitionInfo) {
        this.configManager = configManager;
        this.partitionInfo = partitionInfo;
        this.regionCleaner = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)"IoTDB-Region-Cleaner");
        ScheduledExecutorUtil.safelyScheduleAtFixedRate((ScheduledExecutorService)this.regionCleaner, this::clearDeletedRegions, (long)10L, (long)300L, (TimeUnit)TimeUnit.SECONDS);
        this.setSeriesPartitionExecutor();
    }

    private void setSeriesPartitionExecutor() {
        ConfigNodeConfig conf = ConfigNodeDescriptor.getInstance().getConf();
        this.executor = SeriesPartitionExecutor.getSeriesPartitionExecutor((String)conf.getSeriesPartitionExecutorClass(), (int)conf.getSeriesPartitionSlotNum());
    }

    public DataSet getSchemaPartition(GetSchemaPartitionReq req) {
        return this.getConsensusManager().read(req).getDataset();
    }

    public DataSet getDataPartition(GetDataPartitionReq req) {
        return this.getConsensusManager().read(req).getDataset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet getOrCreateSchemaPartition(GetOrCreateSchemaPartitionReq req) {
        SchemaPartitionResp resp = (SchemaPartitionResp)this.getSchemaPartition(req);
        if (resp.isAllPartitionsExist()) {
            return resp;
        }
        TSStatus status = this.initializeRegionsIfNecessary(new ArrayList<String>(req.getPartitionSlotsMap().keySet()), TConsensusGroupType.SchemaRegion);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            resp.setStatus(status);
            return resp;
        }
        PartitionManager partitionManager = this;
        synchronized (partitionManager) {
            Map<String, List<TSeriesPartitionSlot>> unassignedSchemaPartitionSlots = this.partitionInfo.filterUnassignedSchemaPartitionSlots(req.getPartitionSlotsMap());
            if (unassignedSchemaPartitionSlots.size() > 0) {
                Map<String, SchemaPartitionTable> assignedSchemaPartition = this.getLoadManager().allocateSchemaPartition(unassignedSchemaPartitionSlots);
                CreateSchemaPartitionReq createPlan = new CreateSchemaPartitionReq();
                createPlan.setAssignedSchemaPartition(assignedSchemaPartition);
                this.getConsensusManager().write(createPlan);
            }
        }
        this.extendRegionsIfNecessary(new ArrayList<String>(req.getPartitionSlotsMap().keySet()), TConsensusGroupType.SchemaRegion);
        return this.getSchemaPartition(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet getOrCreateDataPartition(GetOrCreateDataPartitionReq req) {
        DataPartitionResp resp = (DataPartitionResp)this.getDataPartition(req);
        if (resp.isAllPartitionsExist()) {
            return resp;
        }
        TSStatus status = this.initializeRegionsIfNecessary(new ArrayList<String>(req.getPartitionSlotsMap().keySet()), TConsensusGroupType.DataRegion);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            resp.setStatus(status);
            return resp;
        }
        PartitionManager partitionManager = this;
        synchronized (partitionManager) {
            Map<String, Map<TSeriesPartitionSlot, List<TTimePartitionSlot>>> unassignedDataPartitionSlots = this.partitionInfo.filterUnassignedDataPartitionSlots(req.getPartitionSlotsMap());
            if (unassignedDataPartitionSlots.size() > 0) {
                Map<String, DataPartitionTable> assignedDataPartition = this.getLoadManager().allocateDataPartition(unassignedDataPartitionSlots);
                CreateDataPartitionReq createPlan = new CreateDataPartitionReq();
                createPlan.setAssignedDataPartition(assignedDataPartition);
                this.getConsensusManager().write(createPlan);
            }
        }
        this.extendRegionsIfNecessary(new ArrayList<String>(req.getPartitionSlotsMap().keySet()), TConsensusGroupType.DataRegion);
        return this.getDataPartition(req);
    }

    private TSStatus initializeRegionsIfNecessary(List<String> storageGroups, TConsensusGroupType consensusGroupType) {
        try {
            this.initializeRegions(storageGroups, consensusGroupType);
        }
        catch (NotEnoughDataNodeException e) {
            return new TSStatus(TSStatusCode.NOT_ENOUGH_DATA_NODE.getStatusCode()).setMessage("ConfigNode failed to allocate Partition because there are not enough DataNodes");
        }
        catch (TimeoutException e) {
            return new TSStatus(TSStatusCode.TIME_OUT.getStatusCode()).setMessage("ConfigNode failed to allocate Partition because waiting for another thread's Region allocation timeout.");
        }
        catch (StorageGroupNotExistsException e) {
            return new TSStatus(TSStatusCode.STORAGE_GROUP_NOT_EXIST.getStatusCode()).setMessage("ConfigNode failed to allocate DataPartition because some StorageGroup doesn't exist.");
        }
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    private void initializeRegions(List<String> storageGroups, TConsensusGroupType consensusGroupType) throws NotEnoughDataNodeException, TimeoutException, StorageGroupNotExistsException {
        int leastDataNode = 0;
        HashMap<String, Integer> unreadyStorageGroupMap = new HashMap<String, Integer>();
        for (String storageGroup : storageGroups) {
            if (this.getRegionCount(storageGroup, consensusGroupType) != 0) continue;
            TStorageGroupSchema storageGroupSchema = this.getClusterSchemaManager().getStorageGroupSchemaByName(storageGroup);
            switch (consensusGroupType) {
                case SchemaRegion: {
                    leastDataNode = Math.max(leastDataNode, storageGroupSchema.getSchemaReplicationFactor());
                    break;
                }
                case DataRegion: {
                    leastDataNode = Math.max(leastDataNode, storageGroupSchema.getDataReplicationFactor());
                }
            }
            unreadyStorageGroupMap.put(storageGroup, 1);
        }
        if (this.getNodeManager().getOnlineDataNodeCount() < leastDataNode) {
            throw new NotEnoughDataNodeException();
        }
        this.doOrWaitRegionCreation(unreadyStorageGroupMap, consensusGroupType);
    }

    private void extendRegionsIfNecessary(List<String> storageGroups, TConsensusGroupType consensusGroupType) {
        try {
            this.extendRegions(storageGroups, consensusGroupType);
        }
        catch (NotEnoughDataNodeException e) {
            LOGGER.error("ConfigNode failed to extend Region because there are not enough DataNodes");
        }
        catch (TimeoutException e) {
            LOGGER.error("ConfigNode failed to extend Region because waiting for another thread's Region allocation timeout.");
        }
        catch (StorageGroupNotExistsException e) {
            LOGGER.error("ConfigNode failed to extend Region because some StorageGroup doesn't exist.");
        }
    }

    private void extendRegions(List<String> storageGroups, TConsensusGroupType consensusGroupType) throws StorageGroupNotExistsException, NotEnoughDataNodeException, TimeoutException {
        HashMap<String, Integer> filledStorageGroupMap = new HashMap<String, Integer>();
        for (String storageGroup : storageGroups) {
            float regionCount = this.partitionInfo.getRegionCount(storageGroup, consensusGroupType);
            float slotCount = this.partitionInfo.getSlotCount(storageGroup);
            float maxRegionCount = this.getClusterSchemaManager().getMaxRegionGroupCount(storageGroup, consensusGroupType);
            float maxSlotCount = ConfigNodeDescriptor.getInstance().getConf().getSeriesPartitionSlotNum();
            if (!(regionCount < maxRegionCount) || !(slotCount / regionCount > maxSlotCount / maxRegionCount)) continue;
            int delta = Math.min((int)(maxRegionCount - regionCount), Math.max(1, (int)Math.ceil(slotCount * maxRegionCount / maxSlotCount - regionCount)));
            filledStorageGroupMap.put(storageGroup, delta);
        }
        this.doOrWaitRegionCreation(filledStorageGroupMap, consensusGroupType);
    }

    private void doOrWaitRegionCreation(Map<String, Integer> allotmentMap, TConsensusGroupType consensusGroupType) throws NotEnoughDataNodeException, StorageGroupNotExistsException, TimeoutException {
        HashMap<String, Integer> allocateMap = new HashMap<String, Integer>();
        ArrayList<String> waitingList = new ArrayList<String>();
        for (String storageGroup : allotmentMap.keySet()) {
            if (this.partitionInfo.contendRegionAllocationParticle(storageGroup, consensusGroupType)) {
                allocateMap.put(storageGroup, allotmentMap.get(storageGroup));
                continue;
            }
            waitingList.add(storageGroup);
        }
        this.getLoadManager().doRegionCreation(allocateMap, consensusGroupType);
        for (String storageGroup : allocateMap.keySet()) {
            this.partitionInfo.putBackRegionAllocationParticle(storageGroup, consensusGroupType);
        }
        this.waitRegionCreation(waitingList, consensusGroupType);
    }

    private void waitRegionCreation(List<String> waitingList, TConsensusGroupType consensusGroupType) throws TimeoutException {
        for (int retry = 0; retry < 100; ++retry) {
            boolean allocationFinished = true;
            for (String storageGroup : waitingList) {
                if (this.partitionInfo.getRegionAllocationParticle(storageGroup, consensusGroupType)) continue;
                allocationFinished = false;
                break;
            }
            if (allocationFinished) {
                return;
            }
            try {
                TimeUnit.MILLISECONDS.sleep(200L);
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.warn("The PartitionManager is interrupted.", (Throwable)e);
            }
        }
        throw new TimeoutException("");
    }

    public List<TRegionReplicaSet> getAllReplicaSets() {
        return this.partitionInfo.getAllReplicaSets();
    }

    public int getRegionCount(String storageGroup, TConsensusGroupType type) throws StorageGroupNotExistsException {
        return this.partitionInfo.getRegionCount(storageGroup, type);
    }

    public List<Pair<Long, TConsensusGroupId>> getSortedRegionSlotsCounter(String storageGroup, TConsensusGroupType type) {
        return this.partitionInfo.getSortedRegionSlotsCounter(storageGroup, type);
    }

    public int generateNextRegionGroupId() {
        return this.partitionInfo.generateNextRegionGroupId();
    }

    public DataSet getNodePathsPartition(GetNodePathsPartitionReq physicalPlan) {
        ConsensusReadResponse consensusReadResponse = this.getConsensusManager().read(physicalPlan);
        SchemaNodeManagementResp schemaNodeManagementResp = (SchemaNodeManagementResp)consensusReadResponse.getDataset();
        return schemaNodeManagementResp;
    }

    public void preDeleteStorageGroup(String storageGroup, PreDeleteStorageGroupReq.PreDeleteType preDeleteType) {
        PreDeleteStorageGroupReq preDeleteStorageGroupReq = new PreDeleteStorageGroupReq(storageGroup, preDeleteType);
        this.getConsensusManager().write(preDeleteStorageGroupReq);
    }

    public void clearDeletedRegions() {
        Set<TRegionReplicaSet> deletedRegionSet;
        if (this.getConsensusManager().isLeader() && !(deletedRegionSet = this.partitionInfo.getDeletedRegionSet()).isEmpty()) {
            LOGGER.info("DELETE REGIONS {} START", deletedRegionSet.stream().map(TRegionReplicaSet::getRegionId).collect(Collectors.toList()));
            SyncDataNodeClientPool.getInstance().deleteRegions(deletedRegionSet);
        }
    }

    public void addMetrics() {
        this.partitionInfo.addMetrics();
    }

    public TSeriesPartitionSlot getSeriesPartitionSlot(String devicePath) {
        return this.executor.getSeriesPartitionSlot(devicePath);
    }

    public DataSet getRegionInfoList(GetRegionInfoListReq req) {
        return this.getConsensusManager().read(req).getDataset();
    }

    public ScheduledExecutorService getRegionCleaner() {
        return this.regionCleaner;
    }

    private ConsensusManager getConsensusManager() {
        return this.configManager.getConsensusManager();
    }

    private NodeManager getNodeManager() {
        return this.configManager.getNodeManager();
    }

    private ClusterSchemaManager getClusterSchemaManager() {
        return this.configManager.getClusterSchemaManager();
    }

    private LoadManager getLoadManager() {
        return this.configManager.getLoadManager();
    }
}

