/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TDataNodeInfo;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TFlushReq;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.confignode.client.AsyncDataNodeClientPool;
import org.apache.iotdb.confignode.client.handlers.FlushHandler;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.read.GetDataNodeInfoReq;
import org.apache.iotdb.confignode.consensus.request.write.ApplyConfigNodeReq;
import org.apache.iotdb.confignode.consensus.request.write.RegisterDataNodeReq;
import org.apache.iotdb.confignode.consensus.request.write.RemoveConfigNodeReq;
import org.apache.iotdb.confignode.consensus.response.DataNodeConfigurationResp;
import org.apache.iotdb.confignode.consensus.response.DataNodeInfosResp;
import org.apache.iotdb.confignode.manager.ClusterSchemaManager;
import org.apache.iotdb.confignode.manager.ConsensusManager;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.persistence.NodeInfo;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterReq;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterResp;
import org.apache.iotdb.confignode.rpc.thrift.TGlobalConfig;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.consensus.common.response.ConsensusGenericResponse;
import org.apache.iotdb.consensus.common.response.ConsensusWriteResponse;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeManager.class);
    private final IManager configManager;
    private final NodeInfo nodeInfo;
    private final ReentrantLock removeConfigNodeLock;
    private final List<ChangeServerListener> listeners = new CopyOnWriteArrayList<ChangeServerListener>();

    public NodeManager(IManager configManager, NodeInfo nodeInfo) {
        this.configManager = configManager;
        this.nodeInfo = nodeInfo;
        this.removeConfigNodeLock = new ReentrantLock();
    }

    private void setGlobalConfig(DataNodeConfigurationResp dataSet) {
        TGlobalConfig globalConfig = new TGlobalConfig();
        globalConfig.setDataRegionConsensusProtocolClass(ConfigNodeDescriptor.getInstance().getConf().getDataRegionConsensusProtocolClass());
        globalConfig.setSchemaRegionConsensusProtocolClass(ConfigNodeDescriptor.getInstance().getConf().getSchemaRegionConsensusProtocolClass());
        globalConfig.setSeriesPartitionSlotNum(ConfigNodeDescriptor.getInstance().getConf().getSeriesPartitionSlotNum());
        globalConfig.setSeriesPartitionExecutorClass(ConfigNodeDescriptor.getInstance().getConf().getSeriesPartitionExecutorClass());
        globalConfig.setTimePartitionInterval(ConfigNodeDescriptor.getInstance().getConf().getTimePartitionInterval());
        dataSet.setGlobalConfig(globalConfig);
    }

    public DataSet registerDataNode(RegisterDataNodeReq req) {
        DataNodeConfigurationResp dataSet = new DataNodeConfigurationResp();
        if (this.nodeInfo.isOnlineDataNode(req.getInfo().getLocation())) {
            AsyncDataNodeClientPool.getInstance().resetClient(req.getInfo().getLocation().getInternalEndPoint());
            TSStatus status = new TSStatus(TSStatusCode.DATANODE_ALREADY_REGISTERED.getStatusCode());
            status.setMessage("DataNode already registered.");
            dataSet.setStatus(status);
        } else {
            req.getInfo().getLocation().setDataNodeId(this.nodeInfo.generateNextNodeId());
            ConsensusWriteResponse resp = this.getConsensusManager().write(req);
            dataSet.setStatus(resp.getStatus());
            this.getClusterSchemaManager().adjustMaxRegionGroupCount();
        }
        dataSet.setDataNodeId(req.getInfo().getLocation().getDataNodeId());
        dataSet.setConfigNodeList(this.nodeInfo.getOnlineConfigNodes());
        this.setGlobalConfig(dataSet);
        return dataSet;
    }

    public DataNodeInfosResp getDataNodeInfo(GetDataNodeInfoReq req) {
        return (DataNodeInfosResp)this.getConsensusManager().read(req).getDataset();
    }

    public int getOnlineDataNodeCount() {
        return this.nodeInfo.getOnlineDataNodeCount();
    }

    public int getTotalCpuCoreCount() {
        return this.nodeInfo.getTotalCpuCoreCount();
    }

    public List<TDataNodeInfo> getOnlineDataNodes(int dataNodeId) {
        return this.nodeInfo.getOnlineDataNodes(dataNodeId);
    }

    public TConfigNodeRegisterResp registerConfigNode(TConfigNodeRegisterReq req) {
        TConfigNodeRegisterResp resp = new TConfigNodeRegisterResp();
        resp.setStatus(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()));
        resp.setPartitionRegionId(this.getConsensusManager().getConsensusGroupId().convertToTConsensusGroupId());
        resp.setConfigNodeList(this.nodeInfo.getOnlineConfigNodes());
        return resp;
    }

    public TSStatus applyConfigNode(ApplyConfigNodeReq applyConfigNodeReq) {
        if (this.getConsensusManager().addConfigNodePeer(applyConfigNodeReq)) {
            applyConfigNodeReq.getConfigNodeLocation().setConfigNodeId(this.nodeInfo.generateNextNodeId());
            return this.getConsensusManager().write(applyConfigNodeReq).getStatus();
        }
        return new TSStatus(TSStatusCode.APPLY_CONFIGNODE_FAILED.getStatusCode()).setMessage("Apply ConfigNode failed because there is another ConfigNode being applied.");
    }

    public void addMetrics() {
        this.nodeInfo.addMetrics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSStatus removeConfigNode(RemoveConfigNodeReq removeConfigNodeReq) {
        if (this.removeConfigNodeLock.tryLock()) {
            try {
                if (this.getOnlineConfigNodes().size() <= 1) {
                    TSStatus tSStatus = new TSStatus(TSStatusCode.REMOVE_CONFIGNODE_FAILED.getStatusCode()).setMessage("Remove ConfigNode failed because there is only one ConfigNode in current Cluster.");
                    return tSStatus;
                }
                if (!this.getOnlineConfigNodes().contains(removeConfigNodeReq.getConfigNodeLocation())) {
                    TSStatus tSStatus = new TSStatus(TSStatusCode.REMOVE_CONFIGNODE_FAILED.getStatusCode()).setMessage("Remove ConfigNode failed because the ConfigNode not in current Cluster.");
                    return tSStatus;
                }
                TConfigNodeLocation leader = this.getConsensusManager().getLeader();
                if (leader == null) {
                    TSStatus tSStatus = new TSStatus(TSStatusCode.REMOVE_CONFIGNODE_FAILED.getStatusCode()).setMessage("Remove ConfigNode failed because the ConfigNodeGroup is on leader election, please retry.");
                    return tSStatus;
                }
                if (leader.getInternalEndPoint().equals(removeConfigNodeReq.getConfigNodeLocation().getInternalEndPoint())) {
                    TSStatus tSStatus = this.transferLeader(removeConfigNodeReq, this.getConsensusManager().getConsensusGroupId());
                    return tSStatus;
                }
                if (this.getConsensusManager().removeConfigNodePeer(removeConfigNodeReq)) {
                    this.configManager.getLoadManager().removeNodeHeartbeatHandCache(removeConfigNodeReq.getConfigNodeLocation().getConfigNodeId());
                    TSStatus tSStatus = this.getConsensusManager().write(removeConfigNodeReq).getStatus();
                    return tSStatus;
                }
                TSStatus tSStatus = new TSStatus(TSStatusCode.REMOVE_CONFIGNODE_FAILED.getStatusCode()).setMessage("Remove ConfigNode failed because update ConsensusGroup peer information failed.");
                return tSStatus;
            }
            finally {
                this.removeConfigNodeLock.unlock();
            }
        }
        return new TSStatus(TSStatusCode.REMOVE_CONFIGNODE_FAILED.getStatusCode()).setMessage("A ConfigNode is removing. Please wait or try again.");
    }

    private TSStatus transferLeader(RemoveConfigNodeReq removeConfigNodeReq, ConsensusGroupId groupId) {
        TConfigNodeLocation newLeader = this.getOnlineConfigNodes().stream().filter(e -> !e.equals(removeConfigNodeReq.getConfigNodeLocation())).findAny().get();
        ConsensusGenericResponse resp = this.getConsensusManager().getConsensusImpl().transferLeader(groupId, new Peer(groupId, newLeader.getConsensusEndPoint()));
        if (!resp.isSuccess()) {
            return new TSStatus(TSStatusCode.REMOVE_CONFIGNODE_FAILED.getStatusCode()).setMessage("Remove ConfigNode failed because transfer ConfigNode leader failed.");
        }
        return new TSStatus(TSStatusCode.NEED_REDIRECTION.getStatusCode()).setRedirectNode(newLeader.getInternalEndPoint()).setMessage("The ConfigNode to be removed is leader, already transfer Leader to " + newLeader + ".");
    }

    public List<TConfigNodeLocation> getOnlineConfigNodes() {
        return this.nodeInfo.getOnlineConfigNodes();
    }

    private ConsensusManager getConsensusManager() {
        return this.configManager.getConsensusManager();
    }

    private ClusterSchemaManager getClusterSchemaManager() {
        return this.configManager.getClusterSchemaManager();
    }

    public void registerListener(ChangeServerListener serverListener) {
        this.listeners.add(serverListener);
    }

    public boolean unregisterListener(ChangeServerListener serverListener) {
        return this.listeners.remove(serverListener);
    }

    public void waitForDataNodes() {
        this.listeners.stream().forEach(serverListener -> serverListener.waiting());
    }

    public List<TSStatus> flush(TFlushReq req) {
        List<TDataNodeInfo> onlineDataNodes = this.configManager.getNodeManager().getOnlineDataNodes(req.dataNodeId);
        List<TSStatus> dataNodeResponseStatus = Collections.synchronizedList(new ArrayList(onlineDataNodes.size()));
        CountDownLatch countDownLatch = new CountDownLatch(onlineDataNodes.size());
        for (TDataNodeInfo dataNodeInfo : onlineDataNodes) {
            AsyncDataNodeClientPool.getInstance().flush(dataNodeInfo.getLocation().getInternalEndPoint(), req, new FlushHandler(dataNodeInfo.getLocation(), countDownLatch, dataNodeResponseStatus));
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.error("NodeManager was interrupted during flushing on data nodes", (Throwable)e);
        }
        return dataNodeResponseStatus;
    }

    public static interface ChangeServerListener {
        default public void waiting() {
        }

        public void addDataNode(TDataNodeLocation var1);

        public void removeDataNode(TDataNodeLocation var1);
    }

    private class ServerStartListenerThread
    extends Thread
    implements ChangeServerListener {
        private boolean changed = false;

        ServerStartListenerThread() {
            this.setDaemon(true);
        }

        @Override
        public void addDataNode(TDataNodeLocation DataNodeInfo) {
            this.serverChanged();
        }

        @Override
        public void removeDataNode(TDataNodeLocation dataNodeInfo) {
            this.serverChanged();
        }

        private synchronized void serverChanged() {
            this.changed = true;
            this.notify();
        }

        @Override
        public void run() {
            while (!NodeManager.this.configManager.isStopped()) {
            }
        }
    }
}

