/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TDataNodeInfo;
import org.apache.iotdb.common.rpc.thrift.TFlushReq;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.AuthUtils;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.commons.utils.StatusUtils;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.auth.AuthorReq;
import org.apache.iotdb.confignode.consensus.request.read.CountStorageGroupReq;
import org.apache.iotdb.confignode.consensus.request.read.GetDataNodeInfoReq;
import org.apache.iotdb.confignode.consensus.request.read.GetDataPartitionReq;
import org.apache.iotdb.confignode.consensus.request.read.GetNodePathsPartitionReq;
import org.apache.iotdb.confignode.consensus.request.read.GetOrCreateDataPartitionReq;
import org.apache.iotdb.confignode.consensus.request.read.GetOrCreateSchemaPartitionReq;
import org.apache.iotdb.confignode.consensus.request.read.GetRegionInfoListReq;
import org.apache.iotdb.confignode.consensus.request.read.GetSchemaPartitionReq;
import org.apache.iotdb.confignode.consensus.request.read.GetStorageGroupReq;
import org.apache.iotdb.confignode.consensus.request.write.RegisterDataNodeReq;
import org.apache.iotdb.confignode.consensus.request.write.RemoveConfigNodeReq;
import org.apache.iotdb.confignode.consensus.request.write.SetDataReplicationFactorReq;
import org.apache.iotdb.confignode.consensus.request.write.SetSchemaReplicationFactorReq;
import org.apache.iotdb.confignode.consensus.request.write.SetStorageGroupReq;
import org.apache.iotdb.confignode.consensus.request.write.SetTTLReq;
import org.apache.iotdb.confignode.consensus.request.write.SetTimePartitionIntervalReq;
import org.apache.iotdb.confignode.consensus.response.CountStorageGroupResp;
import org.apache.iotdb.confignode.consensus.response.DataNodeConfigurationResp;
import org.apache.iotdb.confignode.consensus.response.DataNodeInfosResp;
import org.apache.iotdb.confignode.consensus.response.DataPartitionResp;
import org.apache.iotdb.confignode.consensus.response.PermissionInfoResp;
import org.apache.iotdb.confignode.consensus.response.RegionInfoListResp;
import org.apache.iotdb.confignode.consensus.response.SchemaNodeManagementResp;
import org.apache.iotdb.confignode.consensus.response.SchemaPartitionResp;
import org.apache.iotdb.confignode.consensus.response.StorageGroupSchemaResp;
import org.apache.iotdb.confignode.consensus.statemachine.PartitionRegionStateMachine;
import org.apache.iotdb.confignode.manager.ClusterSchemaManager;
import org.apache.iotdb.confignode.manager.ConsensusManager;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.NodeManager;
import org.apache.iotdb.confignode.manager.PartitionManager;
import org.apache.iotdb.confignode.manager.PermissionManager;
import org.apache.iotdb.confignode.manager.ProcedureManager;
import org.apache.iotdb.confignode.manager.UDFManager;
import org.apache.iotdb.confignode.manager.load.LoadManager;
import org.apache.iotdb.confignode.persistence.AuthorInfo;
import org.apache.iotdb.confignode.persistence.ClusterSchemaInfo;
import org.apache.iotdb.confignode.persistence.NodeInfo;
import org.apache.iotdb.confignode.persistence.ProcedureInfo;
import org.apache.iotdb.confignode.persistence.UDFInfo;
import org.apache.iotdb.confignode.persistence.executor.ConfigRequestExecutor;
import org.apache.iotdb.confignode.persistence.partition.PartitionInfo;
import org.apache.iotdb.confignode.rpc.thrift.TClusterNodeInfos;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterReq;
import org.apache.iotdb.confignode.rpc.thrift.TConfigNodeRegisterResp;
import org.apache.iotdb.confignode.rpc.thrift.TDataPartitionResp;
import org.apache.iotdb.confignode.rpc.thrift.TPermissionInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaNodeManagementResp;
import org.apache.iotdb.confignode.rpc.thrift.TSchemaPartitionResp;
import org.apache.iotdb.confignode.rpc.thrift.TStorageGroupSchema;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.db.mpp.common.schematree.PathPatternTree;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigManager
implements IManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigManager.class);
    private final ConsensusManager consensusManager;
    private final NodeManager nodeManager;
    private final ClusterSchemaManager clusterSchemaManager;
    private final PartitionManager partitionManager;
    private final PermissionManager permissionManager;
    private final LoadManager loadManager;
    private final ProcedureManager procedureManager;
    private final UDFManager udfManager;

    public ConfigManager() throws IOException {
        NodeInfo nodeInfo = new NodeInfo();
        ClusterSchemaInfo clusterSchemaInfo = new ClusterSchemaInfo();
        PartitionInfo partitionInfo = new PartitionInfo();
        AuthorInfo authorInfo = new AuthorInfo();
        ProcedureInfo procedureInfo = new ProcedureInfo();
        UDFInfo udfInfo = new UDFInfo();
        ConfigRequestExecutor executor = new ConfigRequestExecutor(nodeInfo, clusterSchemaInfo, partitionInfo, authorInfo, procedureInfo, udfInfo);
        PartitionRegionStateMachine stateMachine = new PartitionRegionStateMachine(this, executor);
        this.nodeManager = new NodeManager(this, nodeInfo);
        this.clusterSchemaManager = new ClusterSchemaManager(this, clusterSchemaInfo);
        this.partitionManager = new PartitionManager(this, partitionInfo);
        this.permissionManager = new PermissionManager(this, authorInfo);
        this.procedureManager = new ProcedureManager(this, procedureInfo);
        this.udfManager = new UDFManager(this, udfInfo);
        this.loadManager = new LoadManager(this);
        this.consensusManager = new ConsensusManager(this, stateMachine);
    }

    public void close() throws IOException {
        this.consensusManager.close();
        this.partitionManager.getRegionCleaner().shutdown();
        this.procedureManager.shiftExecutor(false);
    }

    @Override
    public boolean isStopped() {
        return false;
    }

    @Override
    public DataSet registerDataNode(RegisterDataNodeReq registerDataNodeReq) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.nodeManager.registerDataNode(registerDataNodeReq);
        }
        DataNodeConfigurationResp dataSet = new DataNodeConfigurationResp();
        dataSet.setStatus(status);
        dataSet.setConfigNodeList(this.nodeManager.getOnlineConfigNodes());
        return dataSet;
    }

    @Override
    public DataSet getDataNodeInfo(GetDataNodeInfoReq getDataNodeInfoReq) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.nodeManager.getDataNodeInfo(getDataNodeInfoReq);
        }
        DataNodeInfosResp dataSet = new DataNodeInfosResp();
        dataSet.setStatus(status);
        return dataSet;
    }

    @Override
    public TClusterNodeInfos getAllClusterNodeInfos() {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            List<TConfigNodeLocation> configNodeLocations = this.getNodeManager().getOnlineConfigNodes();
            List dataNodeInfoLocations = this.getNodeManager().getOnlineDataNodes(-1).stream().map(TDataNodeInfo::getLocation).collect(Collectors.toList());
            HashMap nodeStatus = new HashMap();
            this.getLoadManager().getHeartbeatCacheMap().forEach((nodeId, heartbeatCache) -> nodeStatus.put(nodeId, heartbeatCache.getNodeStatus().getStatus()));
            return new TClusterNodeInfos(status, configNodeLocations, dataNodeInfoLocations, nodeStatus);
        }
        return new TClusterNodeInfos(status, new ArrayList(), new ArrayList(), new HashMap());
    }

    @Override
    public TSStatus setTTL(SetTTLReq setTTLReq) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.clusterSchemaManager.setTTL(setTTLReq);
        }
        return status;
    }

    @Override
    public TSStatus setSchemaReplicationFactor(SetSchemaReplicationFactorReq setSchemaReplicationFactorReq) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.clusterSchemaManager.setSchemaReplicationFactor(setSchemaReplicationFactorReq);
        }
        return status;
    }

    @Override
    public TSStatus setDataReplicationFactor(SetDataReplicationFactorReq setDataReplicationFactorReq) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.clusterSchemaManager.setDataReplicationFactor(setDataReplicationFactorReq);
        }
        return status;
    }

    @Override
    public TSStatus setTimePartitionInterval(SetTimePartitionIntervalReq setTimePartitionIntervalReq) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.clusterSchemaManager.setTimePartitionInterval(setTimePartitionIntervalReq);
        }
        return status;
    }

    @Override
    public DataSet countMatchedStorageGroups(CountStorageGroupReq countStorageGroupReq) {
        TSStatus status = this.confirmLeader();
        CountStorageGroupResp result = new CountStorageGroupResp();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.clusterSchemaManager.countMatchedStorageGroups(countStorageGroupReq);
        }
        result.setStatus(status);
        return result;
    }

    @Override
    public DataSet getMatchedStorageGroupSchemas(GetStorageGroupReq getStorageGroupReq) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.clusterSchemaManager.getMatchedStorageGroupSchema(getStorageGroupReq);
        }
        StorageGroupSchemaResp dataSet = new StorageGroupSchemaResp();
        dataSet.setStatus(status);
        return dataSet;
    }

    @Override
    public TSStatus setStorageGroup(SetStorageGroupReq setStorageGroupReq) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.clusterSchemaManager.setStorageGroup(setStorageGroupReq);
        }
        return status;
    }

    @Override
    public TSStatus deleteStorageGroups(List<String> deletedPaths) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            Map<String, TStorageGroupSchema> deleteStorageSchemaMap = this.getClusterSchemaManager().getMatchedStorageGroupSchemasByName(deletedPaths);
            if (deleteStorageSchemaMap.isEmpty()) {
                return RpcUtils.getStatus((int)TSStatusCode.TIMESERIES_NOT_EXIST.getStatusCode(), (String)String.format("Path %s does not exist", Arrays.toString(deletedPaths.toArray())));
            }
            ArrayList<TStorageGroupSchema> parsedDeleteStorageGroups = new ArrayList<TStorageGroupSchema>(deleteStorageSchemaMap.values());
            return this.procedureManager.deleteStorageGroups(parsedDeleteStorageGroups);
        }
        return status;
    }

    private List<TSeriesPartitionSlot> calculateRelatedSlot(PartialPath path, PartialPath storageGroup) {
        if (path.getFullPath().contains("**")) {
            return new ArrayList<TSeriesPartitionSlot>();
        }
        PartialPath innerPath = (PartialPath)path.alterPrefixPath(storageGroup).get(0);
        if (innerPath.getDevice().contains("*")) {
            return new ArrayList<TSeriesPartitionSlot>();
        }
        return Collections.singletonList(this.getPartitionManager().getSeriesPartitionSlot(innerPath.getDevice()));
    }

    @Override
    public TSchemaPartitionResp getSchemaPartition(PathPatternTree patternTree) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            Object resp;
            GetSchemaPartitionReq getSchemaPartitionReq = new GetSchemaPartitionReq();
            HashMap<String, Set> partitionSlotsMap = new HashMap<String, Set>();
            List relatedPaths = patternTree.getAllPathPatterns();
            List<String> allStorageGroups = this.getClusterSchemaManager().getStorageGroupNames();
            HashMap<String, Boolean> scanAllRegions = new HashMap<String, Boolean>();
            for (PartialPath path : relatedPaths) {
                for (String storageGroup : allStorageGroups) {
                    try {
                        PartialPath storageGroupPath = new PartialPath(storageGroup);
                        if (!path.overlapWith(storageGroupPath.concatNode("**")) || scanAllRegions.containsKey(storageGroup)) continue;
                        List<TSeriesPartitionSlot> relatedSlot = this.calculateRelatedSlot(path, storageGroupPath);
                        if (relatedSlot.isEmpty()) {
                            scanAllRegions.put(storageGroup, true);
                            partitionSlotsMap.put(storageGroup, new HashSet());
                            continue;
                        }
                        partitionSlotsMap.computeIfAbsent(storageGroup, k -> new HashSet()).addAll(relatedSlot);
                    }
                    catch (IllegalPathException e2) {
                        throw new RuntimeException(e2);
                    }
                }
            }
            if (partitionSlotsMap.isEmpty()) {
                resp = new TSchemaPartitionResp();
                resp.setStatus(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()));
                resp.setSchemaRegionMap(new HashMap());
                return resp;
            }
            getSchemaPartitionReq.setPartitionSlotsMap(partitionSlotsMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new ArrayList((Collection)e.getValue()))));
            resp = (SchemaPartitionResp)this.partitionManager.getSchemaPartition(getSchemaPartitionReq);
            TSchemaPartitionResp result = ((SchemaPartitionResp)resp).convertToRpcSchemaPartitionResp(this.getLoadManager().genRealTimeRoutingPolicy());
            LOGGER.info("GetSchemaPartition receive paths: {}, return TSchemaPartitionResp: {}", (Object)relatedPaths, (Object)result);
            return result;
        }
        return new TSchemaPartitionResp().setStatus(status);
    }

    @Override
    public TSchemaPartitionResp getOrCreateSchemaPartition(PathPatternTree patternTree) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            List devicePaths = patternTree.getAllDevicePatterns();
            List<String> storageGroups = this.getClusterSchemaManager().getStorageGroupNames();
            GetOrCreateSchemaPartitionReq getOrCreateSchemaPartitionReq = new GetOrCreateSchemaPartitionReq();
            HashMap<String, List<TSeriesPartitionSlot>> partitionSlotsMap = new HashMap<String, List<TSeriesPartitionSlot>>();
            block0: for (String devicePath : devicePaths) {
                if (devicePath.contains("*")) continue;
                for (String storageGroup : storageGroups) {
                    if (!PathUtils.isStartWith((String)devicePath, (String)storageGroup)) continue;
                    partitionSlotsMap.computeIfAbsent(storageGroup, key -> new ArrayList()).add(this.getPartitionManager().getSeriesPartitionSlot(devicePath));
                    continue block0;
                }
            }
            getOrCreateSchemaPartitionReq.setPartitionSlotsMap(partitionSlotsMap);
            SchemaPartitionResp resp = (SchemaPartitionResp)this.partitionManager.getOrCreateSchemaPartition(getOrCreateSchemaPartitionReq);
            TSchemaPartitionResp result = resp.convertToRpcSchemaPartitionResp(this.getLoadManager().genRealTimeRoutingPolicy());
            LOGGER.info("GetOrCreateSchemaPartition receive devicePaths: {}, return TSchemaPartitionResp: {}", (Object)devicePaths, (Object)result);
            return result;
        }
        return new TSchemaPartitionResp().setStatus(status);
    }

    @Override
    public TSchemaNodeManagementResp getNodePathsPartition(PartialPath partialPath, Integer level) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            GetNodePathsPartitionReq getNodePathsPartitionReq = new GetNodePathsPartitionReq();
            getNodePathsPartitionReq.setPartialPath(partialPath);
            if (null != level) {
                getNodePathsPartitionReq.setLevel(level);
            }
            SchemaNodeManagementResp resp = (SchemaNodeManagementResp)this.partitionManager.getNodePathsPartition(getNodePathsPartitionReq);
            TSchemaNodeManagementResp result = resp.convertToRpcSchemaNodeManagementPartitionResp(this.getLoadManager().genRealTimeRoutingPolicy());
            LOGGER.info("getNodePathsPartition receive devicePaths: {}, level: {}, return TSchemaNodeManagementResp: {}", new Object[]{partialPath, level, result});
            return result;
        }
        return new TSchemaNodeManagementResp().setStatus(status);
    }

    @Override
    public TDataPartitionResp getDataPartition(GetDataPartitionReq getDataPartitionReq) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            DataPartitionResp resp = (DataPartitionResp)this.partitionManager.getDataPartition(getDataPartitionReq);
            TDataPartitionResp result = resp.convertToTDataPartitionResp(this.getLoadManager().genRealTimeRoutingPolicy());
            LOGGER.info("GetDataPartition interface receive PartitionSlotsMap: {}, return TDataPartitionResp: {}", getDataPartitionReq.getPartitionSlotsMap(), (Object)result);
            return result;
        }
        return new TDataPartitionResp().setStatus(status);
    }

    @Override
    public TDataPartitionResp getOrCreateDataPartition(GetOrCreateDataPartitionReq getOrCreateDataPartitionReq) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            DataPartitionResp resp = (DataPartitionResp)this.partitionManager.getOrCreateDataPartition(getOrCreateDataPartitionReq);
            TDataPartitionResp result = resp.convertToTDataPartitionResp(this.getLoadManager().genRealTimeRoutingPolicy());
            LOGGER.info("GetOrCreateDataPartition success. receive PartitionSlotsMap: {}, return TDataPartitionResp: {}", getOrCreateDataPartitionReq.getPartitionSlotsMap(), (Object)result);
            return result;
        }
        return new TDataPartitionResp().setStatus(status);
    }

    private TSStatus confirmLeader() {
        TSStatus result = new TSStatus();
        if (this.getConsensusManager().isLeader()) {
            return result.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        result.setCode(TSStatusCode.NEED_REDIRECTION.getStatusCode());
        result.setMessage("The current ConfigNode is not leader, please redirect to a new ConfigNode.");
        TConfigNodeLocation leaderLocation = this.consensusManager.getLeader();
        if (leaderLocation != null) {
            result.setRedirectNode(leaderLocation.getInternalEndPoint());
        }
        return result;
    }

    @Override
    public NodeManager getNodeManager() {
        return this.nodeManager;
    }

    @Override
    public ClusterSchemaManager getClusterSchemaManager() {
        return this.clusterSchemaManager;
    }

    @Override
    public ConsensusManager getConsensusManager() {
        return this.consensusManager;
    }

    @Override
    public PartitionManager getPartitionManager() {
        return this.partitionManager;
    }

    @Override
    public LoadManager getLoadManager() {
        return this.loadManager;
    }

    @Override
    public TSStatus operatePermission(AuthorReq authorReq) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.permissionManager.operatePermission(authorReq);
        }
        return status;
    }

    @Override
    public DataSet queryPermission(AuthorReq authorReq) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.permissionManager.queryPermission(authorReq);
        }
        PermissionInfoResp dataSet = new PermissionInfoResp();
        dataSet.setStatus(status);
        return dataSet;
    }

    @Override
    public TPermissionInfoResp login(String username, String password) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.permissionManager.login(username, password);
        }
        TPermissionInfoResp resp = AuthUtils.generateEmptyPermissionInfoResp();
        resp.setStatus(status);
        return resp;
    }

    @Override
    public TPermissionInfoResp checkUserPrivileges(String username, List<String> paths, int permission) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.permissionManager.checkUserPrivileges(username, paths, permission);
        }
        TPermissionInfoResp resp = AuthUtils.generateEmptyPermissionInfoResp();
        resp.setStatus(status);
        return resp;
    }

    @Override
    public TConfigNodeRegisterResp registerConfigNode(TConfigNodeRegisterReq req) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            TConfigNodeRegisterResp errorResp1 = this.checkConfigNodeRegisterResp(req);
            if (errorResp1 != null) {
                return errorResp1;
            }
            this.procedureManager.addConfigNode(req);
            return this.nodeManager.registerConfigNode(req);
        }
        return new TConfigNodeRegisterResp().setStatus(status);
    }

    private TConfigNodeRegisterResp checkConfigNodeRegisterResp(TConfigNodeRegisterReq req) {
        ConfigNodeConfig conf = ConfigNodeDescriptor.getInstance().getConf();
        TConfigNodeRegisterResp errorResp = new TConfigNodeRegisterResp();
        errorResp.setStatus(new TSStatus(TSStatusCode.ERROR_GLOBAL_CONFIG.getStatusCode()));
        if (!req.getDataRegionConsensusProtocolClass().equals(conf.getDataRegionConsensusProtocolClass())) {
            errorResp.getStatus().setMessage("Reject register, please ensure that the data_region_consensus_protocol_class are consistent.");
            return errorResp;
        }
        if (!req.getSchemaRegionConsensusProtocolClass().equals(conf.getSchemaRegionConsensusProtocolClass())) {
            errorResp.getStatus().setMessage("Reject register, please ensure that the schema_region_consensus_protocol_class are consistent.");
            return errorResp;
        }
        if (req.getSeriesPartitionSlotNum() != conf.getSeriesPartitionSlotNum()) {
            errorResp.getStatus().setMessage("Reject register, please ensure that the series_partition_slot_num are consistent.");
            return errorResp;
        }
        if (!req.getSeriesPartitionExecutorClass().equals(conf.getSeriesPartitionExecutorClass())) {
            errorResp.getStatus().setMessage("Reject register, please ensure that the series_partition_executor_class are consistent.");
            return errorResp;
        }
        if (req.getDefaultTTL() != CommonDescriptor.getInstance().getConfig().getDefaultTTL()) {
            errorResp.getStatus().setMessage("Reject register, please ensure that the default_ttl are consistent.");
            return errorResp;
        }
        if (req.getTimePartitionInterval() != conf.getTimePartitionInterval()) {
            errorResp.getStatus().setMessage("Reject register, please ensure that the time_partition_interval are consistent.");
            return errorResp;
        }
        if (req.getSchemaReplicationFactor() != conf.getSchemaReplicationFactor()) {
            errorResp.getStatus().setMessage("Reject register, please ensure that the schema_replication_factor are consistent.");
            return errorResp;
        }
        if (req.getSchemaRegionPerDataNode() != conf.getSchemaRegionPerDataNode()) {
            errorResp.getStatus().setMessage("Reject register, please ensure that the schema_region_per_data_node are consistent.");
            return errorResp;
        }
        if (req.getDataReplicationFactor() != conf.getDataReplicationFactor()) {
            errorResp.getStatus().setMessage("Reject register, please ensure that the data_replication_factor are consistent.");
            return errorResp;
        }
        if (req.getDataRegionPerProcessor() != conf.getDataRegionPerProcessor()) {
            errorResp.getStatus().setMessage("Reject register, please ensure that the data_region_per_processor are consistent.");
            return errorResp;
        }
        return null;
    }

    @Override
    public TSStatus addConsensusGroup(List<TConfigNodeLocation> configNodeLocations) {
        this.consensusManager.addConsensusGroup(configNodeLocations);
        return StatusUtils.OK;
    }

    @Override
    public TSStatus removeConfigNode(RemoveConfigNodeReq removeConfigNodeReq) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.nodeManager.removeConfigNode(removeConfigNodeReq);
        }
        return status;
    }

    @Override
    public TSStatus createFunction(String udfName, String className, List<String> uris) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.udfManager.createFunction(udfName, className, uris) : status;
    }

    @Override
    public TSStatus dropFunction(String udfName) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? this.udfManager.dropFunction(udfName) : status;
    }

    @Override
    public TSStatus flush(TFlushReq req) {
        TSStatus status = this.confirmLeader();
        return status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? RpcUtils.squashResponseStatusList(this.nodeManager.flush(req)) : status;
    }

    @Override
    public UDFManager getUDFManager() {
        return this.udfManager;
    }

    @Override
    public DataSet showRegion(GetRegionInfoListReq getRegionsinfoReq) {
        TSStatus status = this.confirmLeader();
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            return this.partitionManager.getRegionInfoList(getRegionsinfoReq);
        }
        RegionInfoListResp regionResp = new RegionInfoListResp();
        regionResp.setStatus(status);
        return regionResp;
    }

    public ProcedureManager getProcedureManager() {
        return this.procedureManager;
    }

    public List<PartialPath> checkStorageGroupExist(List<PartialPath> storageGroups) {
        ArrayList<PartialPath> noExistSg = new ArrayList<PartialPath>();
        if (storageGroups == null) {
            return noExistSg;
        }
        for (PartialPath storageGroup : storageGroups) {
            if (this.clusterSchemaManager.getStorageGroupNames().contains(storageGroup.toString())) continue;
            noExistSg.add(storageGroup);
        }
        return noExistSg;
    }

    @Override
    public void addMetrics() {
        this.partitionManager.addMetrics();
        this.nodeManager.addMetrics();
    }
}

