/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager;

import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.read.CountStorageGroupReq;
import org.apache.iotdb.confignode.consensus.request.read.GetStorageGroupReq;
import org.apache.iotdb.confignode.consensus.request.write.AdjustMaxRegionGroupCountReq;
import org.apache.iotdb.confignode.consensus.request.write.DeleteStorageGroupReq;
import org.apache.iotdb.confignode.consensus.request.write.SetDataReplicationFactorReq;
import org.apache.iotdb.confignode.consensus.request.write.SetSchemaReplicationFactorReq;
import org.apache.iotdb.confignode.consensus.request.write.SetStorageGroupReq;
import org.apache.iotdb.confignode.consensus.request.write.SetTTLReq;
import org.apache.iotdb.confignode.consensus.request.write.SetTimePartitionIntervalReq;
import org.apache.iotdb.confignode.exception.StorageGroupNotExistsException;
import org.apache.iotdb.confignode.manager.ConsensusManager;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.NodeManager;
import org.apache.iotdb.confignode.manager.PartitionManager;
import org.apache.iotdb.confignode.persistence.ClusterSchemaInfo;
import org.apache.iotdb.confignode.rpc.thrift.TStorageGroupSchema;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterSchemaManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterSchemaManager.class);
    private static final double schemaRegionPerDataNode = ConfigNodeDescriptor.getInstance().getConf().getSchemaRegionPerDataNode();
    private static final double dataRegionPerProcessor = ConfigNodeDescriptor.getInstance().getConf().getDataRegionPerProcessor();
    private final IManager configManager;
    private final ClusterSchemaInfo clusterSchemaInfo;

    public ClusterSchemaManager(IManager configManager, ClusterSchemaInfo clusterSchemaInfo) {
        this.configManager = configManager;
        this.clusterSchemaInfo = clusterSchemaInfo;
    }

    public TSStatus setStorageGroup(SetStorageGroupReq setStorageGroupReq) {
        try {
            this.clusterSchemaInfo.checkContainsStorageGroup(setStorageGroupReq.getSchema().getName());
        }
        catch (MetadataException metadataException) {
            TSStatus result = metadataException instanceof IllegalPathException ? new TSStatus(TSStatusCode.PATH_ILLEGAL.getStatusCode()) : new TSStatus(TSStatusCode.STORAGE_GROUP_ALREADY_EXISTS.getStatusCode());
            result.setMessage(metadataException.getMessage());
            return result;
        }
        TSStatus result = this.getConsensusManager().write(setStorageGroupReq).getStatus();
        this.adjustMaxRegionGroupCount();
        return result;
    }

    public TSStatus deleteStorageGroup(DeleteStorageGroupReq deleteStorageGroupReq) {
        this.adjustMaxRegionGroupCount();
        return this.getConsensusManager().write(deleteStorageGroupReq).getStatus();
    }

    public DataSet countMatchedStorageGroups(CountStorageGroupReq countStorageGroupReq) {
        return this.getConsensusManager().read(countStorageGroupReq).getDataset();
    }

    public DataSet getMatchedStorageGroupSchema(GetStorageGroupReq getStorageGroupReq) {
        return this.getConsensusManager().read(getStorageGroupReq).getDataset();
    }

    public TSStatus setTTL(SetTTLReq setTTLReq) {
        return this.getConsensusManager().write(setTTLReq).getStatus();
    }

    public TSStatus setSchemaReplicationFactor(SetSchemaReplicationFactorReq setSchemaReplicationFactorReq) {
        return this.getConsensusManager().write(setSchemaReplicationFactorReq).getStatus();
    }

    public TSStatus setDataReplicationFactor(SetDataReplicationFactorReq setDataReplicationFactorReq) {
        return this.getConsensusManager().write(setDataReplicationFactorReq).getStatus();
    }

    public TSStatus setTimePartitionInterval(SetTimePartitionIntervalReq setTimePartitionIntervalReq) {
        return this.getConsensusManager().write(setTimePartitionIntervalReq).getStatus();
    }

    public synchronized void adjustMaxRegionGroupCount() {
        Map<String, TStorageGroupSchema> storageGroupSchemaMap = this.getMatchedStorageGroupSchemasByName(this.getStorageGroupNames());
        int dataNodeNum = this.getNodeManager().getOnlineDataNodeCount();
        int totalCpuCoreNum = this.getNodeManager().getTotalCpuCoreCount();
        int storageGroupNum = storageGroupSchemaMap.size();
        AdjustMaxRegionGroupCountReq adjustMaxRegionGroupCountReq = new AdjustMaxRegionGroupCountReq();
        for (TStorageGroupSchema storageGroupSchema : storageGroupSchemaMap.values()) {
            try {
                int allocatedSchemaRegionGroupCount = this.getPartitionManager().getRegionCount(storageGroupSchema.getName(), TConsensusGroupType.SchemaRegion);
                int maxSchemaRegionGroupCount = Math.max(1, Math.max((int)(schemaRegionPerDataNode * (double)dataNodeNum / (double)(storageGroupNum * storageGroupSchema.getSchemaReplicationFactor())), allocatedSchemaRegionGroupCount));
                int allocatedDataRegionGroupCount = this.getPartitionManager().getRegionCount(storageGroupSchema.getName(), TConsensusGroupType.DataRegion);
                int maxDataRegionGroupCount = Math.max(2, Math.max((int)(dataRegionPerProcessor * (double)totalCpuCoreNum / (double)(storageGroupNum * storageGroupSchema.getDataReplicationFactor())), allocatedDataRegionGroupCount));
                adjustMaxRegionGroupCountReq.putEntry(storageGroupSchema.getName(), (Pair<Integer, Integer>)new Pair((Object)maxSchemaRegionGroupCount, (Object)maxDataRegionGroupCount));
            }
            catch (StorageGroupNotExistsException e) {
                LOGGER.warn("Adjust maxRegionGroupCount failed because StorageGroup doesn't exist", (Throwable)e);
            }
        }
        this.getConsensusManager().write(adjustMaxRegionGroupCountReq);
    }

    public TStorageGroupSchema getStorageGroupSchemaByName(String storageGroup) throws StorageGroupNotExistsException {
        return this.clusterSchemaInfo.getMatchedStorageGroupSchemaByName(storageGroup);
    }

    public Map<String, TStorageGroupSchema> getMatchedStorageGroupSchemasByName(List<String> rawPathList) {
        return this.clusterSchemaInfo.getMatchedStorageGroupSchemasByName(rawPathList);
    }

    public List<String> getStorageGroupNames() {
        return this.clusterSchemaInfo.getStorageGroupNames();
    }

    public int getMaxRegionGroupCount(String storageGroup, TConsensusGroupType consensusGroupType) {
        return this.clusterSchemaInfo.getMaxRegionGroupCount(storageGroup, consensusGroupType);
    }

    private NodeManager getNodeManager() {
        return this.configManager.getNodeManager();
    }

    private PartitionManager getPartitionManager() {
        return this.configManager.getPartitionManager();
    }

    private ConsensusManager getConsensusManager() {
        return this.configManager.getConsensusManager();
    }
}

