/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.conf;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;

public class ConfigNodeConfig {
    private String rpcAddress = "0.0.0.0";
    private int rpcPort = 22277;
    private int consensusPort = 22278;
    private TEndPoint targetConfigNode = new TEndPoint("0.0.0.0", 22277);
    private boolean needApply = false;
    private int partitionRegionId = 0;
    private List<TConfigNodeLocation> configNodeList = new ArrayList<TConfigNodeLocation>();
    private int connectionTimeoutInMS = (int)TimeUnit.SECONDS.toMillis(20L);
    private String configNodeConsensusProtocolClass = "org.apache.iotdb.consensus.ratis.RatisConsensus";
    private String schemaRegionConsensusProtocolClass = "org.apache.iotdb.consensus.standalone.StandAloneConsensus";
    private double schemaRegionPerDataNode = 1.0;
    private String dataRegionConsensusProtocolClass = "org.apache.iotdb.consensus.standalone.StandAloneConsensus";
    private double dataRegionPerProcessor = 0.5;
    private int selectorNumOfClientManager = Runtime.getRuntime().availableProcessors() / 4 > 0 ? Runtime.getRuntime().availableProcessors() / 4 : 1;
    private int seriesPartitionSlotNum = 10000;
    private String seriesPartitionExecutorClass = "org.apache.iotdb.commons.partition.executor.hash.BKDRHashExecutor";
    private int rpcMaxConcurrentClientNum = 65535;
    private boolean isRpcThriftCompressionEnabled = false;
    private boolean rpcAdvancedCompressionEnable = false;
    private int thriftMaxFrameSize = 0x20000000;
    private int thriftDefaultBufferSize = 1024;
    private int thriftServerAwaitTimeForStopService = 60;
    private String systemDir = "data" + File.separator + "system";
    private String consensusDir = "data" + File.separator + "consensus";
    private String extLibDir = "ext";
    private String udfLibDir = "ext" + File.separator + "udf";
    private String temporaryLibDir = "ext" + File.separator + "temporary";
    private long timePartitionInterval = 604800L;
    private int schemaReplicationFactor = 1;
    private int dataReplicationFactor = 1;
    private int procedureCompletedEvictTTL = 800;
    private int procedureCompletedCleanInterval = 30;
    private int procedureCoreWorkerThreadsSize = Math.max(Runtime.getRuntime().availableProcessors() / 4, 16);
    private long heartbeatInterval = 1000L;

    ConfigNodeConfig() {
    }

    public void updatePath() {
        this.formulateFolders();
    }

    private void formulateFolders() {
        this.systemDir = this.addHomeDir(this.systemDir);
        this.consensusDir = this.addHomeDir(this.consensusDir);
        this.extLibDir = this.addHomeDir(this.extLibDir);
        this.udfLibDir = this.addHomeDir(this.udfLibDir);
        this.temporaryLibDir = this.addHomeDir(this.temporaryLibDir);
    }

    private String addHomeDir(String dir) {
        String homeDir = System.getProperty("CONFIGNODE_HOME", null);
        if (!new File(dir).isAbsolute() && homeDir != null && homeDir.length() > 0) {
            dir = !homeDir.endsWith(File.separator) ? homeDir + File.separatorChar + dir : homeDir + dir;
        }
        return dir;
    }

    public String getRpcAddress() {
        return this.rpcAddress;
    }

    public void setRpcAddress(String rpcAddress) {
        this.rpcAddress = rpcAddress;
    }

    public int getRpcPort() {
        return this.rpcPort;
    }

    public void setRpcPort(int rpcPort) {
        this.rpcPort = rpcPort;
    }

    public int getConsensusPort() {
        return this.consensusPort;
    }

    public void setConsensusPort(int consensusPort) {
        this.consensusPort = consensusPort;
    }

    public boolean isNeedApply() {
        return this.needApply;
    }

    public void setNeedApply(boolean needApply) {
        this.needApply = needApply;
    }

    public TEndPoint getTargetConfigNode() {
        return this.targetConfigNode;
    }

    public void setTargetConfigNode(TEndPoint targetConfigNode) {
        this.targetConfigNode = targetConfigNode;
    }

    public int getPartitionRegionId() {
        return this.partitionRegionId;
    }

    public void setPartitionRegionId(int partitionRegionId) {
        this.partitionRegionId = partitionRegionId;
    }

    public List<TConfigNodeLocation> getConfigNodeList() {
        return this.configNodeList;
    }

    public void setConfigNodeList(List<TConfigNodeLocation> configNodeList) {
        this.configNodeList = configNodeList;
    }

    public int getSeriesPartitionSlotNum() {
        return this.seriesPartitionSlotNum;
    }

    public void setSeriesPartitionSlotNum(int seriesPartitionSlotNum) {
        this.seriesPartitionSlotNum = seriesPartitionSlotNum;
    }

    public String getSeriesPartitionExecutorClass() {
        return this.seriesPartitionExecutorClass;
    }

    public void setSeriesPartitionExecutorClass(String seriesPartitionExecutorClass) {
        this.seriesPartitionExecutorClass = seriesPartitionExecutorClass;
    }

    public int getSelectorNumOfClientManager() {
        return this.selectorNumOfClientManager;
    }

    public long getTimePartitionInterval() {
        return this.timePartitionInterval;
    }

    public void setTimePartitionInterval(long timePartitionInterval) {
        this.timePartitionInterval = timePartitionInterval;
    }

    public int getRpcMaxConcurrentClientNum() {
        return this.rpcMaxConcurrentClientNum;
    }

    public void setRpcMaxConcurrentClientNum(int rpcMaxConcurrentClientNum) {
        this.rpcMaxConcurrentClientNum = rpcMaxConcurrentClientNum;
    }

    public boolean isRpcThriftCompressionEnabled() {
        return this.isRpcThriftCompressionEnabled;
    }

    public void setRpcThriftCompressionEnabled(boolean rpcThriftCompressionEnabled) {
        this.isRpcThriftCompressionEnabled = rpcThriftCompressionEnabled;
    }

    public boolean isRpcAdvancedCompressionEnable() {
        return this.rpcAdvancedCompressionEnable;
    }

    public void setRpcAdvancedCompressionEnable(boolean rpcAdvancedCompressionEnable) {
        this.rpcAdvancedCompressionEnable = rpcAdvancedCompressionEnable;
    }

    public int getThriftMaxFrameSize() {
        return this.thriftMaxFrameSize;
    }

    public void setThriftMaxFrameSize(int thriftMaxFrameSize) {
        this.thriftMaxFrameSize = thriftMaxFrameSize;
    }

    public int getThriftDefaultBufferSize() {
        return this.thriftDefaultBufferSize;
    }

    public void setThriftDefaultBufferSize(int thriftDefaultBufferSize) {
        this.thriftDefaultBufferSize = thriftDefaultBufferSize;
    }

    public int getConnectionTimeoutInMS() {
        return this.connectionTimeoutInMS;
    }

    public ConfigNodeConfig setConnectionTimeoutInMS(int connectionTimeoutInMS) {
        this.connectionTimeoutInMS = connectionTimeoutInMS;
        return this;
    }

    public void setSelectorNumOfClientManager(int selectorNumOfClientManager) {
        this.selectorNumOfClientManager = selectorNumOfClientManager;
    }

    public String getConsensusDir() {
        return this.consensusDir;
    }

    public void setConsensusDir(String consensusDir) {
        this.consensusDir = consensusDir;
    }

    public String getConfigNodeConsensusProtocolClass() {
        return this.configNodeConsensusProtocolClass;
    }

    public void setConfigNodeConsensusProtocolClass(String configNodeConsensusProtocolClass) {
        this.configNodeConsensusProtocolClass = configNodeConsensusProtocolClass;
    }

    public String getSchemaRegionConsensusProtocolClass() {
        return this.schemaRegionConsensusProtocolClass;
    }

    public void setSchemaRegionConsensusProtocolClass(String schemaRegionConsensusProtocolClass) {
        this.schemaRegionConsensusProtocolClass = schemaRegionConsensusProtocolClass;
    }

    public double getSchemaRegionPerDataNode() {
        return this.schemaRegionPerDataNode;
    }

    public void setSchemaRegionPerDataNode(double schemaRegionPerDataNode) {
        this.schemaRegionPerDataNode = schemaRegionPerDataNode;
    }

    public String getDataRegionConsensusProtocolClass() {
        return this.dataRegionConsensusProtocolClass;
    }

    public void setDataRegionConsensusProtocolClass(String dataRegionConsensusProtocolClass) {
        this.dataRegionConsensusProtocolClass = dataRegionConsensusProtocolClass;
    }

    public double getDataRegionPerProcessor() {
        return this.dataRegionPerProcessor;
    }

    public void setDataRegionPerProcessor(double dataRegionPerProcessor) {
        this.dataRegionPerProcessor = dataRegionPerProcessor;
    }

    public int getThriftServerAwaitTimeForStopService() {
        return this.thriftServerAwaitTimeForStopService;
    }

    public void setThriftServerAwaitTimeForStopService(int thriftServerAwaitTimeForStopService) {
        this.thriftServerAwaitTimeForStopService = thriftServerAwaitTimeForStopService;
    }

    public String getSystemDir() {
        return this.systemDir;
    }

    public void setSystemDir(String systemDir) {
        this.systemDir = systemDir;
    }

    public String getSystemUdfDir() {
        return this.getSystemDir() + File.separator + "udf" + File.separator;
    }

    public String getUdfLibDir() {
        return this.udfLibDir;
    }

    public void setUdfLibDir(String udfLibDir) {
        this.udfLibDir = udfLibDir;
    }

    public String getTemporaryLibDir() {
        return this.temporaryLibDir;
    }

    public void setTemporaryLibDir(String temporaryLibDir) {
        this.temporaryLibDir = temporaryLibDir;
    }

    public int getSchemaReplicationFactor() {
        return this.schemaReplicationFactor;
    }

    public void setSchemaReplicationFactor(int schemaReplicationFactor) {
        this.schemaReplicationFactor = schemaReplicationFactor;
    }

    public int getDataReplicationFactor() {
        return this.dataReplicationFactor;
    }

    public void setDataReplicationFactor(int dataReplicationFactor) {
        this.dataReplicationFactor = dataReplicationFactor;
    }

    public int getProcedureCompletedEvictTTL() {
        return this.procedureCompletedEvictTTL;
    }

    public void setProcedureCompletedEvictTTL(int procedureCompletedEvictTTL) {
        this.procedureCompletedEvictTTL = procedureCompletedEvictTTL;
    }

    public int getProcedureCompletedCleanInterval() {
        return this.procedureCompletedCleanInterval;
    }

    public void setProcedureCompletedCleanInterval(int procedureCompletedCleanInterval) {
        this.procedureCompletedCleanInterval = procedureCompletedCleanInterval;
    }

    public int getProcedureCoreWorkerThreadsSize() {
        return this.procedureCoreWorkerThreadsSize;
    }

    public void setProcedureCoreWorkerThreadsSize(int procedureCoreWorkerThreadsSize) {
        this.procedureCoreWorkerThreadsSize = procedureCoreWorkerThreadsSize;
    }

    public long getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public void setHeartbeatInterval(long heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
    }
}

