/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client.handlers;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.async.AsyncMethodCallback;

public class FunctionManagementHandler
implements AsyncMethodCallback<TSStatus> {
    private final CountDownLatch countDownLatch;
    private final List<TSStatus> dataNodeResponseStatus;
    private final String ip;
    private final int port;

    public FunctionManagementHandler(CountDownLatch countDownLatch, List<TSStatus> dataNodeResponseStatus, String ip, int port) {
        this.countDownLatch = countDownLatch;
        this.dataNodeResponseStatus = dataNodeResponseStatus;
        this.ip = ip;
        this.port = port;
    }

    public void onComplete(TSStatus response) {
        this.countDownLatch.countDown();
        this.dataNodeResponseStatus.add(response);
    }

    public void onError(Exception exception) {
        this.countDownLatch.countDown();
        this.dataNodeResponseStatus.add(new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage("DataNode[" + this.ip + ":" + this.port + "] " + exception.getMessage()));
    }
}

