/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client.handlers;

import java.util.BitSet;
import java.util.concurrent.CountDownLatch;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateRegionHandler
implements AsyncMethodCallback<TSStatus> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateRegionHandler.class);
    private final int index;
    private final BitSet bitSet;
    private final CountDownLatch latch;
    private final TConsensusGroupId consensusGroupId;
    private final TDataNodeLocation dataNodeLocation;

    public CreateRegionHandler(int index, BitSet bitSet, CountDownLatch latch, TConsensusGroupId consensusGroupId, TDataNodeLocation dataNodeLocation) {
        this.index = index;
        this.bitSet = bitSet;
        this.latch = latch;
        this.consensusGroupId = consensusGroupId;
        this.dataNodeLocation = dataNodeLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete(TSStatus tsStatus) {
        if (tsStatus.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            BitSet bitSet = this.bitSet;
            synchronized (bitSet) {
                this.bitSet.set(this.index);
            }
            LOGGER.info(String.format("Successfully create %s on DataNode: %s", ConsensusGroupId.formatTConsensusGroupId((TConsensusGroupId)this.consensusGroupId), this.dataNodeLocation));
        } else {
            LOGGER.error(String.format("Create %s on DataNode: %s failed, %s", ConsensusGroupId.formatTConsensusGroupId((TConsensusGroupId)this.consensusGroupId), this.dataNodeLocation, tsStatus));
        }
        this.latch.countDown();
    }

    public void onError(Exception e) {
        LOGGER.error(String.format("Create %s on DataNode: %s failed, %s", ConsensusGroupId.formatTConsensusGroupId((TConsensusGroupId)this.consensusGroupId), this.dataNodeLocation, e));
        this.latch.countDown();
    }
}

