/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.client;

import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.ClientFactoryProperty;
import org.apache.iotdb.commons.client.ClientManager;
import org.apache.iotdb.commons.client.ClientPoolProperty;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.client.async.AsyncDataNodeInternalServiceClient;
import org.apache.iotdb.commons.client.sync.SyncDataNodeInternalServiceClient;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;

public class ConfigNodeClientPoolFactory {
    private static final ConfigNodeConfig conf = ConfigNodeDescriptor.getInstance().getConf();

    private ConfigNodeClientPoolFactory() {
    }

    public static class AsyncDataNodeInternalServiceClientPoolFactory
    implements IClientPoolFactory<TEndPoint, AsyncDataNodeInternalServiceClient> {
        public KeyedObjectPool<TEndPoint, AsyncDataNodeInternalServiceClient> createClientPool(ClientManager<TEndPoint, AsyncDataNodeInternalServiceClient> manager) {
            return new GenericKeyedObjectPool((KeyedPooledObjectFactory)new AsyncDataNodeInternalServiceClient.Factory(manager, new ClientFactoryProperty.Builder().setConnectionTimeoutMs(conf.getConnectionTimeoutInMS()).setRpcThriftCompressionEnabled(conf.isRpcThriftCompressionEnabled()).setSelectorNumOfAsyncClientManager(conf.getSelectorNumOfClientManager()).build()), new ClientPoolProperty.Builder().build().getConfig());
        }
    }

    public static class SyncDataNodeInternalServiceClientPoolFactory
    implements IClientPoolFactory<TEndPoint, SyncDataNodeInternalServiceClient> {
        public KeyedObjectPool<TEndPoint, SyncDataNodeInternalServiceClient> createClientPool(ClientManager<TEndPoint, SyncDataNodeInternalServiceClient> manager) {
            return new GenericKeyedObjectPool((KeyedPooledObjectFactory)new SyncDataNodeInternalServiceClient.Factory(manager, new ClientFactoryProperty.Builder().setConnectionTimeoutMs(conf.getConnectionTimeoutInMS()).setRpcThriftCompressionEnabled(conf.isRpcThriftCompressionEnabled()).setSelectorNumOfAsyncClientManager(conf.getSelectorNumOfClientManager()).build()), new ClientPoolProperty.Builder().build().getConfig());
        }
    }
}

