/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.transport.server;

import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.commons.service.ThriftService;
import org.apache.iotdb.commons.service.ThriftServiceThread;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.sync.transport.server.TransportServerManagerMBean;
import org.apache.iotdb.db.sync.transport.server.TransportServerThriftHandler;
import org.apache.iotdb.db.sync.transport.server.TransportServiceImpl;
import org.apache.iotdb.service.transport.thrift.TransportService;
import org.apache.thrift.server.TServerEventHandler;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportServerManager
extends ThriftService
implements Runnable,
TransportServerManagerMBean {
    private static final Logger logger = LoggerFactory.getLogger(TransportServerManager.class);
    private TransportServiceImpl serviceImpl;

    @Override
    public void run() {
        TransportServerManager serverManager = new TransportServerManager();
        try {
            serverManager.start();
        }
        catch (StartupException e) {
            e.printStackTrace();
        }
    }

    public static TransportServerManager getInstance() {
        return ServiceManagerHolder.INSTANCE;
    }

    public ServiceType getID() {
        return ServiceType.SYNC_SERVICE;
    }

    public void initTProcessor() {
        this.initSyncedServiceImpl(null);
        this.serviceImpl = new TransportServiceImpl();
        this.processor = new TransportService.Processor((TransportService.Iface)this.serviceImpl);
    }

    public void initThriftServiceThread() {
        IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
        this.thriftServiceThread = new ThriftServiceThread(this.processor, this.getID().getName(), ThreadName.SYNC_CLIENT.getName(), config.getRpcAddress(), config.getPipeServerPort(), Integer.MAX_VALUE, config.getThriftServerAwaitTimeForStopService(), (TServerEventHandler)new TransportServerThriftHandler(this.serviceImpl), config.isRpcThriftCompressionEnable());
        this.thriftServiceThread.setName(ThreadName.SYNC_SERVER.getName());
    }

    public String getBindIP() {
        return IoTDBDescriptor.getInstance().getConfig().getRpcAddress();
    }

    public int getBindPort() {
        return IoTDBDescriptor.getInstance().getConfig().getPipeServerPort();
    }

    @Override
    public int getRPCPort() {
        return this.getBindPort();
    }

    @Override
    public void startService() throws StartupException {
        super.startService();
    }

    @Override
    public void stopService() {
        super.stopService();
    }

    public static void main(String[] args) throws TTransportException, StartupException {
        logger.info("Transport server for testing only.");
        TransportServerManager serverManager = new TransportServerManager();
        serverManager.start();
    }

    private static class ServiceManagerHolder {
        private static final TransportServerManager INSTANCE = new TransportServerManager();

        private ServiceManagerHolder() {
        }
    }
}

