/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.sender.recovery;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.sys.CreatePipePlan;
import org.apache.iotdb.db.qp.physical.sys.CreatePipeSinkPlan;
import org.apache.iotdb.db.sync.conf.SyncPathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SenderLogger {
    private static final Logger logger = LoggerFactory.getLogger(SenderLogger.class);
    private BufferedWriter bw;

    private void getBufferedWriter() {
        try {
            if (this.bw != null) {
                return;
            }
            File senderLog = new File(SyncPathUtil.getSysDir(), "senderService.log");
            if (!senderLog.exists()) {
                if (!senderLog.getParentFile().exists()) {
                    senderLog.getParentFile().mkdirs();
                }
                senderLog.createNewFile();
            }
            this.bw = new BufferedWriter(new FileWriter(senderLog, true));
        }
        catch (IOException e) {
            logger.warn("Can not init sender logger.", (Throwable)e);
        }
    }

    public synchronized void addPipeSink(CreatePipeSinkPlan plan) {
        this.getBufferedWriter();
        try {
            this.bw.write(Operator.OperatorType.CREATE_PIPESINK.name());
            this.bw.newLine();
            this.bw.write(plan.toString());
            this.bw.newLine();
            this.bw.flush();
        }
        catch (IOException e) {
            logger.warn(String.format("Can not record add pipeSink %s.", plan.getPipeSinkName()), (Throwable)e);
        }
    }

    public synchronized void dropPipeSink(String pipeSinkName) {
        this.getBufferedWriter();
        try {
            this.bw.write(Operator.OperatorType.DROP_PIPESINK.name());
            this.bw.write("#");
            this.bw.write(pipeSinkName);
            this.bw.newLine();
            this.bw.flush();
        }
        catch (IOException e) {
            logger.warn(String.format("Can not record drop pipeSink %s.", pipeSinkName), (Throwable)e);
        }
    }

    public synchronized void addPipe(CreatePipePlan plan, long pipeCreateTime) {
        this.getBufferedWriter();
        try {
            this.bw.write(Operator.OperatorType.CREATE_PIPE.name());
            this.bw.write("#");
            this.bw.write(String.valueOf(pipeCreateTime));
            this.bw.newLine();
            this.bw.write(plan.toString());
            this.bw.newLine();
            this.bw.flush();
        }
        catch (IOException e) {
            logger.warn(String.format("Can not record add pipe %s.", plan.getPipeName()), (Throwable)e);
        }
    }

    public synchronized void operatePipe(String pipeName, Operator.OperatorType type) {
        this.getBufferedWriter();
        try {
            this.bw.write(type.name());
            this.bw.write("#");
            this.bw.write(pipeName);
            this.bw.newLine();
            this.bw.flush();
        }
        catch (IOException e) {
            logger.warn(String.format("Can not record %s %s.", type.name(), pipeName), (Throwable)e);
        }
    }

    public synchronized void recordMsg(String pipeName, Operator.OperatorType type, String msg) {
        this.getBufferedWriter();
        try {
            this.bw.write(type.name());
            this.bw.write("#");
            this.bw.write(pipeName);
            this.bw.write("#");
            this.bw.write(msg);
            this.bw.newLine();
            this.bw.flush();
        }
        catch (IOException e) {
            logger.warn(String.format("Record msg %s error.", msg), (Throwable)e);
        }
    }

    public synchronized void close() {
        try {
            if (this.bw != null) {
                this.bw.close();
            }
        }
        catch (IOException e) {
            logger.warn("Can not close sender log.", (Throwable)e);
        }
    }
}

