/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics.predefined;

import java.io.File;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.service.metrics.enums.Metric;
import org.apache.iotdb.db.service.metrics.enums.Tag;
import org.apache.iotdb.metrics.MetricManager;
import org.apache.iotdb.metrics.predefined.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.PredefinedMetric;

public class FileMetrics
implements IMetricSet {
    public void bindTo(MetricManager metricManager) {
        String[] walDirs = IoTDBDescriptor.getInstance().getConfig().getWalDirs();
        metricManager.getOrCreateAutoGauge(Metric.FILE_SIZE.toString(), MetricLevel.IMPORTANT, (Object)walDirs, value -> Stream.of(value).mapToLong(org.apache.iotdb.commons.utils.FileUtils::getDirSize).sum(), new String[]{Tag.NAME.toString(), "wal"});
        String[] dataDirs = IoTDBDescriptor.getInstance().getConfig().getDataDirs();
        metricManager.getOrCreateAutoGauge(Metric.FILE_SIZE.toString(), MetricLevel.IMPORTANT, (Object)dataDirs, value -> Stream.of(value).mapToLong(dir -> {
            dir = dir + File.separator + "sequence";
            return org.apache.iotdb.commons.utils.FileUtils.getDirSize((String)dir);
        }).sum(), new String[]{Tag.NAME.toString(), "seq"});
        metricManager.getOrCreateAutoGauge(Metric.FILE_SIZE.toString(), MetricLevel.IMPORTANT, (Object)dataDirs, value -> Stream.of(value).mapToLong(dir -> {
            dir = dir + File.separator + "unsequence";
            return org.apache.iotdb.commons.utils.FileUtils.getDirSize((String)dir);
        }).sum(), new String[]{Tag.NAME.toString(), "unseq"});
        metricManager.getOrCreateAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.IMPORTANT, (Object)walDirs, value -> Stream.of(value).mapToLong(dir -> {
            File walFolder = new File((String)dir);
            File[] walNodeFolders = walFolder.listFiles(File::isDirectory);
            long result = 0L;
            if (null != walNodeFolders) {
                for (File walNodeFolder : walNodeFolders) {
                    if (!walNodeFolder.exists() || !walNodeFolder.isDirectory()) continue;
                    result += (long)FileUtils.listFiles((File)walNodeFolder, null, (boolean)true).size();
                }
            }
            return result;
        }).sum(), new String[]{Tag.NAME.toString(), "wal"});
        metricManager.getOrCreateAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.IMPORTANT, (Object)dataDirs, value -> Stream.of(value).mapToLong(dir -> {
            File folder = new File(dir = dir + File.separator + "sequence");
            if (folder.exists()) {
                return FileUtils.listFiles((File)new File((String)dir), (String[])new String[]{"tsfile"}, (boolean)true).size();
            }
            return 0L;
        }).sum(), new String[]{Tag.NAME.toString(), "seq"});
        metricManager.getOrCreateAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.IMPORTANT, (Object)dataDirs, value -> Stream.of(value).mapToLong(dir -> {
            File folder = new File(dir = dir + File.separator + "unsequence");
            if (folder.exists()) {
                return FileUtils.listFiles((File)new File((String)dir), (String[])new String[]{"tsfile"}, (boolean)true).size();
            }
            return 0L;
        }).sum(), new String[]{Tag.NAME.toString(), "unseq"});
    }

    public PredefinedMetric getType() {
        return PredefinedMetric.FILE;
    }
}

