/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.AuthUtils;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.sys.AuthorOperator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;

public class AuthorPlan
extends PhysicalPlan {
    private AuthorOperator.AuthorType authorType;
    private String roleName;
    private String password;
    private String newPassword;
    private Set<Integer> permissions;
    private PartialPath nodeName;
    private String userName;

    public AuthorPlan(AuthorOperator.AuthorType authorType, String userName, String roleName, String password, String newPassword, String[] authorizationList, PartialPath nodeName) throws AuthException {
        super(Operator.OperatorType.AUTHOR);
        this.authorType = authorType;
        this.userName = userName;
        this.roleName = roleName;
        this.password = password;
        this.newPassword = newPassword;
        this.permissions = AuthUtils.strToPermissions((String[])authorizationList);
        this.nodeName = nodeName;
        switch (authorType) {
            case DROP_ROLE: {
                this.setOperatorType(Operator.OperatorType.DELETE_ROLE);
                break;
            }
            case DROP_USER: {
                this.setOperatorType(Operator.OperatorType.DELETE_USER);
                break;
            }
            case GRANT_ROLE: {
                this.setOperatorType(Operator.OperatorType.GRANT_ROLE_PRIVILEGE);
                break;
            }
            case GRANT_USER: {
                this.setOperatorType(Operator.OperatorType.GRANT_USER_PRIVILEGE);
                break;
            }
            case CREATE_ROLE: {
                this.setOperatorType(Operator.OperatorType.CREATE_ROLE);
                break;
            }
            case CREATE_USER: {
                this.setOperatorType(Operator.OperatorType.CREATE_USER);
                break;
            }
            case REVOKE_ROLE: {
                this.setOperatorType(Operator.OperatorType.REVOKE_ROLE_PRIVILEGE);
                break;
            }
            case REVOKE_USER: {
                this.setOperatorType(Operator.OperatorType.REVOKE_USER_PRIVILEGE);
                break;
            }
            case UPDATE_USER: {
                this.setOperatorType(Operator.OperatorType.MODIFY_PASSWORD);
                break;
            }
            case GRANT_ROLE_TO_USER: {
                this.setOperatorType(Operator.OperatorType.GRANT_ROLE_PRIVILEGE);
                break;
            }
            case REVOKE_ROLE_FROM_USER: {
                this.setOperatorType(Operator.OperatorType.REVOKE_USER_ROLE);
                break;
            }
            case LIST_USER_PRIVILEGE: {
                this.setQuery(true);
                this.setOperatorType(Operator.OperatorType.LIST_USER_PRIVILEGE);
                break;
            }
            case LIST_ROLE_PRIVILEGE: {
                this.setQuery(true);
                this.setOperatorType(Operator.OperatorType.LIST_ROLE_PRIVILEGE);
                break;
            }
            case LIST_USER_ROLES: {
                this.setQuery(true);
                this.setOperatorType(Operator.OperatorType.LIST_USER_ROLES);
                break;
            }
            case LIST_ROLE_USERS: {
                this.setQuery(true);
                this.setOperatorType(Operator.OperatorType.LIST_ROLE_USERS);
                break;
            }
            case LIST_USER: {
                this.setQuery(true);
                this.setOperatorType(Operator.OperatorType.LIST_USER);
                break;
            }
            case LIST_ROLE: {
                this.setQuery(true);
                this.setOperatorType(Operator.OperatorType.LIST_ROLE);
                break;
            }
        }
    }

    public AuthorPlan(Operator.OperatorType operatorType) throws IOException {
        super(operatorType);
        this.setAuthorType(this.transformOperatorTypeToAuthorType(operatorType));
    }

    private AuthorOperator.AuthorType transformOperatorTypeToAuthorType(Operator.OperatorType operatorType) throws IOException {
        AuthorOperator.AuthorType type;
        switch (operatorType) {
            case CREATE_ROLE: {
                type = AuthorOperator.AuthorType.CREATE_ROLE;
                break;
            }
            case DELETE_ROLE: {
                type = AuthorOperator.AuthorType.DROP_ROLE;
                break;
            }
            case CREATE_USER: {
                type = AuthorOperator.AuthorType.CREATE_USER;
                break;
            }
            case REVOKE_USER_ROLE: {
                type = AuthorOperator.AuthorType.REVOKE_ROLE_FROM_USER;
                break;
            }
            case REVOKE_ROLE_PRIVILEGE: {
                type = AuthorOperator.AuthorType.REVOKE_ROLE;
                break;
            }
            case REVOKE_USER_PRIVILEGE: {
                type = AuthorOperator.AuthorType.REVOKE_USER;
                break;
            }
            case GRANT_ROLE_PRIVILEGE: {
                type = AuthorOperator.AuthorType.GRANT_ROLE_TO_USER;
                break;
            }
            case GRANT_USER_PRIVILEGE: {
                type = AuthorOperator.AuthorType.GRANT_USER;
                break;
            }
            case GRANT_USER_ROLE: {
                type = AuthorOperator.AuthorType.GRANT_ROLE;
                break;
            }
            case MODIFY_PASSWORD: {
                type = AuthorOperator.AuthorType.UPDATE_USER;
                break;
            }
            case DELETE_USER: {
                type = AuthorOperator.AuthorType.DROP_USER;
                break;
            }
            default: {
                throw new IOException("unrecognized author type " + operatorType.name());
            }
        }
        return type;
    }

    public void setAuthorType(AuthorOperator.AuthorType type) {
        this.authorType = type;
    }

    public AuthorOperator.AuthorType getAuthorType() {
        return this.authorType;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public Set<Integer> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<Integer> permissions) {
        this.permissions = permissions;
    }

    public PartialPath getNodeName() {
        return this.nodeName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String toString() {
        return "userName: " + this.userName + "\nroleName: " + this.roleName + "\npassword: " + this.password + "\nnewPassword: " + this.newPassword + "\npermissions: " + this.permissions + "\nnodeName: " + this.nodeName + "\nauthorType: " + (Object)((Object)this.authorType);
    }

    public List<PartialPath> getPaths() {
        return this.nodeName != null ? Collections.singletonList(this.nodeName) : Collections.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuthorPlan)) {
            return false;
        }
        AuthorPlan that = (AuthorPlan)o;
        return this.getAuthorType() == that.getAuthorType() && Objects.equals(this.getUserName(), that.getUserName()) && Objects.equals(this.getRoleName(), that.getRoleName()) && Objects.equals(this.getPassword(), that.getPassword()) && Objects.equals(this.getNewPassword(), that.getNewPassword()) && Objects.equals(this.getPermissions(), that.getPermissions()) && Objects.equals(this.getNodeName(), that.getNodeName());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getAuthorType(), this.getUserName(), this.getRoleName(), this.getPassword(), this.getNewPassword(), this.getPermissions(), this.getNodeName()});
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        int type = this.getPlanType(super.getOperatorType());
        stream.writeByte((byte)type);
        stream.writeInt(this.authorType.ordinal());
        this.putString(stream, this.userName);
        this.putString(stream, this.roleName);
        this.putString(stream, this.password);
        this.putString(stream, this.newPassword);
        if (this.permissions == null) {
            stream.writeBoolean(false);
        } else {
            stream.writeBoolean(true);
            stream.writeInt(this.permissions.size());
            for (int permission : this.permissions) {
                stream.writeInt(permission);
            }
        }
        if (this.nodeName == null) {
            this.putString(stream, null);
        } else {
            this.putString(stream, this.nodeName.getFullPath());
        }
        stream.writeLong(this.index);
    }

    @Override
    public void serializeImpl(ByteBuffer buffer) {
        int type = this.getPlanType(super.getOperatorType());
        buffer.put((byte)type);
        buffer.putInt(this.authorType.ordinal());
        this.putString(buffer, this.userName);
        this.putString(buffer, this.roleName);
        this.putString(buffer, this.password);
        this.putString(buffer, this.newPassword);
        if (this.permissions == null) {
            buffer.put((byte)0);
        } else {
            buffer.put((byte)1);
            buffer.putInt(this.permissions.size());
            for (int permission : this.permissions) {
                buffer.putInt(permission);
            }
        }
        if (this.nodeName == null) {
            this.putString(buffer, null);
        } else {
            this.putString(buffer, this.nodeName.getFullPath());
        }
        buffer.putLong(this.index);
    }

    @Override
    public void deserialize(ByteBuffer buffer) throws IllegalPathException {
        this.authorType = AuthorOperator.AuthorType.values()[buffer.getInt()];
        this.userName = this.readString(buffer);
        this.roleName = this.readString(buffer);
        this.password = this.readString(buffer);
        this.newPassword = this.readString(buffer);
        byte hasPermissions = buffer.get();
        if (hasPermissions == 0) {
            this.permissions = null;
        } else {
            int permissionsSize = buffer.getInt();
            this.permissions = new HashSet<Integer>();
            for (int i = 0; i < permissionsSize; ++i) {
                this.permissions.add(buffer.getInt());
            }
        }
        String nodeNameStr = this.readString(buffer);
        this.nodeName = nodeNameStr == null ? null : new PartialPath(nodeNameStr);
        this.index = buffer.getLong();
    }

    private int getPlanType(Operator.OperatorType operatorType) {
        int type;
        switch (operatorType) {
            case CREATE_ROLE: {
                type = PhysicalPlan.PhysicalPlanType.CREATE_ROLE.ordinal();
                break;
            }
            case DELETE_ROLE: {
                type = PhysicalPlan.PhysicalPlanType.DELETE_ROLE.ordinal();
                break;
            }
            case CREATE_USER: {
                type = PhysicalPlan.PhysicalPlanType.CREATE_USER.ordinal();
                break;
            }
            case REVOKE_USER_ROLE: {
                type = PhysicalPlan.PhysicalPlanType.REVOKE_USER_ROLE.ordinal();
                break;
            }
            case REVOKE_ROLE_PRIVILEGE: {
                type = PhysicalPlan.PhysicalPlanType.REVOKE_ROLE_PRIVILEGE.ordinal();
                break;
            }
            case REVOKE_USER_PRIVILEGE: {
                type = PhysicalPlan.PhysicalPlanType.REVOKE_USER_PRIVILEGE.ordinal();
                break;
            }
            case GRANT_ROLE_PRIVILEGE: {
                type = PhysicalPlan.PhysicalPlanType.GRANT_ROLE_PRIVILEGE.ordinal();
                break;
            }
            case GRANT_USER_PRIVILEGE: {
                type = PhysicalPlan.PhysicalPlanType.GRANT_USER_PRIVILEGE.ordinal();
                break;
            }
            case GRANT_USER_ROLE: {
                type = PhysicalPlan.PhysicalPlanType.GRANT_USER_ROLE.ordinal();
                break;
            }
            case MODIFY_PASSWORD: {
                type = PhysicalPlan.PhysicalPlanType.MODIFY_PASSWORD.ordinal();
                break;
            }
            case DELETE_USER: {
                type = PhysicalPlan.PhysicalPlanType.DELETE_USER.ordinal();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operator: " + (Object)((Object)operatorType));
            }
        }
        return type;
    }
}

