/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.transformation.dag.builder;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.ResultColumn;
import org.apache.iotdb.db.mpp.transformation.api.LayerPointReader;
import org.apache.iotdb.db.mpp.transformation.dag.input.QueryDataSetInputLayer;
import org.apache.iotdb.db.mpp.transformation.dag.intermediate.IntermediateLayer;
import org.apache.iotdb.db.mpp.transformation.dag.memory.LayerMemoryAssigner;
import org.apache.iotdb.db.qp.physical.crud.UDTFPlan;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class DAGBuilder {
    private final long queryId;
    private final UDTFPlan udtfPlan;
    private final QueryDataSetInputLayer rawTimeSeriesInputLayer;
    private final Expression[] resultColumnExpressions;
    private final LayerPointReader[] resultColumnPointReaders;
    private final LayerMemoryAssigner memoryAssigner;
    private final Map<Expression, IntermediateLayer> expressionIntermediateLayerMap;
    private final Map<Expression, TSDataType> expressionDataTypeMap;

    public DAGBuilder(long queryId, UDTFPlan udtfPlan, QueryDataSetInputLayer inputLayer, float memoryBudgetInMB) {
        this.queryId = queryId;
        this.udtfPlan = udtfPlan;
        this.rawTimeSeriesInputLayer = inputLayer;
        int size = udtfPlan.getPathToIndex().size();
        this.resultColumnExpressions = new Expression[size];
        for (int i = 0; i < size; ++i) {
            this.resultColumnExpressions[i] = udtfPlan.getResultColumnByDatasetOutputIndex(i).getExpression();
        }
        this.resultColumnPointReaders = new LayerPointReader[size];
        this.memoryAssigner = new LayerMemoryAssigner(memoryBudgetInMB);
        this.expressionIntermediateLayerMap = new HashMap<Expression, IntermediateLayer>();
        this.expressionDataTypeMap = new HashMap<Expression, TSDataType>();
    }

    public DAGBuilder bindInputLayerColumnIndexWithExpression() {
        for (Expression expression : this.resultColumnExpressions) {
            expression.bindInputLayerColumnIndexWithExpression(this.udtfPlan);
        }
        return this;
    }

    public DAGBuilder buildLayerMemoryAssigner() {
        for (Expression expression : this.resultColumnExpressions) {
            expression.updateStatisticsForMemoryAssigner(this.memoryAssigner);
        }
        this.memoryAssigner.build();
        return this;
    }

    public DAGBuilder buildResultColumnPointReaders() throws QueryProcessException, IOException {
        for (int i = 0; i < this.resultColumnExpressions.length; ++i) {
            this.resultColumnPointReaders[i] = this.resultColumnExpressions[i].constructIntermediateLayer(this.queryId, this.udtfPlan.getUdtfContext(), this.rawTimeSeriesInputLayer, this.expressionIntermediateLayerMap, this.expressionDataTypeMap, this.memoryAssigner).constructPointReader();
        }
        return this;
    }

    public DAGBuilder setDataSetResultColumnDataTypes() {
        for (ResultColumn resultColumn : this.udtfPlan.getResultColumns()) {
            resultColumn.setDataType(this.expressionDataTypeMap.get(resultColumn.getExpression()));
        }
        return this;
    }

    public LayerPointReader[] getResultColumnPointReaders() {
        return this.resultColumnPointReaders;
    }
}

