/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.source;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.path.AlignedPath;
import org.apache.iotdb.db.metadata.path.PathDeserializeUtil;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeUtil;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.AggregationNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.SeriesAggregationSourceNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.AggregationDescriptor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.mpp.plan.statement.component.OrderBy;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterFactory;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class AlignedSeriesAggregationScanNode
extends SeriesAggregationSourceNode {
    private final AlignedPath alignedPath;
    private TRegionReplicaSet regionReplicaSet;

    public AlignedSeriesAggregationScanNode(PlanNodeId id, AlignedPath alignedPath, List<AggregationDescriptor> aggregationDescriptorList) {
        super(id, aggregationDescriptorList);
        this.alignedPath = alignedPath;
        this.aggregationDescriptorList = AggregationNode.getDeduplicatedDescriptors(aggregationDescriptorList);
    }

    public AlignedSeriesAggregationScanNode(PlanNodeId id, AlignedPath alignedPath, List<AggregationDescriptor> aggregationDescriptorList, OrderBy scanOrder, @Nullable GroupByTimeParameter groupByTimeParameter) {
        this(id, alignedPath, aggregationDescriptorList);
        this.scanOrder = scanOrder;
        this.groupByTimeParameter = groupByTimeParameter;
    }

    public AlignedSeriesAggregationScanNode(PlanNodeId id, AlignedPath alignedPath, List<AggregationDescriptor> aggregationDescriptorList, OrderBy scanOrder, @Nullable Filter timeFilter, @Nullable GroupByTimeParameter groupByTimeParameter, TRegionReplicaSet dataRegionReplicaSet) {
        this(id, alignedPath, aggregationDescriptorList, scanOrder, groupByTimeParameter);
        this.timeFilter = timeFilter;
        this.regionReplicaSet = dataRegionReplicaSet;
    }

    public AlignedPath getAlignedPath() {
        return this.alignedPath;
    }

    @Override
    public OrderBy getScanOrder() {
        return this.scanOrder;
    }

    @Override
    @Nullable
    public Filter getTimeFilter() {
        return this.timeFilter;
    }

    public void setTimeFilter(@Nullable Filter timeFilter) {
        this.timeFilter = timeFilter;
    }

    @Override
    @Nullable
    public GroupByTimeParameter getGroupByTimeParameter() {
        return this.groupByTimeParameter;
    }

    @Override
    public void open() throws Exception {
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return this.regionReplicaSet;
    }

    @Override
    public void setRegionReplicaSet(TRegionReplicaSet regionReplicaSet) {
        this.regionReplicaSet = regionReplicaSet;
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public List<PlanNode> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public void addChild(PlanNode child) {
        throw new UnsupportedOperationException("no child is allowed for AlignedSeriesAggregationScanNode");
    }

    @Override
    public PlanNode clone() {
        return new AlignedSeriesAggregationScanNode(this.getPlanNodeId(), this.getAlignedPath(), this.getAggregationDescriptorList(), this.getScanOrder(), this.getTimeFilter(), this.getGroupByTimeParameter(), this.getRegionReplicaSet());
    }

    @Override
    public List<String> getOutputColumnNames() {
        return this.aggregationDescriptorList.stream().map(AggregationDescriptor::getOutputColumnNames).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitAlignedSeriesAggregationScan(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.ALIGNED_SERIES_AGGREGATE_SCAN.serialize(byteBuffer);
        this.alignedPath.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.aggregationDescriptorList.size(), (ByteBuffer)byteBuffer);
        for (AggregationDescriptor aggregationDescriptor : this.aggregationDescriptorList) {
            aggregationDescriptor.serialize(byteBuffer);
        }
        ReadWriteIOUtils.write((int)this.scanOrder.ordinal(), (ByteBuffer)byteBuffer);
        if (this.timeFilter == null) {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
            this.timeFilter.serialize(byteBuffer);
        }
        if (this.groupByTimeParameter == null) {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
            this.groupByTimeParameter.serialize(byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.ALIGNED_SERIES_AGGREGATE_SCAN.serialize(stream);
        this.alignedPath.serialize(stream);
        ReadWriteIOUtils.write((int)this.aggregationDescriptorList.size(), (OutputStream)stream);
        for (AggregationDescriptor aggregationDescriptor : this.aggregationDescriptorList) {
            aggregationDescriptor.serialize(stream);
        }
        ReadWriteIOUtils.write((int)this.scanOrder.ordinal(), (OutputStream)stream);
        if (this.timeFilter == null) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            this.timeFilter.serialize(stream);
        }
        if (this.groupByTimeParameter == null) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            this.groupByTimeParameter.serialize(stream);
        }
    }

    public static AlignedSeriesAggregationScanNode deserialize(ByteBuffer byteBuffer) {
        AlignedPath alignedPath = (AlignedPath)PathDeserializeUtil.deserialize(byteBuffer);
        int aggregateDescriptorSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<AggregationDescriptor> aggregationDescriptorList = new ArrayList<AggregationDescriptor>();
        for (int i = 0; i < aggregateDescriptorSize; ++i) {
            aggregationDescriptorList.add(AggregationDescriptor.deserialize(byteBuffer));
        }
        OrderBy scanOrder = OrderBy.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        byte isNull = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
        Filter timeFilter = null;
        if (isNull == 1) {
            timeFilter = FilterFactory.deserialize((ByteBuffer)byteBuffer);
        }
        isNull = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
        GroupByTimeParameter groupByTimeParameter = null;
        if (isNull == 1) {
            groupByTimeParameter = GroupByTimeParameter.deserialize(byteBuffer);
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new AlignedSeriesAggregationScanNode(planNodeId, alignedPath, aggregationDescriptorList, scanOrder, timeFilter, groupByTimeParameter, null);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AlignedSeriesAggregationScanNode that = (AlignedSeriesAggregationScanNode)o;
        return this.alignedPath.equals((Object)that.alignedPath) && this.aggregationDescriptorList.equals(that.aggregationDescriptorList) && this.scanOrder == that.scanOrder && Objects.equals(this.timeFilter, that.timeFilter) && Objects.equals(this.groupByTimeParameter, that.groupByTimeParameter) && Objects.equals(this.regionReplicaSet, that.regionReplicaSet);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.alignedPath, this.aggregationDescriptorList, this.scanOrder, this.timeFilter, this.groupByTimeParameter, this.regionReplicaSet});
    }

    @Override
    public PartialPath getPartitionPath() {
        return this.alignedPath;
    }

    @Override
    public Filter getPartitionTimeFilter() {
        return this.timeFilter;
    }

    public String toString() {
        return String.format("AlignedSeriesAggregationScanNode-%s:[SeriesPath: %s, Descriptor: %s, DataRegion: %s]", this.getPlanNodeId(), this.getAlignedPath().getFormattedString(), this.getAggregationDescriptorList(), PlanNodeUtil.printRegionReplicaSet(this.getRegionReplicaSet()));
    }
}

