/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.process;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.ProcessNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.FilterNullParameter;
import org.apache.iotdb.db.mpp.plan.statement.component.FilterNullPolicy;

public class FilterNullNode
extends ProcessNode {
    private final FilterNullParameter filterNullParameter;
    private PlanNode child;

    public FilterNullNode(PlanNodeId id, FilterNullParameter filterNullParameter) {
        super(id);
        this.filterNullParameter = filterNullParameter;
    }

    public FilterNullNode(PlanNodeId id, FilterNullPolicy filterNullPolicy, List<Expression> filterNullColumns) {
        super(id);
        this.filterNullParameter = new FilterNullParameter(filterNullPolicy, filterNullColumns);
    }

    public FilterNullNode(PlanNodeId id, PlanNode child, FilterNullPolicy filterNullPolicy, List<Expression> filterNullColumns) {
        this(id, filterNullPolicy, filterNullColumns);
        this.child = child;
    }

    public FilterNullNode(PlanNodeId id, PlanNode child, FilterNullParameter filterNullParameter) {
        this(id, filterNullParameter);
        this.child = child;
    }

    @Override
    public List<PlanNode> getChildren() {
        return ImmutableList.of((Object)this.child);
    }

    @Override
    public void addChild(PlanNode child) {
        this.child = child;
    }

    @Override
    public int allowedChildCount() {
        return 1;
    }

    @Override
    public PlanNode clone() {
        return new FilterNullNode(this.getPlanNodeId(), this.filterNullParameter);
    }

    @Override
    public List<String> getOutputColumnNames() {
        return this.child.getOutputColumnNames();
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitFilterNull(this, context);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.FILTER_NULL.serialize(byteBuffer);
        this.filterNullParameter.serialize(byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.FILTER_NULL.serialize(stream);
        this.filterNullParameter.serialize(stream);
    }

    public static FilterNullNode deserialize(ByteBuffer byteBuffer) {
        FilterNullParameter filterNullParameter = FilterNullParameter.deserialize(byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new FilterNullNode(planNodeId, filterNullParameter);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FilterNullNode that = (FilterNullNode)o;
        return this.filterNullParameter.equals(that.filterNullParameter) && this.child.equals(that.child);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.filterNullParameter, this.child);
    }
}

