/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.common.header.HeaderConstant;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.metedata.read.SchemaQueryScanNode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class TimeSeriesCountNode
extends SchemaQueryScanNode {
    public TimeSeriesCountNode(PlanNodeId id, PartialPath partialPath, boolean isPrefixPath) {
        super(id, partialPath, isPrefixPath);
    }

    @Override
    public PlanNode clone() {
        return new TimeSeriesCountNode(this.getPlanNodeId(), this.path, this.isPrefixPath);
    }

    @Override
    public List<String> getOutputColumnNames() {
        return HeaderConstant.countTimeSeriesHeader.getRespColumns();
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.TIME_SERIES_COUNT.serialize(byteBuffer);
        ReadWriteIOUtils.write((String)this.path.getFullPath(), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.isPrefixPath, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.TIME_SERIES_COUNT.serialize(stream);
        ReadWriteIOUtils.write((String)this.path.getFullPath(), (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.isPrefixPath, (OutputStream)stream);
    }

    public static PlanNode deserialize(ByteBuffer buffer) {
        PartialPath path;
        String fullPath = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        try {
            path = new PartialPath(fullPath);
        }
        catch (IllegalPathException e) {
            throw new IllegalArgumentException("Cannot deserialize DevicesSchemaScanNode", e);
        }
        boolean isPrefixPath = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(buffer);
        return new TimeSeriesCountNode(planNodeId, path, isPrefixPath);
    }
}

