/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.Validate;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PlanNode
implements IConsensusRequest {
    private final Logger logger = LoggerFactory.getLogger(PlanNode.class);
    protected static final int NO_CHILD_ALLOWED = 0;
    protected static final int ONE_CHILD = 1;
    protected static final int CHILD_COUNT_NO_LIMIT = -1;
    private PlanNodeId id;

    public PlanNode(PlanNodeId id) {
        Objects.requireNonNull(id, "id is null");
        this.id = id;
    }

    public PlanNodeId getPlanNodeId() {
        return this.id;
    }

    public void setPlanNodeId(PlanNodeId id) {
        this.id = id;
    }

    public abstract List<PlanNode> getChildren();

    public abstract void addChild(PlanNode var1);

    public abstract PlanNode clone();

    public PlanNode cloneWithChildren(List<PlanNode> children) {
        Validate.isTrue((children == null || this.allowedChildCount() == -1 || children.size() == this.allowedChildCount() ? 1 : 0) != 0, (String)String.format("Child count is not correct for PlanNode. Expected: %d, Value: %d", this.allowedChildCount(), this.getChildrenCount(children)));
        PlanNode node = this.clone();
        if (children != null) {
            children.forEach(node::addChild);
        }
        return node;
    }

    private int getChildrenCount(List<PlanNode> children) {
        return children == null ? 0 : children.size();
    }

    public abstract int allowedChildCount();

    public abstract List<String> getOutputColumnNames();

    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitPlan(this, context);
    }

    public void serialize(ByteBuffer byteBuffer) {
        this.serializeAttributes(byteBuffer);
        this.id.serialize(byteBuffer);
        List<PlanNode> planNodes = this.getChildren();
        if (planNodes == null) {
            ReadWriteIOUtils.write((int)0, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((int)planNodes.size(), (ByteBuffer)byteBuffer);
            for (PlanNode planNode : planNodes) {
                planNode.serialize(byteBuffer);
            }
        }
    }

    public void serialize(DataOutputStream stream) throws IOException {
        this.serializeAttributes(stream);
        this.id.serialize(stream);
        List<PlanNode> planNodes = this.getChildren();
        if (planNodes == null) {
            ReadWriteIOUtils.write((int)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((int)planNodes.size(), (OutputStream)stream);
            for (PlanNode planNode : planNodes) {
                planNode.serialize(stream);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public ByteBuffer serializeToByteBuffer() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected abstract void serializeAttributes(ByteBuffer var1);

    protected abstract void serializeAttributes(DataOutputStream var1) throws IOException;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlanNode planNode = (PlanNode)o;
        return Objects.equals(this.id, planNode.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

