/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.expression.leaf;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.mpp.plan.analyze.TypeProvider;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.ExpressionType;
import org.apache.iotdb.db.mpp.plan.expression.leaf.LeafOperand;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.mpp.transformation.dag.input.QueryDataSetInputLayer;
import org.apache.iotdb.db.mpp.transformation.dag.intermediate.ConstantIntermediateLayer;
import org.apache.iotdb.db.mpp.transformation.dag.intermediate.IntermediateLayer;
import org.apache.iotdb.db.mpp.transformation.dag.memory.LayerMemoryAssigner;
import org.apache.iotdb.db.mpp.transformation.dag.udf.UDTFContext;
import org.apache.iotdb.db.qp.physical.crud.UDTFPlan;
import org.apache.iotdb.db.qp.utils.WildcardsRemover;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class ConstantOperand
extends LeafOperand {
    private final String valueString;
    private final TSDataType dataType;

    public ConstantOperand(TSDataType dataType, String valueString) {
        this.dataType = (TSDataType)Validate.notNull((Object)dataType);
        this.valueString = (String)Validate.notNull((Object)valueString);
    }

    public ConstantOperand(ByteBuffer byteBuffer) {
        this.dataType = TSDataType.deserializeFrom((ByteBuffer)byteBuffer);
        this.valueString = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
    }

    public TSDataType getDataType() {
        return this.dataType;
    }

    public String getValueString() {
        return this.valueString;
    }

    public boolean isNegativeNumber() {
        return !this.dataType.equals((Object)TSDataType.TEXT) && !this.dataType.equals((Object)TSDataType.BOOLEAN) && Double.parseDouble(this.valueString) < 0.0;
    }

    @Override
    public boolean isConstantOperandInternal() {
        return true;
    }

    @Override
    public void concat(List<PartialPath> prefixPaths, List<Expression> resultExpressions) {
        resultExpressions.add(this);
    }

    @Override
    public void removeWildcards(WildcardsRemover wildcardsRemover, List<Expression> resultExpressions) {
        resultExpressions.add(this);
    }

    @Override
    public void collectPaths(Set<PartialPath> pathSet) {
    }

    @Override
    public TSDataType inferTypes(TypeProvider typeProvider) {
        typeProvider.setType(this.toString(), this.dataType);
        return this.dataType;
    }

    @Override
    public void bindInputLayerColumnIndexWithExpression(UDTFPlan udtfPlan) {
    }

    @Override
    public void bindInputLayerColumnIndexWithExpression(Map<String, List<InputLocation>> inputLocations) {
    }

    @Override
    public void updateStatisticsForMemoryAssigner(LayerMemoryAssigner memoryAssigner) {
    }

    @Override
    public IntermediateLayer constructIntermediateLayer(long queryId, UDTFContext udtfContext, QueryDataSetInputLayer rawTimeSeriesInputLayer, Map<Expression, IntermediateLayer> expressionIntermediateLayerMap, Map<Expression, TSDataType> expressionDataTypeMap, LayerMemoryAssigner memoryAssigner) throws QueryProcessException {
        if (!expressionIntermediateLayerMap.containsKey(this)) {
            expressionDataTypeMap.put(this, this.getDataType());
            ConstantIntermediateLayer intermediateLayer = new ConstantIntermediateLayer(this, queryId, memoryAssigner.assign());
            expressionIntermediateLayerMap.put(this, intermediateLayer);
        }
        return expressionIntermediateLayerMap.get(this);
    }

    @Override
    public IntermediateLayer constructIntermediateLayer(long queryId, UDTFContext udtfContext, QueryDataSetInputLayer rawTimeSeriesInputLayer, Map<Expression, IntermediateLayer> expressionIntermediateLayerMap, TypeProvider typeProvider, LayerMemoryAssigner memoryAssigner) throws QueryProcessException, IOException {
        if (!expressionIntermediateLayerMap.containsKey(this)) {
            ConstantIntermediateLayer intermediateLayer = new ConstantIntermediateLayer(this, queryId, memoryAssigner.assign());
            expressionIntermediateLayerMap.put(this, intermediateLayer);
        }
        return expressionIntermediateLayerMap.get(this);
    }

    @Override
    public String getExpressionStringInternal() {
        return this.valueString;
    }

    @Override
    public ExpressionType getExpressionType() {
        return ExpressionType.CONSTANT;
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        this.dataType.serializeTo(byteBuffer);
        ReadWriteIOUtils.write((String)this.valueString, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        this.dataType.serializeTo(stream);
        ReadWriteIOUtils.write((String)this.valueString, (OutputStream)stream);
    }
}

