/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.analyze;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.sql.MeasurementNotExistException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.mpp.common.schematree.PathPatternTree;
import org.apache.iotdb.db.mpp.common.schematree.SchemaTree;
import org.apache.iotdb.db.mpp.plan.analyze.ExpressionUtils;
import org.apache.iotdb.db.mpp.plan.analyze.TypeProvider;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.ExpressionType;
import org.apache.iotdb.db.mpp.plan.expression.binary.BinaryExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.EqualToExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.GreaterEqualExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.GreaterThanExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LessEqualExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LessThanExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LogicAndExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.LogicOrExpression;
import org.apache.iotdb.db.mpp.plan.expression.binary.NonEqualExpression;
import org.apache.iotdb.db.mpp.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.LeafOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimestampOperand;
import org.apache.iotdb.db.mpp.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.InExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.IsNullExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.LikeExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.LogicNotExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.RegularExpression;
import org.apache.iotdb.db.mpp.plan.expression.unary.UnaryExpression;
import org.apache.iotdb.db.mpp.plan.statement.component.ResultColumn;
import org.apache.iotdb.tsfile.read.filter.TimeFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterFactory;
import org.apache.iotdb.tsfile.utils.Pair;

public class ExpressionAnalyzer {
    public static void checkIsAllMeasurement(Expression expression) {
        if (expression instanceof BinaryExpression) {
            ExpressionAnalyzer.checkIsAllMeasurement(((BinaryExpression)expression).getLeftExpression());
            ExpressionAnalyzer.checkIsAllMeasurement(((BinaryExpression)expression).getRightExpression());
        } else if (expression instanceof UnaryExpression) {
            ExpressionAnalyzer.checkIsAllMeasurement(((UnaryExpression)expression).getExpression());
        } else if (expression instanceof FunctionExpression) {
            for (Expression childExpression : expression.getExpressions()) {
                ExpressionAnalyzer.checkIsAllMeasurement(childExpression);
            }
        } else if (expression instanceof TimeSeriesOperand) {
            PartialPath path = ((TimeSeriesOperand)expression).getPath();
            if (path.getNodes().length > 1 || path.getFullPath().equals("**")) {
                throw new SemanticException("ALIGN BY DEVICE: the suffix paths can only be measurement or one-level wildcard");
            }
        } else if (!(expression instanceof TimestampOperand) && !(expression instanceof ConstantOperand)) {
            throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)expression.getExpressionType()));
        }
    }

    public static ResultColumn.ColumnType identifyOutputColumnType(Expression expression) {
        if (expression instanceof BinaryExpression) {
            ResultColumn.ColumnType leftType = ExpressionAnalyzer.identifyOutputColumnType(((BinaryExpression)expression).getLeftExpression());
            ResultColumn.ColumnType rightType = ExpressionAnalyzer.identifyOutputColumnType(((BinaryExpression)expression).getRightExpression());
            if (leftType == ResultColumn.ColumnType.RAW && rightType == ResultColumn.ColumnType.AGGREGATION || leftType == ResultColumn.ColumnType.AGGREGATION && rightType == ResultColumn.ColumnType.RAW) {
                throw new SemanticException("Raw data and aggregation result hybrid calculation is not supported.");
            }
            if (leftType == ResultColumn.ColumnType.CONSTANT && rightType == ResultColumn.ColumnType.CONSTANT) {
                throw new SemanticException("Constant column is not supported.");
            }
            if (leftType != ResultColumn.ColumnType.CONSTANT) {
                return leftType;
            }
            return rightType;
        }
        if (expression instanceof UnaryExpression) {
            return ExpressionAnalyzer.identifyOutputColumnType(((UnaryExpression)expression).getExpression());
        }
        if (expression instanceof FunctionExpression) {
            if (!expression.isBuiltInAggregationFunctionExpression()) {
                return ResultColumn.ColumnType.RAW;
            }
            for (Expression childExpression : expression.getExpressions()) {
                if (ExpressionAnalyzer.identifyOutputColumnType(childExpression) != ResultColumn.ColumnType.AGGREGATION) continue;
                throw new SemanticException("Aggregation results cannot be as input of the aggregation function.");
            }
            return ResultColumn.ColumnType.AGGREGATION;
        }
        if (expression instanceof TimeSeriesOperand || expression instanceof TimestampOperand) {
            return ResultColumn.ColumnType.RAW;
        }
        if (expression instanceof ConstantOperand) {
            return ResultColumn.ColumnType.CONSTANT;
        }
        throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)expression.getExpressionType()));
    }

    public static List<Expression> concatExpressionWithSuffixPaths(Expression expression, List<PartialPath> prefixPaths, PathPatternTree patternTree) {
        if (expression instanceof BinaryExpression) {
            List<Expression> leftExpressions = ExpressionAnalyzer.concatExpressionWithSuffixPaths(((BinaryExpression)expression).getLeftExpression(), prefixPaths, patternTree);
            List<Expression> rightExpressions = ExpressionAnalyzer.concatExpressionWithSuffixPaths(((BinaryExpression)expression).getRightExpression(), prefixPaths, patternTree);
            return ExpressionUtils.reconstructBinaryExpressions(expression.getExpressionType(), leftExpressions, rightExpressions);
        }
        if (expression instanceof UnaryExpression) {
            List<Expression> childExpressions = ExpressionAnalyzer.concatExpressionWithSuffixPaths(((UnaryExpression)expression).getExpression(), prefixPaths, patternTree);
            return ExpressionUtils.reconstructUnaryExpressions((UnaryExpression)expression, childExpressions);
        }
        if (expression instanceof FunctionExpression) {
            ArrayList extendedExpressions = new ArrayList();
            for (Expression suffixExpression : expression.getExpressions()) {
                extendedExpressions.add(ExpressionAnalyzer.concatExpressionWithSuffixPaths(suffixExpression, prefixPaths, patternTree));
            }
            ArrayList<List<Expression>> childExpressionsList = new ArrayList<List<Expression>>();
            ExpressionUtils.cartesianProduct(extendedExpressions, childExpressionsList, 0, new ArrayList());
            return ExpressionUtils.reconstructFunctionExpressions((FunctionExpression)expression, childExpressionsList);
        }
        if (expression instanceof TimeSeriesOperand) {
            PartialPath rawPath = ((TimeSeriesOperand)expression).getPath();
            ArrayList<PartialPath> actualPaths = new ArrayList<PartialPath>();
            if (rawPath.getFullPath().startsWith("root.")) {
                actualPaths.add(rawPath);
            } else {
                for (PartialPath prefixPath : prefixPaths) {
                    PartialPath concatPath = prefixPath.concatPath(rawPath);
                    patternTree.appendPathPattern(concatPath);
                    actualPaths.add(concatPath);
                }
            }
            return ExpressionUtils.reconstructTimeSeriesOperands(actualPaths);
        }
        if (expression instanceof TimestampOperand) {
            return Collections.singletonList(expression);
        }
        if (expression instanceof ConstantOperand) {
            return Collections.singletonList(expression);
        }
        throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)expression.getExpressionType()));
    }

    public static void constructPatternTreeFromExpression(Expression predicate, List<PartialPath> prefixPaths, PathPatternTree patternTree) {
        if (predicate instanceof BinaryExpression) {
            ExpressionAnalyzer.constructPatternTreeFromExpression(((BinaryExpression)predicate).getLeftExpression(), prefixPaths, patternTree);
            ExpressionAnalyzer.constructPatternTreeFromExpression(((BinaryExpression)predicate).getRightExpression(), prefixPaths, patternTree);
        } else if (predicate instanceof UnaryExpression) {
            ExpressionAnalyzer.constructPatternTreeFromExpression(((UnaryExpression)predicate).getExpression(), prefixPaths, patternTree);
        } else if (predicate instanceof FunctionExpression) {
            for (Expression suffixExpression : predicate.getExpressions()) {
                ExpressionAnalyzer.constructPatternTreeFromExpression(suffixExpression, prefixPaths, patternTree);
            }
        } else if (predicate instanceof TimeSeriesOperand) {
            PartialPath rawPath = ((TimeSeriesOperand)predicate).getPath();
            if (rawPath.getFullPath().startsWith("root.")) {
                patternTree.appendPathPattern(rawPath);
                return;
            }
            for (PartialPath prefixPath : prefixPaths) {
                PartialPath concatPath = prefixPath.concatPath(rawPath);
                patternTree.appendPathPattern(concatPath);
            }
        } else if (!(predicate instanceof TimestampOperand) && !(predicate instanceof ConstantOperand)) {
            throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)predicate.getExpressionType()));
        }
    }

    public static List<Expression> removeWildcardInExpression(Expression expression, SchemaTree schemaTree) {
        if (expression instanceof BinaryExpression) {
            List<Expression> leftExpressions = ExpressionAnalyzer.removeWildcardInExpression(((BinaryExpression)expression).getLeftExpression(), schemaTree);
            List<Expression> rightExpressions = ExpressionAnalyzer.removeWildcardInExpression(((BinaryExpression)expression).getRightExpression(), schemaTree);
            return ExpressionUtils.reconstructBinaryExpressions(expression.getExpressionType(), leftExpressions, rightExpressions);
        }
        if (expression instanceof UnaryExpression) {
            List<Expression> childExpressions = ExpressionAnalyzer.removeWildcardInExpression(((UnaryExpression)expression).getExpression(), schemaTree);
            return ExpressionUtils.reconstructUnaryExpressions((UnaryExpression)expression, childExpressions);
        }
        if (expression instanceof FunctionExpression) {
            ArrayList extendedExpressions = new ArrayList();
            for (Expression originExpression : expression.getExpressions()) {
                List<Expression> actualExpressions = ExpressionAnalyzer.removeWildcardInExpression(originExpression, schemaTree);
                if (actualExpressions.isEmpty()) {
                    return Collections.emptyList();
                }
                extendedExpressions.add(actualExpressions);
            }
            ArrayList<List<Expression>> childExpressionsList = new ArrayList<List<Expression>>();
            ExpressionUtils.cartesianProduct(extendedExpressions, childExpressionsList, 0, new ArrayList());
            return ExpressionUtils.reconstructFunctionExpressions((FunctionExpression)expression, childExpressionsList);
        }
        if (expression instanceof TimeSeriesOperand) {
            PartialPath path = ((TimeSeriesOperand)expression).getPath();
            List actualPaths = (List)schemaTree.searchMeasurementPaths((PartialPath)path).left;
            return ExpressionUtils.reconstructTimeSeriesOperands(actualPaths);
        }
        if (expression instanceof TimestampOperand) {
            return Collections.singletonList(expression);
        }
        if (expression instanceof ConstantOperand) {
            return Collections.singletonList(expression);
        }
        throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)expression.getExpressionType()));
    }

    public static List<Expression> removeWildcardInQueryFilter(Expression predicate, List<PartialPath> prefixPaths, SchemaTree schemaTree, TypeProvider typeProvider) {
        if (predicate instanceof BinaryExpression) {
            List<Expression> leftExpressions = ExpressionAnalyzer.removeWildcardInQueryFilter(((BinaryExpression)predicate).getLeftExpression(), prefixPaths, schemaTree, typeProvider);
            List<Expression> rightExpressions = ExpressionAnalyzer.removeWildcardInQueryFilter(((BinaryExpression)predicate).getRightExpression(), prefixPaths, schemaTree, typeProvider);
            if (predicate.getExpressionType() == ExpressionType.LOGIC_AND) {
                ArrayList<Expression> resultExpressions = new ArrayList<Expression>(leftExpressions);
                resultExpressions.addAll(rightExpressions);
                return resultExpressions;
            }
            return ExpressionUtils.reconstructBinaryExpressions(predicate.getExpressionType(), leftExpressions, rightExpressions);
        }
        if (predicate instanceof UnaryExpression) {
            List<Expression> childExpressions = ExpressionAnalyzer.removeWildcardInQueryFilter(((UnaryExpression)predicate).getExpression(), prefixPaths, schemaTree, typeProvider);
            return ExpressionUtils.reconstructUnaryExpressions((UnaryExpression)predicate, childExpressions);
        }
        if (predicate instanceof FunctionExpression) {
            if (predicate.isBuiltInAggregationFunctionExpression()) {
                throw new SemanticException("aggregate functions are not supported in WHERE clause");
            }
            ArrayList extendedExpressions = new ArrayList();
            for (Expression suffixExpression : predicate.getExpressions()) {
                extendedExpressions.add(ExpressionAnalyzer.removeWildcardInQueryFilter(suffixExpression, prefixPaths, schemaTree, typeProvider));
            }
            ArrayList<List<Expression>> childExpressionsList = new ArrayList<List<Expression>>();
            ExpressionUtils.cartesianProduct(extendedExpressions, childExpressionsList, 0, new ArrayList());
            return ExpressionUtils.reconstructFunctionExpressions((FunctionExpression)predicate, childExpressionsList);
        }
        if (predicate instanceof TimeSeriesOperand) {
            PartialPath filterPath = ((TimeSeriesOperand)predicate).getPath();
            ArrayList<PartialPath> concatPaths = new ArrayList<PartialPath>();
            if (!filterPath.getFirstNode().equals("root")) {
                prefixPaths.forEach(prefix -> concatPaths.add(prefix.concatPath(filterPath)));
            } else {
                concatPaths.add(filterPath);
            }
            ArrayList noStarPaths = new ArrayList();
            for (PartialPath concatPath : concatPaths) {
                List actualPaths = (List)schemaTree.searchMeasurementPaths((PartialPath)concatPath).left;
                if (actualPaths.size() == 0) {
                    throw new SemanticException(String.format("the path '%s' in WHERE clause does not exist", concatPath));
                }
                noStarPaths.addAll(actualPaths);
            }
            noStarPaths.forEach(path -> typeProvider.setType(path.getFullPath(), path.getSeriesType()));
            return ExpressionUtils.reconstructTimeSeriesOperands(noStarPaths);
        }
        if (predicate instanceof TimestampOperand) {
            return Collections.singletonList(predicate);
        }
        if (predicate instanceof ConstantOperand) {
            return Collections.singletonList(predicate);
        }
        throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)predicate.getExpressionType()));
    }

    public static List<Expression> concatDeviceAndRemoveWildcard(Expression expression, PartialPath devicePath, SchemaTree schemaTree, TypeProvider typeProvider) {
        if (expression instanceof BinaryExpression) {
            List<Expression> leftExpressions = ExpressionAnalyzer.concatDeviceAndRemoveWildcard(((BinaryExpression)expression).getLeftExpression(), devicePath, schemaTree, typeProvider);
            List<Expression> rightExpressions = ExpressionAnalyzer.concatDeviceAndRemoveWildcard(((BinaryExpression)expression).getRightExpression(), devicePath, schemaTree, typeProvider);
            return ExpressionUtils.reconstructBinaryExpressions(expression.getExpressionType(), leftExpressions, rightExpressions);
        }
        if (expression instanceof UnaryExpression) {
            List<Expression> childExpressions = ExpressionAnalyzer.concatDeviceAndRemoveWildcard(((UnaryExpression)expression).getExpression(), devicePath, schemaTree, typeProvider);
            return ExpressionUtils.reconstructUnaryExpressions((UnaryExpression)expression, childExpressions);
        }
        if (expression instanceof FunctionExpression) {
            ArrayList extendedExpressions = new ArrayList();
            for (Expression suffixExpression : expression.getExpressions()) {
                List<Expression> concatedExpression = ExpressionAnalyzer.concatDeviceAndRemoveWildcard(suffixExpression, devicePath, schemaTree, typeProvider);
                if (concatedExpression == null || concatedExpression.size() == 0) continue;
                extendedExpressions.add(concatedExpression);
            }
            ArrayList<List<Expression>> childExpressionsList = new ArrayList<List<Expression>>();
            ExpressionUtils.cartesianProduct(extendedExpressions, childExpressionsList, 0, new ArrayList());
            return ExpressionUtils.reconstructFunctionExpressions((FunctionExpression)expression, childExpressionsList);
        }
        if (expression instanceof TimeSeriesOperand) {
            PartialPath measurement = ((TimeSeriesOperand)expression).getPath();
            PartialPath concatPath = devicePath.concatPath(measurement);
            List actualPaths = (List)schemaTree.searchMeasurementPaths((PartialPath)concatPath).left;
            if (actualPaths.isEmpty()) {
                return new ArrayList<Expression>();
            }
            ArrayList noStarPaths = new ArrayList(actualPaths);
            noStarPaths.forEach(path -> typeProvider.setType(path.getFullPath(), path.getSeriesType()));
            return ExpressionUtils.reconstructTimeSeriesOperands(noStarPaths);
        }
        if (expression instanceof TimestampOperand) {
            return Collections.singletonList(expression);
        }
        if (expression instanceof ConstantOperand) {
            return Collections.singletonList(expression);
        }
        throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)expression.getExpressionType()));
    }

    public static List<Expression> removeWildcardInQueryFilterByDevice(Expression predicate, PartialPath devicePath, SchemaTree schemaTree, TypeProvider typeProvider) {
        if (predicate instanceof BinaryExpression) {
            List<Expression> leftExpressions = ExpressionAnalyzer.removeWildcardInQueryFilterByDevice(((BinaryExpression)predicate).getLeftExpression(), devicePath, schemaTree, typeProvider);
            List<Expression> rightExpressions = ExpressionAnalyzer.removeWildcardInQueryFilterByDevice(((BinaryExpression)predicate).getRightExpression(), devicePath, schemaTree, typeProvider);
            if (predicate.getExpressionType() == ExpressionType.LOGIC_AND) {
                ArrayList<Expression> resultExpressions = new ArrayList<Expression>(leftExpressions);
                resultExpressions.addAll(rightExpressions);
                return resultExpressions;
            }
            return ExpressionUtils.reconstructBinaryExpressions(predicate.getExpressionType(), leftExpressions, rightExpressions);
        }
        if (predicate instanceof UnaryExpression) {
            List<Expression> childExpressions = ExpressionAnalyzer.removeWildcardInQueryFilterByDevice(((UnaryExpression)predicate).getExpression(), devicePath, schemaTree, typeProvider);
            return ExpressionUtils.reconstructUnaryExpressions((UnaryExpression)predicate, childExpressions);
        }
        if (predicate instanceof FunctionExpression) {
            if (predicate.isBuiltInAggregationFunctionExpression()) {
                throw new SemanticException("aggregate functions are not supported in WHERE clause");
            }
            ArrayList extendedExpressions = new ArrayList();
            for (Expression suffixExpression : predicate.getExpressions()) {
                extendedExpressions.add(ExpressionAnalyzer.removeWildcardInQueryFilterByDevice(suffixExpression, devicePath, schemaTree, typeProvider));
            }
            ArrayList<List<Expression>> childExpressionsList = new ArrayList<List<Expression>>();
            ExpressionUtils.cartesianProduct(extendedExpressions, childExpressionsList, 0, new ArrayList());
            return ExpressionUtils.reconstructFunctionExpressions((FunctionExpression)predicate, childExpressionsList);
        }
        if (predicate instanceof TimeSeriesOperand) {
            PartialPath measurement = ((TimeSeriesOperand)predicate).getPath();
            PartialPath concatPath = devicePath.concatPath(measurement);
            List noStarPaths = (List)schemaTree.searchMeasurementPaths((PartialPath)concatPath).left;
            if (noStarPaths.size() == 0) {
                throw new MeasurementNotExistException(String.format("ALIGN BY DEVICE: Measurement '%s' does not exist in device '%s'", measurement, devicePath));
            }
            noStarPaths.forEach(path -> typeProvider.setType(path.getFullPath(), path.getSeriesType()));
            return ExpressionUtils.reconstructTimeSeriesOperands(noStarPaths);
        }
        if (predicate instanceof TimestampOperand) {
            return Collections.singletonList(predicate);
        }
        if (predicate instanceof ConstantOperand) {
            return Collections.singletonList(predicate);
        }
        throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)predicate.getExpressionType()));
    }

    public static Pair<Filter, Boolean> transformToGlobalTimeFilter(Expression predicate) {
        if (predicate instanceof LogicAndExpression) {
            Pair<Filter, Boolean> leftResultPair = ExpressionAnalyzer.transformToGlobalTimeFilter(((BinaryExpression)predicate).getLeftExpression());
            Pair<Filter, Boolean> rightResultPair = ExpressionAnalyzer.transformToGlobalTimeFilter(((BinaryExpression)predicate).getRightExpression());
            if (leftResultPair.left != null && rightResultPair.left != null) {
                return new Pair((Object)FilterFactory.and((Filter)((Filter)leftResultPair.left), (Filter)((Filter)rightResultPair.left)), (Object)((Boolean)leftResultPair.right != false || (Boolean)rightResultPair.right != false ? 1 : 0));
            }
            if (leftResultPair.left != null) {
                return new Pair(leftResultPair.left, (Object)true);
            }
            if (rightResultPair.left != null) {
                return new Pair(rightResultPair.left, (Object)true);
            }
            return new Pair(null, (Object)true);
        }
        if (predicate instanceof LogicOrExpression) {
            Pair<Filter, Boolean> leftResultPair = ExpressionAnalyzer.transformToGlobalTimeFilter(((BinaryExpression)predicate).getLeftExpression());
            Pair<Filter, Boolean> rightResultPair = ExpressionAnalyzer.transformToGlobalTimeFilter(((BinaryExpression)predicate).getRightExpression());
            if (leftResultPair.left != null && rightResultPair.left != null) {
                return new Pair((Object)FilterFactory.or((Filter)((Filter)leftResultPair.left), (Filter)((Filter)rightResultPair.left)), (Object)((Boolean)leftResultPair.right != false || (Boolean)rightResultPair.right != false ? 1 : 0));
            }
            return new Pair(null, (Object)true);
        }
        if (predicate instanceof LogicNotExpression) {
            Pair<Filter, Boolean> childResultPair = ExpressionAnalyzer.transformToGlobalTimeFilter(((UnaryExpression)predicate).getExpression());
            return new Pair((Object)FilterFactory.not((Filter)((Filter)childResultPair.left)), childResultPair.right);
        }
        if (predicate instanceof GreaterEqualExpression || predicate instanceof GreaterThanExpression || predicate instanceof LessEqualExpression || predicate instanceof LessThanExpression || predicate instanceof EqualToExpression || predicate instanceof NonEqualExpression) {
            Filter timeInLeftFilter = ExpressionUtils.constructTimeFilter(predicate.getExpressionType(), ((BinaryExpression)predicate).getLeftExpression(), ((BinaryExpression)predicate).getRightExpression());
            if (timeInLeftFilter != null) {
                return new Pair((Object)timeInLeftFilter, (Object)false);
            }
            Filter timeInRightFilter = ExpressionUtils.constructTimeFilter(predicate.getExpressionType(), ((BinaryExpression)predicate).getRightExpression(), ((BinaryExpression)predicate).getLeftExpression());
            if (timeInRightFilter != null) {
                return new Pair((Object)timeInRightFilter, (Object)false);
            }
            return new Pair(null, (Object)true);
        }
        if (predicate instanceof IsNullExpression) {
            return new Pair(null, (Object)true);
        }
        if (predicate instanceof InExpression) {
            Expression timeExpression = ((InExpression)predicate).getExpression();
            if (timeExpression instanceof TimestampOperand) {
                return new Pair((Object)TimeFilter.in(((InExpression)predicate).getValues().stream().map(Long::parseLong).collect(Collectors.toSet()), (boolean)((InExpression)predicate).isNotIn()), (Object)false);
            }
            return new Pair(null, (Object)true);
        }
        if (predicate instanceof LikeExpression || predicate instanceof RegularExpression) {
            return new Pair(null, (Object)true);
        }
        throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)predicate.getExpressionType()));
    }

    public static List<Expression> searchSourceExpressions(Expression expression, boolean isRawDataSource) {
        if (expression instanceof BinaryExpression) {
            ArrayList<Expression> resultExpressions = new ArrayList<Expression>();
            resultExpressions.addAll(ExpressionAnalyzer.searchSourceExpressions(((BinaryExpression)expression).getLeftExpression(), isRawDataSource));
            resultExpressions.addAll(ExpressionAnalyzer.searchSourceExpressions(((BinaryExpression)expression).getRightExpression(), isRawDataSource));
            return resultExpressions;
        }
        if (expression instanceof UnaryExpression) {
            return ExpressionAnalyzer.searchSourceExpressions(((UnaryExpression)expression).getExpression(), isRawDataSource);
        }
        if (expression instanceof FunctionExpression) {
            if (!isRawDataSource && expression.isBuiltInAggregationFunctionExpression()) {
                return Collections.singletonList(expression);
            }
            ArrayList<Expression> resultExpressions = new ArrayList<Expression>();
            for (Expression childExpression : expression.getExpressions()) {
                resultExpressions.addAll(ExpressionAnalyzer.searchSourceExpressions(childExpression, isRawDataSource));
            }
            return resultExpressions;
        }
        if (expression instanceof TimeSeriesOperand) {
            return Collections.singletonList(expression);
        }
        if (expression instanceof TimestampOperand || expression instanceof ConstantOperand) {
            return Collections.emptyList();
        }
        throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)expression.getExpressionType()));
    }

    public static List<Expression> searchAggregationExpressions(Expression expression) {
        if (expression instanceof BinaryExpression) {
            ArrayList<Expression> resultExpressions = new ArrayList<Expression>();
            resultExpressions.addAll(ExpressionAnalyzer.searchAggregationExpressions(((BinaryExpression)expression).getLeftExpression()));
            resultExpressions.addAll(ExpressionAnalyzer.searchAggregationExpressions(((BinaryExpression)expression).getRightExpression()));
            return resultExpressions;
        }
        if (expression instanceof UnaryExpression) {
            return ExpressionAnalyzer.searchAggregationExpressions(((UnaryExpression)expression).getExpression());
        }
        if (expression instanceof FunctionExpression) {
            if (expression.isBuiltInAggregationFunctionExpression()) {
                return Collections.singletonList(expression);
            }
            ArrayList<Expression> resultExpressions = new ArrayList<Expression>();
            for (Expression inputExpression : expression.getExpressions()) {
                resultExpressions.addAll(ExpressionAnalyzer.searchAggregationExpressions(inputExpression));
            }
            return resultExpressions;
        }
        if (expression instanceof LeafOperand) {
            return Collections.emptyList();
        }
        throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)expression.getExpressionType()));
    }

    public static void updateTypeProvider(Expression expression, TypeProvider typeProvider) {
        if (expression instanceof BinaryExpression) {
            ExpressionAnalyzer.updateTypeProvider(((BinaryExpression)expression).getLeftExpression(), typeProvider);
            ExpressionAnalyzer.updateTypeProvider(((BinaryExpression)expression).getRightExpression(), typeProvider);
        } else if (expression instanceof UnaryExpression) {
            ExpressionAnalyzer.updateTypeProvider(((UnaryExpression)expression).getExpression(), typeProvider);
        } else if (expression instanceof FunctionExpression) {
            for (Expression childExpression : expression.getExpressions()) {
                ExpressionAnalyzer.updateTypeProvider(childExpression, typeProvider);
            }
        } else if (expression instanceof TimeSeriesOperand) {
            PartialPath rawPath = ((TimeSeriesOperand)expression).getPath();
            typeProvider.setType(rawPath.isMeasurementAliasExists() ? rawPath.getFullPathWithAlias() : rawPath.getFullPath(), rawPath.getSeriesType());
        } else if (!(expression instanceof ConstantOperand) && !(expression instanceof TimestampOperand)) {
            throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)expression.getExpressionType()));
        }
    }

    public static Expression removeAliasFromExpression(Expression expression) {
        if (expression instanceof BinaryExpression) {
            Expression leftExpression = ExpressionAnalyzer.removeAliasFromExpression(((BinaryExpression)expression).getLeftExpression());
            Expression rightExpression = ExpressionAnalyzer.removeAliasFromExpression(((BinaryExpression)expression).getRightExpression());
            return ExpressionUtils.reconstructBinaryExpressions(expression.getExpressionType(), Collections.singletonList(leftExpression), Collections.singletonList(rightExpression)).get(0);
        }
        if (expression instanceof UnaryExpression) {
            Expression childExpression = ExpressionAnalyzer.removeAliasFromExpression(((UnaryExpression)expression).getExpression());
            return ExpressionUtils.reconstructUnaryExpressions((UnaryExpression)expression, Collections.singletonList(childExpression)).get(0);
        }
        if (expression instanceof FunctionExpression) {
            FunctionExpression functionExpression = (FunctionExpression)expression;
            ArrayList<Expression> childExpressions = new ArrayList<Expression>();
            for (Expression suffixExpression : expression.getExpressions()) {
                childExpressions.add(ExpressionAnalyzer.removeAliasFromExpression(suffixExpression));
            }
            return new FunctionExpression(functionExpression.getFunctionName().toLowerCase(), functionExpression.getFunctionAttributes(), childExpressions);
        }
        if (expression instanceof TimeSeriesOperand) {
            MeasurementPath rawPath = (MeasurementPath)((TimeSeriesOperand)expression).getPath();
            if (rawPath.isMeasurementAliasExists()) {
                MeasurementPath newPath = new MeasurementPath(rawPath, rawPath.getMeasurementSchema());
                newPath.setUnderAlignedEntity(rawPath.isUnderAlignedEntity());
                return new TimeSeriesOperand(newPath);
            }
            return expression;
        }
        if (expression instanceof ConstantOperand || expression instanceof TimestampOperand) {
            return expression;
        }
        throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)expression.getExpressionType()));
    }

    public static boolean checkIsNeedTransform(Expression expression) {
        if (expression instanceof BinaryExpression) {
            return true;
        }
        if (expression instanceof UnaryExpression) {
            return true;
        }
        if (expression instanceof FunctionExpression) {
            return !expression.isBuiltInAggregationFunctionExpression();
        }
        if (expression instanceof TimeSeriesOperand) {
            return false;
        }
        throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)expression.getExpressionType()));
    }

    public static String getDeviceNameInSourceExpression(Expression expression) {
        if (expression instanceof BinaryExpression) {
            String leftDeviceName = ExpressionAnalyzer.getDeviceNameInSourceExpression(((BinaryExpression)expression).getLeftExpression());
            if (leftDeviceName != null) {
                return leftDeviceName;
            }
            return ExpressionAnalyzer.getDeviceNameInSourceExpression(((BinaryExpression)expression).getRightExpression());
        }
        if (expression instanceof UnaryExpression) {
            return ExpressionAnalyzer.getDeviceNameInSourceExpression(((UnaryExpression)expression).getExpression());
        }
        if (expression instanceof TimeSeriesOperand) {
            return ((TimeSeriesOperand)expression).getPath().getDevice();
        }
        if (expression instanceof FunctionExpression) {
            return ExpressionAnalyzer.getDeviceNameInSourceExpression(expression.getExpressions().get(0));
        }
        if (expression instanceof ConstantOperand || expression instanceof TimestampOperand) {
            return null;
        }
        throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)expression.getExpressionType()));
    }

    public static Expression getMeasurementExpression(Expression expression) {
        if (expression instanceof BinaryExpression) {
            Expression leftExpression = ExpressionAnalyzer.getMeasurementExpression(((BinaryExpression)expression).getLeftExpression());
            Expression rightExpression = ExpressionAnalyzer.getMeasurementExpression(((BinaryExpression)expression).getRightExpression());
            return ExpressionUtils.reconstructBinaryExpressions(expression.getExpressionType(), Collections.singletonList(leftExpression), Collections.singletonList(rightExpression)).get(0);
        }
        if (expression instanceof UnaryExpression) {
            Expression childExpression = ExpressionAnalyzer.getMeasurementExpression(((UnaryExpression)expression).getExpression());
            return ExpressionUtils.reconstructUnaryExpressions((UnaryExpression)expression, Collections.singletonList(childExpression)).get(0);
        }
        if (expression instanceof FunctionExpression) {
            ArrayList<Expression> childExpressions = new ArrayList<Expression>();
            for (Expression suffixExpression : expression.getExpressions()) {
                childExpressions.add(ExpressionAnalyzer.getMeasurementExpression(suffixExpression));
            }
            return new FunctionExpression(((FunctionExpression)expression).getFunctionName(), ((FunctionExpression)expression).getFunctionAttributes(), childExpressions);
        }
        if (expression instanceof TimeSeriesOperand) {
            MeasurementPath rawPath = (MeasurementPath)((TimeSeriesOperand)expression).getPath();
            PartialPath measurement = new PartialPath(rawPath.getMeasurement(), false);
            MeasurementPath measurementWithSchema = new MeasurementPath(measurement, rawPath.getMeasurementSchema());
            return new TimeSeriesOperand(measurementWithSchema);
        }
        if (expression instanceof TimestampOperand || expression instanceof ConstantOperand) {
            return expression;
        }
        throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)expression.getExpressionType()));
    }
}

