/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.analyze;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.commons.partition.SchemaPartition;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.common.header.DatasetHeader;
import org.apache.iotdb.db.mpp.common.schematree.SchemaTree;
import org.apache.iotdb.db.mpp.plan.analyze.QueryType;
import org.apache.iotdb.db.mpp.plan.analyze.TypeProvider;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.FillDescriptor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.FilterNullParameter;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public class Analysis {
    private Statement statement;
    private QueryType queryType;
    private DataPartition dataPartition;
    private SchemaPartition schemaPartition;
    private SchemaTree schemaTree;
    private TypeProvider typeProvider;
    private boolean finishQueryAfterAnalyze = false;
    private Set<Expression> sourceExpressions;
    private Set<Expression> aggregationTransformExpressions;
    private Set<Expression> aggregationExpressions;
    private Set<Expression> transformExpressions;
    private Expression queryFilter;
    private Map<Expression, Set<Expression>> groupByLevelExpressions;
    private Map<Expression, Expression> rawPathToGroupedPathMap;
    private boolean isRawDataSource;
    private Map<String, Set<Expression>> deviceToSourceExpressions;
    private Map<String, Set<Expression>> deviceToAggregationTransformExpressions;
    private Map<String, Set<Expression>> deviceToAggregationExpressions;
    private Map<String, Set<Expression>> deviceToTransformExpressions;
    private Map<String, Expression> deviceToQueryFilter;
    private Map<String, List<Integer>> deviceToMeasurementIndexesMap;
    private Map<String, Boolean> deviceToIsRawDataSource;
    private boolean hasValueFilter = false;
    private boolean isHasRawDataInputAggregation;
    private Filter globalTimeFilter;
    private FilterNullParameter filterNullParameter;
    private FillDescriptor fillDescriptor;
    private GroupByTimeParameter groupByTimeParameter;
    private DatasetHeader respDatasetHeader;
    private Set<String> matchedNodes;

    public List<TRegionReplicaSet> getPartitionInfo(PartialPath seriesPath, Filter timefilter) {
        return this.dataPartition.getDataRegionReplicaSet(seriesPath.getDevice(), null);
    }

    public List<TRegionReplicaSet> getPartitionInfo(String deviceName, Filter globalTimeFilter) {
        return this.dataPartition.getDataRegionReplicaSet(deviceName, null);
    }

    public Statement getStatement() {
        return this.statement;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }

    public DataPartition getDataPartitionInfo() {
        return this.dataPartition;
    }

    public void setDataPartitionInfo(DataPartition dataPartition) {
        this.dataPartition = dataPartition;
    }

    public SchemaPartition getSchemaPartitionInfo() {
        return this.schemaPartition;
    }

    public void setSchemaPartitionInfo(SchemaPartition schemaPartition) {
        this.schemaPartition = schemaPartition;
    }

    public SchemaTree getSchemaTree() {
        return this.schemaTree;
    }

    public void setSchemaTree(SchemaTree schemaTree) {
        this.schemaTree = schemaTree;
    }

    public Filter getGlobalTimeFilter() {
        return this.globalTimeFilter;
    }

    public void setGlobalTimeFilter(Filter timeFilter) {
        this.globalTimeFilter = timeFilter;
    }

    public DatasetHeader getRespDatasetHeader() {
        return this.respDatasetHeader;
    }

    public void setRespDatasetHeader(DatasetHeader respDatasetHeader) {
        this.respDatasetHeader = respDatasetHeader;
    }

    public TypeProvider getTypeProvider() {
        return this.typeProvider;
    }

    public void setTypeProvider(TypeProvider typeProvider) {
        this.typeProvider = typeProvider;
    }

    public boolean hasDataSource() {
        return this.dataPartition != null && !this.dataPartition.isEmpty() || this.schemaPartition != null && !this.schemaPartition.isEmpty();
    }

    public boolean isHasRawDataInputAggregation() {
        return this.isHasRawDataInputAggregation;
    }

    public void setHasRawDataInputAggregation(boolean hasRawDataInputAggregation) {
        this.isHasRawDataInputAggregation = hasRawDataInputAggregation;
    }

    public Map<Expression, Set<Expression>> getGroupByLevelExpressions() {
        return this.groupByLevelExpressions;
    }

    public void setGroupByLevelExpressions(Map<Expression, Set<Expression>> groupByLevelExpressions) {
        this.groupByLevelExpressions = groupByLevelExpressions;
    }

    public void setRawPathToGroupedPathMap(Map<Expression, Expression> rawPathToGroupedPathMap) {
        this.rawPathToGroupedPathMap = rawPathToGroupedPathMap;
    }

    public Expression getGroupedExpressionByLevel(Expression expression) {
        if (this.rawPathToGroupedPathMap.containsKey(expression)) {
            return this.rawPathToGroupedPathMap.get(expression);
        }
        if (this.rawPathToGroupedPathMap.containsValue(expression)) {
            return expression;
        }
        throw new IllegalArgumentException(String.format("GROUP BY LEVEL: Unknown input expression '%s'", expression));
    }

    public FilterNullParameter getFilterNullParameter() {
        return this.filterNullParameter;
    }

    public void setFilterNullParameter(FilterNullParameter filterNullParameter) {
        this.filterNullParameter = filterNullParameter;
    }

    public FillDescriptor getFillDescriptor() {
        return this.fillDescriptor;
    }

    public void setFillDescriptor(FillDescriptor fillDescriptor) {
        this.fillDescriptor = fillDescriptor;
    }

    public boolean hasValueFilter() {
        return this.hasValueFilter;
    }

    public void setHasValueFilter(boolean hasValueFilter) {
        this.hasValueFilter = hasValueFilter;
    }

    public Expression getQueryFilter() {
        return this.queryFilter;
    }

    public void setQueryFilter(Expression queryFilter) {
        this.queryFilter = queryFilter;
    }

    public Map<String, Expression> getDeviceToQueryFilter() {
        return this.deviceToQueryFilter;
    }

    public void setDeviceToQueryFilter(Map<String, Expression> deviceToQueryFilter) {
        this.deviceToQueryFilter = deviceToQueryFilter;
    }

    public GroupByTimeParameter getGroupByTimeParameter() {
        return this.groupByTimeParameter;
    }

    public void setGroupByTimeParameter(GroupByTimeParameter groupByTimeParameter) {
        this.groupByTimeParameter = groupByTimeParameter;
    }

    public boolean isFinishQueryAfterAnalyze() {
        return this.finishQueryAfterAnalyze;
    }

    public void setFinishQueryAfterAnalyze(boolean finishQueryAfterAnalyze) {
        this.finishQueryAfterAnalyze = finishQueryAfterAnalyze;
    }

    public void setDeviceToMeasurementIndexesMap(Map<String, List<Integer>> deviceToMeasurementIndexesMap) {
        this.deviceToMeasurementIndexesMap = deviceToMeasurementIndexesMap;
    }

    public Map<String, List<Integer>> getDeviceToMeasurementIndexesMap() {
        return this.deviceToMeasurementIndexesMap;
    }

    public Set<Expression> getSourceExpressions() {
        return this.sourceExpressions;
    }

    public void setSourceExpressions(Set<Expression> sourceExpressions) {
        this.sourceExpressions = sourceExpressions;
    }

    public Set<Expression> getAggregationTransformExpressions() {
        return this.aggregationTransformExpressions;
    }

    public void setAggregationTransformExpressions(Set<Expression> aggregationTransformExpressions) {
        this.aggregationTransformExpressions = aggregationTransformExpressions;
    }

    public Set<Expression> getAggregationExpressions() {
        return this.aggregationExpressions;
    }

    public void setAggregationExpressions(Set<Expression> aggregationExpressions) {
        this.aggregationExpressions = aggregationExpressions;
    }

    public Set<Expression> getTransformExpressions() {
        return this.transformExpressions;
    }

    public void setTransformExpressions(Set<Expression> transformExpressions) {
        this.transformExpressions = transformExpressions;
    }

    public Map<String, Set<Expression>> getDeviceToSourceExpressions() {
        return this.deviceToSourceExpressions;
    }

    public void setDeviceToSourceExpressions(Map<String, Set<Expression>> deviceToSourceExpressions) {
        this.deviceToSourceExpressions = deviceToSourceExpressions;
    }

    public Map<String, Set<Expression>> getDeviceToAggregationTransformExpressions() {
        return this.deviceToAggregationTransformExpressions;
    }

    public void setDeviceToAggregationTransformExpressions(Map<String, Set<Expression>> deviceToAggregationTransformExpressions) {
        this.deviceToAggregationTransformExpressions = deviceToAggregationTransformExpressions;
    }

    public Map<String, Set<Expression>> getDeviceToAggregationExpressions() {
        return this.deviceToAggregationExpressions;
    }

    public void setDeviceToAggregationExpressions(Map<String, Set<Expression>> deviceToAggregationExpressions) {
        this.deviceToAggregationExpressions = deviceToAggregationExpressions;
    }

    public Map<String, Set<Expression>> getDeviceToTransformExpressions() {
        return this.deviceToTransformExpressions;
    }

    public void setDeviceToTransformExpressions(Map<String, Set<Expression>> deviceToTransformExpressions) {
        this.deviceToTransformExpressions = deviceToTransformExpressions;
    }

    public boolean isRawDataSource() {
        return this.isRawDataSource;
    }

    public void setRawDataSource(boolean rawDataSource) {
        this.isRawDataSource = rawDataSource;
    }

    public Map<String, Boolean> getDeviceToIsRawDataSource() {
        return this.deviceToIsRawDataSource;
    }

    public void setDeviceToIsRawDataSource(Map<String, Boolean> deviceToIsRawDataSource) {
        this.deviceToIsRawDataSource = deviceToIsRawDataSource;
    }

    public Set<String> getMatchedNodes() {
        return this.matchedNodes;
    }

    public void setMatchedNodes(Set<String> matchedNodes) {
        this.matchedNodes = matchedNodes;
    }
}

