/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.schedule;

import io.airlift.concurrent.SetThreadName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.mpp.common.FragmentInstanceId;
import org.apache.iotdb.db.mpp.common.QueryId;
import org.apache.iotdb.db.mpp.execution.driver.IDriver;
import org.apache.iotdb.db.mpp.execution.exchange.IMPPDataExchangeManager;
import org.apache.iotdb.db.mpp.execution.exchange.MPPDataExchangeService;
import org.apache.iotdb.db.mpp.execution.schedule.AbstractDriverThread;
import org.apache.iotdb.db.mpp.execution.schedule.DriverTaskThread;
import org.apache.iotdb.db.mpp.execution.schedule.DriverTaskTimeoutSentinelThread;
import org.apache.iotdb.db.mpp.execution.schedule.ExecutionContext;
import org.apache.iotdb.db.mpp.execution.schedule.FragmentInstanceAbortedException;
import org.apache.iotdb.db.mpp.execution.schedule.IDriverScheduler;
import org.apache.iotdb.db.mpp.execution.schedule.ITaskScheduler;
import org.apache.iotdb.db.mpp.execution.schedule.queue.IndexedBlockingQueue;
import org.apache.iotdb.db.mpp.execution.schedule.queue.L1PriorityQueue;
import org.apache.iotdb.db.mpp.execution.schedule.queue.L2PriorityQueue;
import org.apache.iotdb.db.mpp.execution.schedule.task.DriverTask;
import org.apache.iotdb.db.mpp.execution.schedule.task.DriverTaskID;
import org.apache.iotdb.db.mpp.execution.schedule.task.DriverTaskStatus;
import org.apache.iotdb.mpp.rpc.thrift.TFragmentInstanceId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverScheduler
implements IDriverScheduler,
IService {
    private static final Logger logger = LoggerFactory.getLogger(DriverScheduler.class);
    private final IndexedBlockingQueue<DriverTask> readyQueue = new L2PriorityQueue<DriverTask>(MAX_CAPACITY, new DriverTask.SchedulePriorityComparator(), new DriverTask());
    private final IndexedBlockingQueue<DriverTask> timeoutQueue = new L1PriorityQueue<DriverTask>(MAX_CAPACITY, new DriverTask.TimeoutComparator(), new DriverTask());
    private final Set<DriverTask> blockedTasks;
    private final Map<QueryId, Set<DriverTask>> queryMap = new ConcurrentHashMap<QueryId, Set<DriverTask>>();
    private final ITaskScheduler scheduler;
    private IMPPDataExchangeManager blockManager;
    private static final int MAX_CAPACITY = IoTDBDescriptor.getInstance().getConfig().getMaxAllowedConcurrentQueries();
    private static final int WORKER_THREAD_NUM = IoTDBDescriptor.getInstance().getConfig().getConcurrentQueryThread();
    private static final int QUERY_TIMEOUT_MS = IoTDBDescriptor.getInstance().getConfig().getQueryTimeoutThreshold();
    private final ThreadGroup workerGroups;
    private final List<AbstractDriverThread> threads;

    public static DriverScheduler getInstance() {
        return InstanceHolder.instance;
    }

    private DriverScheduler() {
        this.blockedTasks = Collections.synchronizedSet(new HashSet());
        this.scheduler = new Scheduler();
        this.workerGroups = new ThreadGroup("ScheduleThreads");
        this.threads = new ArrayList<AbstractDriverThread>();
        this.blockManager = MPPDataExchangeService.getInstance().getMPPDataExchangeManager();
    }

    public void start() throws StartupException {
        for (int i = 0; i < WORKER_THREAD_NUM; ++i) {
            DriverTaskThread t = new DriverTaskThread("Worker-Thread-" + i, this.workerGroups, this.readyQueue, this.scheduler);
            this.threads.add(t);
            t.start();
        }
        DriverTaskTimeoutSentinelThread t = new DriverTaskTimeoutSentinelThread("Sentinel-Thread", this.workerGroups, this.timeoutQueue, this.scheduler);
        this.threads.add(t);
        t.start();
    }

    public void stop() {
        this.threads.forEach(t -> {
            try {
                t.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    public ServiceType getID() {
        return ServiceType.FRAGMENT_INSTANCE_MANAGER_SERVICE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submitDrivers(QueryId queryId, List<IDriver> instances) {
        List tasks = instances.stream().map(v -> new DriverTask((IDriver)v, QUERY_TIMEOUT_MS, DriverTaskStatus.READY)).collect(Collectors.toList());
        this.queryMap.computeIfAbsent(queryId, v -> Collections.synchronizedSet(new HashSet())).addAll(tasks);
        for (DriverTask task : tasks) {
            task.lock();
            try {
                if (task.getStatus() != DriverTaskStatus.READY) continue;
                this.timeoutQueue.push(task);
                this.readyQueue.push(task);
            }
            finally {
                task.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortQuery(QueryId queryId) {
        Set<DriverTask> queryRelatedTasks = this.queryMap.remove(queryId);
        if (queryRelatedTasks != null) {
            for (DriverTask task : queryRelatedTasks) {
                task.lock();
                try {
                    task.setAbortCause("query cascading aborted");
                    this.clearDriverTask(task);
                }
                finally {
                    task.unlock();
                }
            }
        }
    }

    @Override
    public void abortFragmentInstance(FragmentInstanceId instanceId) {
        DriverTask task = this.timeoutQueue.get((DriverTask)((Object)new DriverTaskID(instanceId)));
        if (task == null) {
            return;
        }
        task.lock();
        try {
            task.setAbortCause("fragment abort called");
            this.clearDriverTask(task);
        }
        finally {
            task.unlock();
        }
    }

    @Override
    public double getSchedulePriority(FragmentInstanceId instanceId) {
        DriverTask task = this.timeoutQueue.get((DriverTask)((Object)new DriverTaskID(instanceId)));
        if (task == null) {
            throw new IllegalStateException("the fragmentInstance " + instanceId.getFullId() + " has been cleared");
        }
        return task.getSchedulePriority();
    }

    private void clearDriverTask(DriverTask task) {
        try (SetThreadName fragmentInstanceName = new SetThreadName(task.getFragmentInstance().getInfo().getFullId(), new Object[0]);){
            if (task.getStatus() != DriverTaskStatus.FINISHED) {
                task.setStatus(DriverTaskStatus.ABORTED);
            }
            this.readyQueue.remove((DriverTask)((Object)task.getId()));
            this.timeoutQueue.remove((DriverTask)((Object)task.getId()));
            this.blockedTasks.remove(task);
            Set<DriverTask> tasks = this.queryMap.get(task.getId().getQueryId());
            if (tasks != null) {
                tasks.remove(task);
                if (tasks.isEmpty()) {
                    this.queryMap.remove(task.getId().getQueryId());
                }
            }
            if (task.getAbortCause() != null) {
                try {
                    task.getFragmentInstance().failed(new FragmentInstanceAbortedException(task.getFragmentInstance().getInfo(), task.getAbortCause()));
                }
                catch (Exception e) {
                    logger.error("Clear DriverTask failed", (Throwable)e);
                }
            }
            if (task.getStatus() == DriverTaskStatus.ABORTED) {
                try {
                    this.blockManager.forceDeregisterFragmentInstance(new TFragmentInstanceId(task.getId().getQueryId().getId(), task.getId().getFragmentId().getId(), task.getId().getInstanceId()));
                }
                catch (Exception e) {
                    logger.error("Clear DriverTask failed", (Throwable)e);
                }
            }
        }
    }

    ITaskScheduler getScheduler() {
        return this.scheduler;
    }

    IndexedBlockingQueue<DriverTask> getReadyQueue() {
        return this.readyQueue;
    }

    IndexedBlockingQueue<DriverTask> getTimeoutQueue() {
        return this.timeoutQueue;
    }

    Set<DriverTask> getBlockedTasks() {
        return this.blockedTasks;
    }

    Map<QueryId, Set<DriverTask>> getQueryMap() {
        return this.queryMap;
    }

    void setBlockManager(IMPPDataExchangeManager blockManager) {
        this.blockManager = blockManager;
    }

    private class Scheduler
    implements ITaskScheduler {
        private Scheduler() {
        }

        @Override
        public void blockedToReady(DriverTask task) {
            task.lock();
            try {
                if (task.getStatus() != DriverTaskStatus.BLOCKED) {
                    return;
                }
                task.setStatus(DriverTaskStatus.READY);
                DriverScheduler.this.readyQueue.push(task);
                DriverScheduler.this.blockedTasks.remove(task);
            }
            finally {
                task.unlock();
            }
        }

        @Override
        public boolean readyToRunning(DriverTask task) {
            task.lock();
            try {
                if (task.getStatus() != DriverTaskStatus.READY) {
                    boolean bl = false;
                    return bl;
                }
                task.setStatus(DriverTaskStatus.RUNNING);
            }
            finally {
                task.unlock();
            }
            return true;
        }

        @Override
        public void runningToReady(DriverTask task, ExecutionContext context) {
            task.lock();
            try {
                if (task.getStatus() != DriverTaskStatus.RUNNING) {
                    return;
                }
                task.updateSchedulePriority(context);
                task.setStatus(DriverTaskStatus.READY);
                DriverScheduler.this.readyQueue.push(task);
            }
            finally {
                task.unlock();
            }
        }

        @Override
        public void runningToBlocked(DriverTask task, ExecutionContext context) {
            task.lock();
            try {
                if (task.getStatus() != DriverTaskStatus.RUNNING) {
                    return;
                }
                task.updateSchedulePriority(context);
                task.setStatus(DriverTaskStatus.BLOCKED);
                DriverScheduler.this.blockedTasks.add(task);
            }
            finally {
                task.unlock();
            }
        }

        @Override
        public void runningToFinished(DriverTask task, ExecutionContext context) {
            task.lock();
            try {
                if (task.getStatus() != DriverTaskStatus.RUNNING) {
                    return;
                }
                task.updateSchedulePriority(context);
                task.setStatus(DriverTaskStatus.FINISHED);
                DriverScheduler.this.clearDriverTask(task);
            }
            finally {
                task.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void toAborted(DriverTask task) {
            try (SetThreadName fragmentInstanceName = new SetThreadName(task.getFragmentInstance().getInfo().getFullId(), new Object[0]);){
                task.lock();
                try {
                    if (task.isEndState()) {
                        return;
                    }
                    logger.warn("The task {} is aborted. All other tasks in the same query will be cancelled", (Object)task.getId().toString());
                    DriverScheduler.this.clearDriverTask(task);
                }
                finally {
                    task.unlock();
                }
                QueryId queryId = task.getId().getQueryId();
                Set queryRelatedTasks = (Set)DriverScheduler.this.queryMap.remove(queryId);
                if (queryRelatedTasks != null) {
                    for (DriverTask otherTask : queryRelatedTasks) {
                        if (task.equals(otherTask)) continue;
                        otherTask.lock();
                        try {
                            otherTask.setAbortCause("query cascading aborted");
                            DriverScheduler.this.clearDriverTask(otherTask);
                        }
                        finally {
                            otherTask.unlock();
                        }
                    }
                }
            }
        }
    }

    private static class InstanceHolder {
        private static final DriverScheduler instance = new DriverScheduler();

        private InstanceHolder() {
        }
    }
}

